static char rcsid[] = "@(#)$Id: service_list.c,v 2.8 2017/11/18 16:49:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_misc.h"
#include "s_me.h"
#include "schedule_time.h"
#include "connection_imp.h"
#include "rc_imp.h"

DEBUG_VAR(Debug,__FILE__,"net");

#ifdef REMOTE_MBX

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}

int dump_service_entries(f,mail_services,
			 commentfile,actor,version_buff,
			 fileset,propline)
     FILE *f; 
     struct mail_services_conf *mail_services;
     FILE *commentfile; 
     const char *actor;
     char *version_buff; 
     charset_t fileset;
     const struct editor_propline *propline;
{
    int fail = 0;
    int x;
    enum editor_propline_v propline_mode = 
	give_dt_enumerate_as_int(&editor_ms_propline);
    const char * sysnam = NULL;

    if (! mail_services)
	return 1;
    
    if (MAIL_SERVICES_magic != mail_services->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "add_addr_name_to_entry",
		      "Bad magic ( mail_services_conf)",0);

    if (mail_services->service_count < 1 &&
	!fileset && (! propline || propline_mode == editor_propline_ignore))
	return 1;
 
    if (!fileset) {
	DPRINT(Debug,10,(&Debug,
			 "dump_service_entries: File charset is not set, using system charset\n"));
	fileset = system_charset;    
    }

    sysnam = get_charset_MIME_name(fileset);

    /* Must have first line */
    if (propline_mode != editor_propline_ignore)
	write_editor_propline(propline,propline_mode,
			      f,"# ","\n",fileset);

    if (sysnam) {
	/* Store used character set */

	elm_fprintf(f, 
		    CATGETS(elm_msg_cat,MeSet, MeCharsetExplain,
			    "# Character set used on this file\n"));

	fprintf(f,"@charset = %s\n",sysnam);
    }

    insert_commentfile(f,ELMMAILSERVICES_INFO,commentfile,actor,version_buff);

    for (x = 0; x < mail_services->service_count; x++) {

	if (SERVICE_ENTRY_magic != mail_services->service_list[x]->magic)
	    panic("CONNECTION PANIC",__FILE__,__LINE__,
		  "dump_service_entries",
		  "Bad magic (service_entry)",0);
	
	if (!dump_service_entry(f,mail_services->service_list[x],fileset))
	    fail++;
    }

    if (fail) {
	elm_fprintf(f, 
		    CATGETS(elm_msg_cat,MeSet, MeFailedConvertEntries,
			    "# Failed to convert %d entries to %s -charset\n"),
		    fail,sysnam ? sysnam : "<no MIME name>");
    }

    fflush(f);

    return !fail;
}

static void update_entry P_((struct service_entry *target,
			     struct service_entry *value));
static void update_entry(target,value)
     struct service_entry *target;
     struct service_entry *value;
{
    if (SERVICE_ENTRY_magic != target->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "update_entry",
	      "Bad magic (service_entry) (target)",0);

    if (SERVICE_ENTRY_magic != value->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "update_entry",
	      "Bad magic (service_entry) (value)",0);

    if (target == value)
	return;

    if ((value->flags & SE_given_alias) &&
	value->aliases_count > 0) {  /* Overwrite aliases list */
	int i;

	free_se_aliases_list(target);

	for (i = 0; i < value->addr_name_count; i++) 
	    add_se_alias_to_entry(target,& (value->aliases_list[i]),
				  1 /* malloc it */);
    }
    
    if ((value->flags & SE_given_name_addr) &&
	value->addr_name_count > 0) {
	int i;
	
	free_se_addr_name_list(target) ;

	target->flags |= SE_given_name_addr;

	for (i = 0; i < value->addr_name_count; i++) 
	    add_addr_name_to_entry(target,
				   value->addr_name_list[i],
				   1 /* strdup it */);

    }

    if ((value->flags & SE_given_name_port) &&
	value->port_name_count > 0) {
	int i;

	free_se_port_name_list(target);

	target->flags |= SE_given_name_port;

	for (i = 0; i < value->port_name_count; i++)
	    add_port_name_to_entry(target,
				   value->port_name_list[i],
				   1 /* strdup it */);

    }

    if ((value->flags & SE_given_addr) &&
	value->addr_count > 0) {
	int i;

	free_se_addr_list(target);

	target->flags |= SE_given_addr;

	for (i = 0; i < value->addr_count; i++) 
	    add_se_addr_to_entry(target,& (value->addr_list[i]),
				 1 /* malloc copy */);
	
    }

    if ((value->flags & SE_given_port) &&
	value->port_count > 0) {
	int i;

	free_se_port_list(target);

	target->flags |= SE_given_port;

	for (i = 0; i < value->port_count; i++)
	    add_port_to_entry(target,value->port_list[i]);	

    }

    if (value->option_count > 0) {
	int i;

	for (i = 0; i < value->option_count; i++) {
	    int idx = -1;
	    int j;

	    for (j = 0; j < target->option_count; j++) {
		if (0 == strcmp(value->option_list[i].prefix,
				target->option_list[j].prefix))
		    idx = j;
	    }

	    if (-1 == idx) {

		struct SE_option_type * Y = 
#ifdef USE_DLOPEN
		    get_option_type(value->option_list[i].prefix)
#else
		    NULL
#endif
		;

		if (!Y) 
		    panic("CONNECTION PANIC",__FILE__,__LINE__,
			  "update_entry",
			  "option type disappeared",0);

		idx = add_option_type_to_entry(target,Y,
					       value->option_list[i].prefix);
		
	    } 

	    if (SE_option_t_magic != target->option_list[idx].type->magic)
		panic("CONNECTION PANIC",__FILE__,__LINE__,
		      "update_entry",
		      "Bad option type magic on service list",0);

	    if (target->option_list[idx].type != value->option_list[i].type)
		panic("CONNECTION PANIC",__FILE__,__LINE__,
                      "update_entry",
                      "option type mismatch",0);

	    target->option_list[idx].type->
		update_options(& (target->option_list[idx]),
			       & (value->option_list[i]) );
	}
    }

    if (value->flags & SE_nover_tls_cert) {
	target->flags   |= SE_nover_tls_cert;
	target->flags   &= ~SE_ver_tls_cert;

    } else if (value->flags & SE_ver_tls_cert) {
	target->flags |= SE_ver_tls_cert;
	target->flags &= ~SE_nover_tls_cert;
    }

    if (value->req_tls_peername_list ||
	(value->flags & SE_require_tls_name)) {
	int i;

	free_se_rqtls_pername_list(target);
	       	
	if (value->flags & SE_require_tls_name) { 
	    if (0 == strcmp(value->official_name,target->official_name)) 
		target->flags |= SE_require_tls_name;
	    else {
		struct string * req = new_string2(system_charset,
						  s2us(value->official_name));
		add_req_peername_to_entry(target,req);
		free_string(&req);
		target->flags &= ~SE_require_tls_name;		
	    }
	} else
	    target->flags &= ~SE_require_tls_name;

	for (i = 0; i < value->req_tls_peername_count; i++) 
	    add_req_peername_to_entry(target,
				      value->req_tls_peername_list[i]);	
    }
}

static int match_service_entry P_((const struct service_entry *new,
				   const struct service_entry *old));

static int match_service_entry(new,old)
     const struct service_entry *new;
     const struct service_entry *old;
{
    if (SERVICE_ENTRY_magic != new->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "match_service_entry",
	      "Bad magic (service_entry) (new)",0);

    if (SERVICE_ENTRY_magic != old->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "match_service_entry",
	      "Bad magic (service_entry) (old)",0);

     if (new->service != old->service ||
	 0 != istrcmp(new->official_name,old->official_name)) 
	 return 0;

    if (new->ip_literal_addrsize != old->ip_literal_addrsize) 
	return 0;

    if (new->ip_literal_address.dummy && old->ip_literal_address.dummy &&
	new->ip_literal_addrsize) {

	if (0 != memcmp(new->ip_literal_address.dummy,
			old->ip_literal_address.dummy,
			new->ip_literal_addrsize)) 
	    return 0;
	
    } else if (new->ip_literal_address.dummy || old->ip_literal_address.dummy)
	return 0;

     /* Avoid addr="name" and addr=ip on same entry */

     if ((old->flags & ( SE_given_addr | SE_given_name_addr)) &&
	 (new->flags & ( SE_given_addr | SE_given_name_addr)) &&
	 (old->flags & ( SE_given_addr | SE_given_name_addr)) != 
	 (new->flags & ( SE_given_addr | SE_given_name_addr)))
	 return 0;

     /* Avoid port="service" and port=ddd on same entry */

     if ((old->flags & ( SE_given_port | SE_given_name_port)) &&
	 (new->flags & ( SE_given_port | SE_given_name_port)) &&
	 (old->flags & ( SE_given_port | SE_given_name_port)) !=
	 (new->flags & ( SE_given_port | SE_given_name_port)))
	 return 0;

    return 1;
}

void change_mail_services_conf(conf,new)
     struct mail_services_conf **conf;
     struct mail_services_conf *new;
{
    int count;
    int i;

    if (!*conf) 
	*conf = malloc_mail_services_conf();

    else if (MAIL_SERVICES_magic != (*conf)->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "change_mail_services_conf",
	      "Bad magic (mail_services_conf) (conf)",0);

    if (!new)
	return;

    if (MAIL_SERVICES_magic != new->magic)
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "change_mail_services_conf",
	      "Bad magic (mail_services_conf) new",0);

    if (new->service_count < 1)
	return;

    count = (*conf)->service_count + new->service_count;

    (*conf)->service_list = safe_array_realloc((*conf)->service_list,
					       count, sizeof ((*conf)->service_list[0]));


    for (i = 0; i < new->service_count; i++) {
	int j;

	for (j = 0; j < (*conf)->service_count; j++) {

	    if (match_service_entry(new->service_list[i],
				    (*conf)->service_list[j])) {


		goto set_it;
	    }	
	}

	if (j >= count)
	    panic("CONNECTION PANIC",__FILE__,__LINE__,
		  "change_mail_services_conf","Overflow",0);

	if (j != (*conf)->service_count)
	    panic("CONNECTION PANIC",__FILE__,__LINE__,
		  "change_mail_services_conf","Bad index",0);

	(*conf)->service_list[j] = new->service_list[i];
	inc_service_entry_refcount((*conf)->service_list[j]);
	
	(*conf)->service_count++;
	
	if (0) {
	set_it:

	    update_entry((*conf)->service_list[j],
			 new->service_list[i]);

	    
	}
    }    
}

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
