static char rcsid[] = "@(#)$Id: init.c,v 2.20 2021/07/13 07:58:37 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.20 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_misc.h"
#include "s_elm.h"
#include "conf_writer_imp.h"
#include "rc_imp.h"
#include "save_opts.h"


DEBUG_VAR(Debug,__FILE__,"mime");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(dump_conf_map_f dump_user_iso2022_sets)
static int dump_user_iso2022_sets P_((FILE *f,const char *actor,
				      char *version_buff,
				      int *errno_res));
static int dump_user_iso2022_sets(f,actor,version_buff,errno_res) 
     FILE *f;
     const char *actor;
     char *version_buff;
     int *errno_res;
{
    dump_iso2022_map(f,user_iso2022_map_conf,
		     NULL,actor,version_buff);

    return 1; /* Assume succeed */
}

S_(dump_message_f user_iso2022_sets_written)
static void user_iso2022_sets_written P_((char *fname));
static void user_iso2022_sets_written(fname)
     char *fname;
{
    lib_error(CATGETS(elm_msg_cat, ElmSet, 
		      ElmISO2022SavedIn,
		      "ISO 2022 mappings saved in file %s."), 
	      fname);		    
}

S_(dump_conf_map_f dump_user_mime_charsets)
static int dump_user_mime_charsets P_((FILE *f,const char *actor,
				       char *version_buff,
				       int * errno_res));
static int dump_user_mime_charsets(f,actor,version_buff,errno_res) 
     FILE *f;
     const char *actor;
     char *version_buff;
     int *errno_res;
{
    dump_charset_map(f,user_charset_map,NULL,actor,version_buff,0);

    return 1; /* Assume succeed */
}

S_(dump_message_f user_mime_charsets_written)
static void user_mime_charsets_written P_((char *fname));
static void user_mime_charsets_written(fname)
     char *fname;
{
    lib_error(CATGETS(elm_msg_cat, ElmSet, 
		      ElmCharsetsSavedIn,
		      "Charsets saved in file %s."), 
	      fname);
}

S_(dump_conf_map_f dump_user_terminal_info)
static int dump_user_terminal_info P_((FILE *f,const char *actor,
				       char *version_buff,
				       int *errno_res));
static int dump_user_terminal_info(f,actor,version_buff,errno_res) 
     FILE *f;
     const char *actor;
     char *version_buff;
     int * errno_res;
{
    dump_terminal_map(f,user_terminal_map,NULL,actor,version_buff);

    return 1;
}

S_(dump_message_f user_terminal_info_written)
static void user_terminal_info_written P_((char *fname));
static void user_terminal_info_written(fname)
     char *fname;
{
    lib_error(CATGETS(elm_msg_cat, ElmSet, 
		      ElmTerminalInfoSavedIn,
		      "Additional terminal info saved in file %s."), 
	      fname);
}

S_(dump_conf_map_f dump_user_mime_types)
static int dump_user_mime_types P_((FILE *f,const char *actor,
				    char *version_buff,
				    int * errno_res));
static int dump_user_mime_types(f,actor,version_buff,errno_res) 
     FILE *f;
     const char *actor;
     char *version_buff;
     int *errno_res;
{
    dump_mime_types_map(f,user_mimetypes_map,NULL,actor,version_buff);

    return 1; /* Assume scucceed */
}

S_(dump_message_f user_mime_types_written)
static void user_mime_types_written P_((char *fname));
static void user_mime_types_written(fname)
     char *fname;
{
    lib_error(CATGETS(elm_msg_cat, ElmSet, 
		      ElmContentTypeInfoSavedIn,
		      "Content-type mapping info saved in file %s."), 
	      fname);
}

S_(dump_conf_map_f dump_user_mlist_file)
static int dump_user_mlist_file P_((FILE *f,const char *actor,
				    char *version_buff,
				    int *errno_res));
static int dump_user_mlist_file(f,actor,version_buff,errno_res) 
     FILE *f;
     const char *actor;
     char *version_buff;
     int *errno_res;
{
    dump_mlist_conf(f,user_mlist_conf,NULL,actor,version_buff,
		    user_mlist_cs,user_mlist_pl);

    return 1; /* Assume succeed */
}

S_(dump_message_f user_mlist_file_written)
static void user_mlist_file_written P_((char *fname));
static void user_mlist_file_written(fname)
     char *fname;
{
    lib_error(CATGETS(elm_msg_cat, ElmSet, 
		      ElmMailingListInfoSavedIn,
		      "Mailing lists info saved in file %s."), 
	      fname);
}

struct terminal_map_item * system_terminal_map;
struct terminal_map_item * user_terminal_map;
struct mime_types_item   * system_mimetypes_map;
struct mime_types_item   * user_mimetypes_map;

struct mlist_conf        * system_mlist_conf;
charset_t                  system_mlist_cs;
struct editor_propline   * system_mlist_pl;
struct mlist_conf        * user_mlist_conf;
charset_t                  user_mlist_cs;
struct editor_propline   * user_mlist_pl;

static char * EDITOR_PROPLINE [] = 
    { "auto", "emacs", "ignore", NULL };
ENUMERATE editor_ml_propline = {
    editor_propline_auto,
    NUM_editor_propline,
    &(EDITOR_PROPLINE[0]),
    NULL,
    0   	/* no boolean  */,
    NULL	/* not delayed */,
    NULL
};

static ZZZ_SAVE_TYPE misc_info_data[] = {
    {"editor-ml-propline",   ZZZ_DT_ENUM(&editor_ml_propline), ZZZ_TAIL },
    {"user-conf-rewrite",    ZZZ_DT_BOL(&user_conf_rewrite),   ZZZ_TAIL },
};
static int COUNT=(sizeof(misc_info_data)/sizeof(ZZZ_SAVE_TYPE));
static save_info_recs *misc_info = (save_info_recs *) misc_info_data;

#if ANSI_C
static init_default_hook init_misc_defaults;
#endif
static void init_misc_defaults P_((int *errors));
static void init_misc_defaults(errors)
     int *errors;
{
    DPRINT(Debug,10,(&Debug,"init_misc_defaults: starting\n"));

    system_terminal_map  = load_terminal_map(system_terminal_info,errors);
    system_mimetypes_map = load_mime_types_map(system_mime_types,errors);
    system_mlist_conf    = load_mlist_conf(system_mlist_file,errors,
					   &system_mlist_cs,
					   &system_mlist_pl);

    register_conf_write(USER_ISO2022_SETS,user_iso2022_sets,
			dump_user_iso2022_sets,
			user_iso2022_sets_written,
			NULL /* No automatic rewrite */,
			NO_merge_conf_map);
    register_conf_write(USER_MIME_CHARSETS,user_mime_charsets,
			dump_user_mime_charsets,
			user_mime_charsets_written,
			NULL /* No automatic rewrite */,
			NO_merge_conf_map);
    register_conf_write(USER_TERMINAL_INFO,user_terminal_info,
			dump_user_terminal_info,
			user_terminal_info_written,
			NULL /* No automatic rewrite */,
			NO_merge_conf_map);   
    register_conf_write(USER_MIME_TYPES,user_mime_types,
			dump_user_mime_types,
			user_mime_types_written,
			NULL /* No automatic rewrite */,
			NO_merge_conf_map);
    register_conf_write(USER_MLIST_FILE,user_mlist_file,
			dump_user_mlist_file,
			user_mlist_file_written,
			NULL /* No automatic rewrite */,
			NO_merge_conf_map);

    DPRINT(Debug,10,(&Debug,"init_misc_defaults: done\n"));
}

#if ANSI_C
static init_default_hook misc_read_rc_file;
#endif
static void misc_read_rc_file P_((int *errors));
static void misc_read_rc_file(errors)
     int *errors;
{
    DPRINT(Debug,10,(&Debug,"misc_read_rc_file: starting\n"));

    user_terminal_map  = load_terminal_map(user_terminal_info,errors);
    user_mimetypes_map = load_mime_types_map(user_mime_types,errors);
    user_mlist_conf    = load_mlist_conf(user_mlist_file,errors,
					 &user_mlist_cs,&user_mlist_pl);

    DPRINT(Debug,10,(&Debug,"misc_read_rc_file: done\n"));
}

S_(free_rc_hook free_misc_rc_file)
static void free_misc_rc_file P_((void));
static void free_misc_rc_file() 
{
    DPRINT(Debug,8,(&Debug, "free_mics_rc_file: Freeing config\n"));

    if (user_mlist_conf)
	free_mlist_conf(&user_mlist_conf);
    if (user_mimetypes_map)
	free_mime_types_map(&user_mimetypes_map);
    if (user_terminal_map)
	free_terminal_map(&user_terminal_map);

    if (system_mlist_conf)
	free_mlist_conf(&system_mlist_conf);
    if (system_mimetypes_map)
	free_mime_types_map(&system_mimetypes_map);
    if (system_terminal_map)
	free_terminal_map(&system_terminal_map);

}


void init_misclib(read_flags)
    int read_flags /* READ_FLAG_IGNORE_MISSING */;
{
    register_delayed(misc_info,COUNT,read_flags);
    add_init_default_hook(&init_misc_defaults);
    add_read_rc_file_hook(&misc_read_rc_file);
    add_free_rc_hook(&free_misc_rc_file);
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
