static char rcsid[] = "@(#)$Id: utime_util.c,v 2.1 2020/09/04 07:57:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 utils/newmail.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_mbox.h"

DEBUG_VAR(Debug,__FILE__,"file");


#ifdef I_UTIME
#  include <utime.h>
#endif
#ifdef I_SYSUTIME
#  include <sys/utime.h>
#endif

int change_file_utime(file_name,stat_buffer,errno_res)
     const char *file_name;
     const struct stat *stat_buffer;
     int *errno_res;
{
    int ret = 0;
    
#if defined(BSD_TYPE) && !defined(UTIMBUF)
    time_t utime_buffer[2];         /* utime command */
    
#else
    struct utimbuf utime_buffer;    /* utime command */
#endif
    int r;

#if defined(BSD_TYPE) && !defined(UTIMBUF)
    utime_buffer[0]     = stat_buffer->st_atime;
    utime_buffer[1]     = stat_buffer->st_mtime;
#else
    utime_buffer.actime = stat_buffer->st_atime;
    utime_buffer.modtime= stat_buffer->st_mtime;
#endif

    
#if defined(BSD_TYPE) && !defined(UTIMBUF)
    r = utime(file_name, utime_buffer);
#else
    r = utime(file_name, &utime_buffer);
#endif

    switch(r) {
	int err;
    case -1:
	err = errno;

	DPRINT(Debug,9, (&Debug, "change_file_utime: utime %s failed: %s (errno %d)\n",
			 file_name,strerror(err),err));
			 
	if (errno_res)
	    *errno_res = err;
	break;
    case 0:
	DPRINT(Debug,20, (&Debug, "change_file_utime: utime %s succeed\n",file_name));
	ret = 1;
	break;
    }

    DPRINT(Debug,20, (&Debug, "change_file_utime=%d%s file_name=%s",
		      ret,
		      ret ? " (succeed)" : " (failed)",
		      file_name));
    if (errno_res && *errno_res) {
	DPRINT(Debug,20, (&Debug, " *errno_res=%d",*errno_res));
    }
    DPRINT(Debug,20, (&Debug, "\n"));
    
    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
