static char rcsid[] = "@(#)$Id: state.c,v 2.14 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.14 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  These routines are mainly copied from lib/state.c 
 *
 *  Although state.c is initially written written by Michael Elkins 
 *  these copied routines are newer and not written by Michael Elkins 
 *****************************************************************************/

#include "def_mbox.h"
#include "state_imp.h"
#include "pg_range_imp.h"

DEBUG_VAR(Debug,__FILE__,"stateio");


#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

#define DIRSTATE_out_magic      0xFE01

struct dirstate_out {
    unsigned short          magic;   /* DIRSTATE_out_magic */

    struct folder_browser * dir;
    WRITE_STATE             write_state_ptr;

    int have_ferror;
};

S_(init_so_func init_so_dir)
static void init_so_dir P_((struct out_state *s)); 
static void init_so_dir(s)
     struct out_state *s;
{
    s->u.dir = safe_zero_alloc(sizeof (* s->u.dir));

    s->u.dir->magic           = DIRSTATE_out_magic;
    s->u.dir->dir             = NULL;
    s->u.dir->write_state_ptr = NULL;

    s->u.dir->have_ferror     = 0;
}

S_(dest_so_func dest_so_dir)
static void dest_so_dir P_((struct out_state *s)); 
static void dest_so_dir(s)
     struct out_state *s;
{
    if (DIRSTATE_out_magic != s->u.dir->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"dest_so_dir",
	      "Bad magic number (dirstate)",0);
	          
    s->u.dir->dir             = NULL;
    s->u.dir->write_state_ptr = NULL;
    s->u.dir->magic           = 0;  /* Invalidate */

    free(s->u.dir);
    s->u.dir = NULL;
}

S_(seekable_so_func seekable_so_dir)
static int seekable_so_dir P_((struct out_state *s)); 
static int seekable_so_dir(s)
     struct out_state *s;
{
    int ret = 0;
    long pos = 0;

    if (DIRSTATE_out_magic != s->u.dir->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"seekable_so_dir",
	      "Bad magic number (dirstate)",0);
    
    /* Returns -1 if not seekable, else position */
    if ((pos = tell_dir_write_state(s->u.dir->dir,
				    s->u.dir->write_state_ptr)) >= 0) 
	ret = 1;
    
    DPRINT(Debug,10,(&Debug,
		     "seekable_so_dir=%d (tell_dir_write_state returned %ld)\n",
		     ret,pos));

    return ret;
}

S_(FILE_so_func FILE_so_dir)
static FILE * FILE_so_dir P_((struct out_state *s)); 
static FILE * FILE_so_dir(s)
     struct out_state *s;
{
    return NULL;
}

S_(seek_so_func seek_so_dir)
static int seek_so_dir P_((struct out_state *s, long pos)); 
static int seek_so_dir(s,pos)
     struct out_state *s;
     long pos;
{
    int r = -1;

    if (DIRSTATE_out_magic != s->u.dir->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"seek_so_dir",
	      "Bad magic number (dirstate)",0);

    /* Note reversed return value on functions! */

    if (seek_dir_write_state(s->u.dir->dir,
			     s->u.dir->write_state_ptr,
			     pos))
	r = 0; /* SUCCEES */

    return r;
}

S_(ftell_so_func ftell_so_dir)
static long ftell_so_dir P_((struct out_state *s)); 
static long ftell_so_dir(s)
     struct out_state *s;
{
    long r;

    if (DIRSTATE_out_magic != s->u.dir->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"ftell_so_dir",
	      "Bad magic number (dirstate)",0);

    r = tell_dir_write_state(s->u.dir->dir,s->u.dir->write_state_ptr);

    return r;
}

S_(flush_filter_so_func flush_filter_so_dir)
static void flush_filter_so_dir P_((struct out_state *s, int munge_eoln,
				    int pg_flags,struct pager_range *range,
				    int force_eoln)); 
static void flush_filter_so_dir(s,munge_eoln,pg_flags,range,force_eoln)
     struct out_state *s;
     int munge_eoln;
     int pg_flags;
     struct pager_range *range;   
     int force_eoln;
{
    char * s1 = NULL;
    int l = 0;
    struct string * res = s->filter_line;
    int eoln = 0, len;

    if (range)                 /* Does reply quotation  and [ escaping */
	res = pager_range_change_line(range,s->filter_line,
				      s->filter_on_BOL,
				      s->filter_on_BOR);

    if ((len = string_len(res)) > 0) {   /* Check LF from end */
	uint16 c = give_unicode_from_string(res,len-1);
	
	if (0x000A == c)
	    eoln = 1;
    }

    if (force_eoln && !eoln && (len > 0 || !s->filter_on_BOL)) {
	int x = 0;
	uint16 newline[2];
	
	if (s->EOLN_is_CRLF)
	    newline[x++] = 0x00D /*   CR  '\r' */;
	newline[x++] = 0x000A /*   LF  '\n' */;
	
	DPRINT(Debug,10,(&Debug,
			 "flush_filter_so_dir: Adding newline to filter\n"));
	
	add_unicode_to_string(res,x,newline);
	len += x;
    }

    if (RAW_BUFFER == s->display_charset[0]) {
	const char * MIME_name UNUSED_VAROK = get_string_MIME_name(res);

	DPRINT(Debug,10,(&Debug,
			 "flush_filter_so_dir: Raw copy (data charset %s)%s\n",
			 MIME_name ? MIME_name : "<not set>",
			 munge_eoln ? " -- convert EOLN" : "")); 
	bytestream_from_string(res,&s1,&l); 
    } else {
	struct string * tmp = convert_string(s->display_charset[0],
					     res,0);

	const char * filter_MIME_name UNUSED_VAROK = get_string_MIME_name(res);
	const char * tmp_MIME_name    UNUSED_VAROK = get_string_MIME_name(tmp);

	/* Can't ask just printable characters because we need
	   NLs also ...
	*/
	DPRINT(Debug,10,(&Debug,
			 "flush_filter_so_dir: Conversion %s->%s%s\n",
			 filter_MIME_name ? filter_MIME_name : "<not set>",
			 tmp_MIME_name    ? tmp_MIME_name    : "<not set>",
			 munge_eoln ? " -- convert EOLN" : "")); 
	bytestream_from_string(tmp,&s1,&l); 
	free_string(&tmp);
    }
    
    if (res != s->filter_line)
	free_string(&res);
    
    if (len > 0)
	s->filter_on_BOL = eoln;

    if (munge_eoln) {
	int size = l + 4;
	
	s1 = safe_realloc(s1,size);
	
	/* Take care of CRLF => LF conversion or
	   LF -> CRLF conversion 
	*/
	state_convert_EOLN(s1,&l,size,s);	    
    }

    if (DIRSTATE_out_magic != s->u.dir->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"flush_filter_so_dir",
	      "Bad magic number (dirstate)",0);
    
    if (!write_dir_write_state(s->u.dir->dir,s->u.dir->write_state_ptr,
			       l,s1)) {
	DPRINT(Debug,1,(&Debug,
			"flush_filter_so_dir: start_fd_write_state failed\n"));

	s->u.dir->have_ferror = 1;
    }
    
    free(s1);
}

S_(policy_so_func policy_so_dir)
static int policy_so_dir P_((struct out_state *s, enum state_policy question)); 
static int policy_so_dir(s,question)
     struct out_state *s;
     enum state_policy question;
{
    switch(question) {
    case state_policy_putc_use_filter: return 1;
    case state_policy_flush_via_put:   return 0;
    case state_policy_support_pg_flags: return 0;
    case state_policy_convert_entity:   return 1;
	
    default:
	panic("STATE PANIC",__FILE__,__LINE__,"policy_so_dir",
	      "Bad question",0);
    }

    return 0;
}

S_(putc_so_func putc_so_dir)
static int putc_so_dir P_((struct out_state *s, int ch)); 
static int putc_so_dir(s,ch)
     struct out_state *s;
     int ch;
{
    panic("STATE PANIC",__FILE__,__LINE__,"putc_so_dir",
	  "putc_so_dir called",0);

    return EOF;
}

S_(put_so_func put_so_dir)
static int put_so_dir P_((struct out_state *s, const char *string, int len)); 
static int put_so_dir(s,string,len)
     struct out_state *s;
     const char *string;
     int len;
{
    panic("STATE PANIC",__FILE__,__LINE__,"put_so_dir",
	  "put_so_dir called",0);

    return EOF;
}

S_(ferror_so_func  ferror_so_dir)
static int ferror_so_dir P_((struct out_state *s));
static int ferror_so_dir(s)
     struct out_state *s;
{

    if (DIRSTATE_out_magic != s->u.dir->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"ferror_so_dir",
	      "Bad magic number (dirstate)",0);
   
    return s->u.dir->have_ferror;
}

S_(add_pager_range_func add_pager_range_dir)
static void add_pager_range_dir P_((struct out_state *s, 
				     struct pager_range *range));
static void add_pager_range_dir(s,range) 
     struct out_state *s;
     struct pager_range *range;
{
    /* Nothing to do */
}

S_(putentity_so_func putentity_so_dir)
static enum sout_entity_result putentity_so_dir P_((struct out_state *s,
						     struct out_entity *oe));
static enum sout_entity_result putentity_so_dir(s,oe)
     struct out_state *s;
     struct out_entity *oe;
{
    /* Should not be called */

    return sout_entity_fallback;
}

S_(add_pager_param_func add_pager_param_dir)
static void add_pager_param_dir P_((struct out_state *s, struct pager_range *range,
				     enum pager_param_opcode opcode,
				     struct pager_param_value * param_value));
static void add_pager_param_dir(s,range,opcode,param_value)
     struct out_state *s;
     struct pager_range *range;
     enum pager_param_opcode opcode;
     struct pager_param_value * param_value;
{

    /* Only supported on builtin pager */
}


struct out_state_type STATE_out_dir_type = {
    OUT_STATE_type_magic,

    init_so_dir,
    dest_so_dir,
    seekable_so_dir,
    FILE_so_dir,
    seek_so_dir,
    ftell_so_dir,
    flush_filter_so_dir,
    policy_so_dir,
    putc_so_dir,
    put_so_dir,
    ferror_so_dir,
    add_pager_range_dir,
    putentity_so_dir,
    add_pager_param_dir
};

void set_out_state_dir(dir,write_state_ptr,s)
     struct folder_browser *dir;
     WRITE_STATE  write_state_ptr;
     struct out_state *s;  
{
    if (STATE_out_magic != s->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"set_out_state_dir",
		    "Bad magic number",0);

    if (s->state_type != STATE_out_dir)
	panic("STATE PANIC",__FILE__,__LINE__,"set_out_state_dir",
		    "Bad external type",0);

    if (DIRSTATE_out_magic != s->u.dir->magic)
	panic("STATE PANIC",__FILE__,__LINE__,"set_out_state_dir",
	      "Bad magic number (dirstate)",0);
	
    if (s->u.dir->dir || s->u.dir->write_state_ptr) 
	panic("STATE PANIC",__FILE__,__LINE__,"set_out_state_dir",
	      "Already called",0);
	
    if (!dir || !write_state_ptr)
	panic("STATE PANIC",__FILE__,__LINE__,"set_out_state_dir",
	      "Bad argument",0);

    if (!s->display_charset) 
	panic("STATE PANIC",__FILE__,__LINE__,"set_out_state_dir",
	      "Display_charset -vector must have been set (possible to RAW_BUFFER)",0);

    
    s->u.dir->dir             = dir;
    s->u.dir->write_state_ptr = write_state_ptr;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
