static char rcsid[] = "@(#)$Id: mk_lockname.c,v 2.5 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/mk_lockname.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_mbox.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

static char lock_name[SLEN];

static const char * LOCK = ".lock";

char * mk_lockname(file_to_lock)
     char *file_to_lock;
{
      /** Create the proper name of the lock file for file_to_lock,
            which is presumed to be a spool file full path (see
            get_folder_type()), and put it in the static area lock_name.
            Return lock_name for informational purposes.
      **/

#ifdef XENIX
        /* lock is /tmp/[basename of file_to_lock].mlk */
        elm_sfprintf(lock_name, sizeof lock_name,
		     FRM("/tmp/%.10s.mlk"), rindex(file_to_lock, '/')+1);
#else
        /* lock is [file_to_lock].lock */
        elm_sfprintf(lock_name, sizeof lock_name,
		     FRM("%s%s"), file_to_lock,LOCK);
#endif
        return(lock_name);
}

static char base_name[SLEN];

/* returns base name */
char * is_lockname(name)
     char *name;
{
    char  * r = NULL;
#ifndef XENIX
    
    char *x = strrchr(name,'.');
    
    if (x && 0 == strcmp(x,LOCK)) {
	int l = x - name;

	if (l < sizeof base_name) {

	    strncpy(base_name,name,l);

	    base_name[l] = '\0';
	    
	    r = base_name;
	}
    }
#endif

    return r;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
