static char rcsid[] = "@(#)$Id: headers.c,v 2.12 2021/01/17 18:53:16 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mbox.h"
#include "hdr_imp.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"header");

/* Returns either original body or pointer to buffer, may return NULL on overflow
   Returns also return NULL if body == NULL
*/

const char * header_trim_whitespace_helper(body,buffer,buffer_size)
     const char *body;
     char buffer[];
     size_t buffer_size;
{
    const char * ret = body;

    char * trg = buffer;
    int seen_nospace = 0;
    size_t last_nospace = 0;
    int modified = 0;
    
    const char * walk;
    
    if (!body) {
	DPRINT(Debug,20,(&Debug,"header_trim_whitespace_helper=NULL; no body\n"));
	return NULL;
    }

    for (walk = body; *walk; walk++) {
	if ('\n' == *walk || '\r' == *walk) {
	    
	    if ('\r' == *walk && '\n' == *(walk+1)) 
		walk++;
	    
	    if ('\n' == *walk && whitespace(*(walk+1)))
		walk++;
	    
	    modified = 1;
	    
	    if (trg <  buffer + buffer_size)
		*trg++ = ' ';
	    else
		goto overflow1;
	    
	} else if (!whitespace(*walk)) {
	    seen_nospace = 1;
	    
	    last_nospace = trg - buffer;
	    
	    goto copy;
       	    
	} else if (! seen_nospace) 
	    modified = 1;
	else {
	    
	copy:
	    if (trg <  buffer + buffer_size)
		*trg++ = *walk;
	    else {
		if (modified) {
		overflow1:
		    DPRINT(Debug,20,(&Debug,
				     "header_trim_whitespace_helper=NULL; overflow on %zu octets -- max size %zu\n",
				     walk - body, buffer_size));
		    return NULL;		    
		}
	    }	    
	}
    }

    if (trg > buffer + last_nospace + 1) {
	DPRINT(Debug,20,(&Debug,
			 "header_trim_whitespace_helper: reducing size %zu (original %zu) => %zu\n",
			 trg - buffer,walk - body,last_nospace+1));
	 modified = 1;
	 if (last_nospace + 1 < buffer_size)
	     buffer[last_nospace + 1] = '\0';
	 else
	     goto overflow;
    } else if (trg <  buffer + buffer_size)
	*trg = '\0';
    else {
	if (modified) {
	overflow:
	    DPRINT(Debug,20,(&Debug,
			     "header_trim_whitespace_helper=NULL; overflow on %zu octets -- max size %zu\n",
			     walk - body, buffer_size));
	    return NULL;		    
	}
    }

    if (modified) {
	ret = buffer;
	
	DPRINT(Debug,20,(&Debug,
			 "header_trim_whitespace_helper: %Q => %Q\n",
			 body,buffer));
	
    } else if (0 == strncmp(body,buffer,buffer_size)) {
	DPRINT(Debug,20,(&Debug,
			 "header_trim_whitespace_helper: No changes\n"));
    } else {
	DPRINT(Debug,1,(&Debug,
			"header_trim_whitespace_helper: Bad buffer: %.*s\n",buffer_size,buffer));
    }

    DPRINT(Debug,20,(&Debug,"header_trim_whitespace_helper=%Q%s\n",
		     ret,body==ret ? " (original body)" : " (modified)"));

    return ret;
}


void read_folder_headers_helper(entry,result)
     struct header_rec *entry;
     header_list_ptr result;
{
    header_list_ptr tmphdr;
    charset_t local_header_charset = NULL;

    if (NULL != (tmphdr = locate_header_by_name(result,"Return-Path")) &&
	tmphdr->body
	) {
	/* Required for POP or 
	 * when env_from_source == 2 (env_source_return_path)
	 */
	if (!entry->env_from[0]) {
	    return_path_to_env_from(entry,tmphdr->body);
	}
    }	

    if (NULL != (tmphdr = locate_header_by_name(result,"Content-Length")) &&
	tmphdr->body
	) {
	entry->content_length = atol(tmphdr->body);
    }

    if (NULL != (tmphdr = locate_header_by_name(result,"Expires")) &&
	tmphdr->body
	) {
	process_expiration_date(tmphdr->body, &(entry->status));
    }

    if (NULL != (tmphdr = locate_header_by_name(result,"Date")) &&
	tmphdr->body
	) {
	parse_arpa_date(tmphdr->body, entry);
    }
    
    /* We need accept headers like:
     *    MIME-Version: (MetaSend v1.7) 1.0
     * and
     *    Mime-Version: 1.0 (NeXT Mail 4.2mach_patches v148.2)
     * And if version number is something other accept it but give 
     * warning when message is viewed or replied.
     */
    
    if (NULL != (tmphdr = locate_header_by_name(result,"MIME-Version")) &&
	tmphdr->body
	) {

	char ** tokens = rfc822_tokenize(tmphdr->body);

	remove_space_tokenized(tokens);
	
	if (!tokens[0] || 0 != strcmp(tokens[0],"1") ||
	    !tokens[1] || 0 != strcmp(tokens[1],".") ||
	    !tokens[2] || 0 != strcmp(tokens[2],"0") ||
	    tokens[3]) {
	    int i;
	    entry->status |= MIME_MESSAGE|MIME_UNSUPPORTED;
	    DPRINT(Debug,9,(&Debug, 
			    "read_folder_headers_helper: Unsupported mime version '%s'\n",
			    tmphdr->body));
	    DPRINT(Debug,10,(&Debug, 
			    "      tokens:"));
	    for (i = 0; tokens[i]; i++) {
		DPRINT(Debug,10,(&Debug, 
				 " [%d]=%s",i,tokens[i]));
	    }
	    DPRINT(Debug,10,(&Debug, 
			     "\n"));
	} else {
	    entry->status |= MIME_MESSAGE;
	    DPRINT(Debug,9,(&Debug, 
			    "read_folder_headers_helper: MIME message\n"));
	}

	if (tmphdr->next_this_header &&
	    tmphdr->next_this_header->body &&
	    0 != istrcmp(tmphdr->body,tmphdr->next_this_header->body)) 
	    process_header_error(&(entry->header_error),
				 CATGETS(elm_msg_cat, MeSet, 
					 MeParseErrorMIMEVersion,
					 "PARSE ERROR: Several MIME-Version headers!"));
        

	free_rfc822tokenized(tokens);
    }    

    if (NULL != (tmphdr = locate_header_by_name(result,
						"X-ELM-OSV")) &&
	tmphdr->body
	) {
	char value [20];
	
	if (mime_get_param("no-hdr-encoding",value,tmphdr->body,
			   sizeof value)) {
	    int i = atoi(value);
	    DPRINT(Debug,9,(&Debug,"-- no-hdr-encoding=%d\n",i));
	    if (i) 
		entry->status |= NOHDRENCODING;
	}
	
	if (mime_get_param("hdr-charset",value,tmphdr->body,
			   sizeof value)) {

	    local_header_charset = MIME_name_to_charset(value,CHARSET_create);

	    {
		const char * MIME_name UNUSED_VAROK = 
		    get_charset_MIME_name(local_header_charset);
		
		DPRINT(Debug,9,(&Debug,"-- header-charset=%s\n",MIME_name ? MIME_name : value));
	    }
	}
    }


    

    if (use_char_set_field_hack) {
	header_list_ptr char_set_chack = 
	    locate_header_by_name(result,"Char-Set");
	
	char header_buffer[80];	
	const char * body_value;
	
	/* header_trim_whitespace_helper return either original body or pointer to buffer, 
	   may return NULL on overflow; returns also return NULL if body == NULL
	*/
	if (char_set_chack &&
	    (body_value = header_trim_whitespace_helper(char_set_chack->body,
							header_buffer,
							sizeof header_buffer))) {
		
	    charset_t X = MIME_name_to_charset(body_value,0);
	  
	    if (X) {
		
		const char * MIME_name UNUSED_VAROK = 
		    get_charset_MIME_name(X);
		
		DPRINT(Debug,9,(&Debug,"-- Char-Set: %s\n",MIME_name ? MIME_name : body_value));
		    
		
		if (!local_header_charset)
		    local_header_charset = X;

		if (!entry->default_body_charset)
		    entry->default_body_charset = X;
		
	    } else {
		DPRINT(Debug,9,(&Debug,"-- Char-Set: %s --- skipped\n",body_value));
	    }
	}
    }
    
    if (local_header_charset) {
	entry->header_charset_set = 1;
	
	if (local_header_charset != entry->header_charset) {
	    const char * MIME_name UNUSED_VAROK = 
		get_charset_MIME_name(local_header_charset);

	    if (MIME_name) {
		DPRINT(Debug,9,(&Debug,"-- changing header defcharset to %s\n",MIME_name));
	    }
	    
	    entry->header_charset = local_header_charset;
	}
    }

    
    if (NULL != (tmphdr = locate_header_by_name(result,"Message-ID")) &&
	tmphdr->body 
	) {

	DPRINT(Debug,12,(&Debug,
			 "read_folder_headers_helper: hdr index #%d, message-id %s\n",
			 entry->index_number_X,
			 tmphdr->body));

	if (entry->message_id)
	    free_message_id(& entry->message_id);
	
	entry->message_id = parse_header_message_id("Message-ID",
						    tmphdr->body,
						    (entry -> status &
						     NOHDRENCODING),
						    entry->header_charset,
						    & (entry -> header_error));
	
	if (tmphdr->next_this_header &&
	    tmphdr->next_this_header->body &&
	    0 != istrcmp(tmphdr->body,tmphdr->next_this_header->body)) 
	    process_header_error(&(entry->header_error),
				 CATGETS(elm_msg_cat, MeSet, 
					 MeParseErrorMessageID,
					 "PARSE ERROR: Several Message-ID headers!"));	
    }


    /* Several id:es on In-Reply-To just means several parents, so we can just catenate
       if tehre is several IDes ...
    */

    if (entry->in_reply_to)
	free_references(& entry->in_reply_to);


    for (tmphdr = locate_header_by_name(result,"In-Reply-To");
	 tmphdr;
	 tmphdr = tmphdr -> next_this_header) {

	if (tmphdr->body) {
	    struct references * X = 
		parse_header_references("In-Reply-To",
					tmphdr->body,
					(entry -> status &
					 NOHDRENCODING),
					entry->header_charset,
					& (entry -> header_error));
	    
	    if (X) {
		if (entry->in_reply_to) {
		    append_references(entry->in_reply_to,X);
		    free_references(&X);
		} else 
		    entry->in_reply_to = X;		    
	    }
	}
    }

    /* References header refer thread structure ...
       there several headers are not supported 
    */

    if (NULL != (tmphdr = locate_header_by_name(result,"References")) &&
	tmphdr->body
	) {
	
	if (entry->references)
	    free_references(& entry->references);

	entry->references = 
	    parse_header_references("References",
				    tmphdr->body,
				    (entry -> status &
				     NOHDRENCODING),
				    entry->header_charset,
				    & (entry -> header_error));

	
	if (tmphdr->next_this_header &&
	    tmphdr->next_this_header->body &&
	    0 != istrcmp(tmphdr->body,tmphdr->next_this_header->body)) 
	    process_header_error(&(entry->header_error),
				 CATGETS(elm_msg_cat, MeSet, 
					 MeParseErrorReferences,
					 "PARSE ERROR: Several References headers!"));	
    }

}

header_list_ptr read_folder_headers(read_state_ptr,folder,entry)
     READ_STATE read_state_ptr;
     struct folder_info *folder;
     struct header_rec *entry;
{
    char *buffer;
    int len;

    header_list_ptr result = NULL, last = NULL;

    while (copy_header_folder(folder,read_state_ptr, &buffer,&len)) {
	char * val;
	char * k1;
	
	unfold_header(buffer,&len,entry);
	val = strchr(buffer,':');

	if (!val) {
	    panic("HEADERS PANIC",__FILE__,__LINE__,"read_folder_headers",
		  "bad return from copy_header_folder -- ':' not found",0);
	}


	/* Strip whitespace before ':' */
	k1 = val;
	while(k1 > buffer && 
	      whitespace(*(k1-1))) {
	    k1 --;
	    *k1 = '\0';
	}

	*val = '\0';
	val++;

	/* Skip whitespace after ':' */
	while (whitespace(*val))
	    val++;

	no_ret(val);

	update_header_list(&result,&last,buffer,val);

	free(buffer); buffer = NULL;
    }
    
    read_folder_headers_helper(entry,result);

    return result;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

