static char rcsid[] = "@(#)$Id: expires.c,v 2.4 2018/07/02 11:52:37 hurtta Exp $";

/*****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI) 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *****************************************************************************
 * This code is reimplemented. Original code from Elm 2.4 lib/expires.c 
 * was following copyright:
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine is written to deal with the Expires: header on the
    individual mail coming in.  What it does is to look at the date,
    compare it to todays date, then set the EXPIRED flag on the
    current message if it is true...
**/

#include "def_mbox.h"

DEBUG_VAR(Debug,__FILE__,"misc");

void process_expiration_date(date, message_status)
     char *date;
     int  *message_status;
{
    time_t thetime, expiretime;
#ifndef	_POSIX_SOURCE
    time_t time();
#endif
    
    if (!parse_date_time(date,
			 NULL, 0, NULL, &expiretime,NULL)) {
	DPRINT(Debug,7,(&Debug, 
			"process_expiration_date: \"%s\" unparseable\n", 
			date));
	return;
    }

    thetime = time((time_t *) 0);
    
    DPRINT(Debug,7,
	   (&Debug,
	    "process_expiration_date: \"%s\" -- now %ld, expires %ld\n", 
	    date,(long)thetime, (long)expiretime));

    if (expiretime > thetime)
	return;
    
    /** it's EXPIRED!  Yow!! **/
    
    (*message_status) |= EXPIRED;
    DPRINT(Debug,7,(&Debug,
		    "process_expiration_date: Message is expired\n")); 
    return;
}
      

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

