static char rcsid[] = "@(#)$Id: write_common.c,v 2.2 2020/11/15 16:02:34 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Based on Elm 2.4 src/mailmsg2.c and utils/fastmail.c. 
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *                      Copyright (c) 1988-1992 USENET Community Trust
 *                      Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/


#include "def_mailer.h"

DEBUG_VAR(Debug,__FILE__,"header");


/* NOTE: feed_common_mailing_headers() must have same headers */

void write_common_mailing_headers(fh,headers,message_encoding,encode_hdr,cs,mode)
     struct out_state              * fh;
     struct mailing_headers        * headers;
     enum encoding                   message_encoding; 
     int                             encode_hdr;
     charset_t                       cs;
     enum write_header_mode          mode;   
{

    const char *MIME_name_h = NULL;
    
    DPRINT(Debug,12,(&Debug,
		     "write_common_mailing_headers: message_encoding=%d"));
    switch (message_encoding) {
    case ENCODING_ILLEGAL: DPRINT(Debug,12,(&Debug," ENCODING_ILLEGAL"));  break;
    case ENCODING_NONE:    DPRINT(Debug,12,(&Debug," ENCODING_NONE")); break;
    case ENCODING_7BIT:    DPRINT(Debug,12,(&Debug," ENCODING_7BIT")); break;
    case ENCODING_8BIT:    DPRINT(Debug,12,(&Debug," ENCODING_8BIT")); break;
    case ENCODING_BINARY:  DPRINT(Debug,12,(&Debug," ENCODING_BINARY")); break;
    case ENCODING_QUOTED:  DPRINT(Debug,12,(&Debug," ENCODING_QUOTED")); break;
    case ENCODING_BASE64:  DPRINT(Debug,12,(&Debug," ENCODING_BASE64")); break;
    case ENCODING_EXPERIMENTAL: DPRINT(Debug,12,(&Debug," ENCODING_EXPERIMENTAL")); break;
    case ENCODING_UUENCODED:    DPRINT(Debug,12,(&Debug," ENCODING_UUENCODED")); break;
    case ENCODING_count:            /* size of array */
	DPRINT(Debug,12,(&Debug," ENCODING_count"));
	break;
    }
    DPRINT(Debug,12,(&Debug," encode_hdr=%d cs=%p",encode_hdr,cs));
    
    MIME_name_h = 
	get_charset_MIME_name(cs);
    if (MIME_name_h) {
	DPRINT(Debug,12,(&Debug," %s",MIME_name_h));
    }
    DPRINT(Debug,12,(&Debug," mode=%d",mode));
    switch (mode) {
    case write_header_send:    DPRINT(Debug,12,(&Debug," write_header_send")); break;
    case write_header_copy:    DPRINT(Debug,12,(&Debug," write_header_copy")); break;
    case write_header_preview: DPRINT(Debug,12,(&Debug," write_header_preview")); break;
    }
    DPRINT(Debug,12,(&Debug,"\n"));
    
    /* This is most likely not relevant anymore, but
       original comment was:

       mailmsg2.c: ----
       
       Subject moved to top of headers for mail because the
       pure System V.3 mailer, in its infinite wisdom, now
       assumes that anything the user sends is part of the 
       message body unless either:
       1. the "-s" flag is used (although it doesn't seem
       to be supported on all implementations? )
       2. the first line is "Subject:".  If so, then it'll
       read until a blank line and assume all are meant
       to be headers.
       So the gory solution here is to move the Subject: line
       up to the top.  I assume it won't break anyone elses program
       or anything anyway (besides, RFC-822 specifies that the *order*
       of headers is irrelevant).  Gahhhhh....
    
       fastmail.c: -----

       Subject must appear even if "null" and must be first
	at top of headers for mail because the
	pure System V.3 mailer, in its infinite wisdom, now
	assumes that anything the user sends is part of the 
	message body unless either:
	1. the "-s" flag is used (although it doesn't seem
	   to be supported on all implementations?)
	2. the first line is "Subject:".  If so, then it'll
	   read until a blank line and assume all are meant
	   to be headers.
	So the gory solution here is to move the Subject: line
	up to the top.  I assume it won't break anyone elses program
	or anything anyway (besides, RFC-822 specifies that the *order*
	of headers is irrelevant).  Gahhhhh....

	If we have been configured for a smart mailer then we don't want
	to add a from line.  If the user has specified one then we have
	to honor their wishes.  If they've just given a 'from name' then
	we'll just put in the username and hope the mailer can add the
	correct domain in.
	
    */

    if (headers->subject)
	write_string_header(fh,"Subject",
			    headers->subject,
			    message_encoding,
			    encode_hdr,
			    cs);
    else  /* Anyway -- adding empty Subject: if no Subject given */
	write_text_header(fh,"Subject",
			  "",
			  message_encoding);

    
    {	
	/* Our standard violations */
	char OSV[100];
	OSV[0] = '\0';
	  
	if (!encode_hdr && MIME_name_h)
	    add_parameter(OSV,"hdr-charset",
			  MIME_name_h,sizeof(OSV),FALSE);
	
	/* If allow_no_hdrencoding is set, there is no mime-encoding on
	   user headers either
	*/
	if (allow_no_hdrencoding) {
	    add_parameter(OSV,"no-hdr-encoding","1",sizeof(OSV),FALSE);	    
	}

	if (OSV[0]) {
	    state_printf(fh, 
			 FRM("X-ELM-OSV: (Our standard violations) %s"),
			 OSV);
	    print_EOLN(fh,message_encoding);
	}
    }

    if (headers->sender)
	write_text_header(fh,"Sender",
			  headers->sender,
			  message_encoding);

    if (headers->from.addrs) 
	write_addr_header(fh,"From",
			  headers->from.addrs,
			  message_encoding,
			  encode_hdr,
			  cs,0);

    if (!headers->date) {
	time_t now = 0;
	
	if (((time_t) -1) != time(&now)) {
	    DPRINT(Debug,4,(&Debug,
			    "write_common_mailing_headers: Date: not given, generating it, now=%ld\n",
			    (long)now));
	    headers->date =  new_expanded_date(NULL,now,
					       date_automatic /* automatically gnerated */);
	} else {
	    int err UNUSED_VAROK = errno;
	    
	    DPRINT(Debug,4,(&Debug,
			    "write_header_info: Date: not given, time: %s\n",
			    strerror(err)));
	}
    }
    
    if (headers->date)
	write_date_header(fh,"Date",
			  headers->date,
			  message_encoding);
 
    if (headers->to.addrs)
 	write_addr_header(fh,"To",
			  headers->to.addrs,
 			  message_encoding,
 			  encode_hdr,
 			  cs,1);

    if (headers->reply_to.addrs)
	write_addr_header(fh,"Reply-To",
			  headers->reply_to.addrs,
			  message_encoding,
			  encode_hdr,
			  cs,1);

    if (headers->cc.addrs)
	write_addr_header(fh,"CC",
			  headers->cc.addrs,
			  message_encoding,
			  encode_hdr,
			  cs,1);

    if (headers->bcc.addrs) {
	switch (mode) {
	case write_header_send:
	    /* If there is no To or CC recipients,
	     * show BCC recipients to make mail legal 
	     */
	    if (!headers->to.addrs && !headers->cc.addrs) {
		/* For copy to =sent folder and for preview show BCC recipients */
	    case write_header_copy:
	    case write_header_preview:

		write_addr_header(fh,"Bcc",
				  headers->bcc.addrs,
				  message_encoding,
				  encode_hdr,
				  cs,1);		
	    }
	    break;
	}
    }
    
    if (headers->in_reply_to)
	write_references_header(fh,"In-Reply-To",
				headers->in_reply_to,
				message_encoding,
				encode_hdr,
				cs);

    if (headers->references)
	write_references_header(fh,"References",
				headers->references,
				message_encoding,
				encode_hdr,
				cs);

    if (headers->message_id)
	write_msgid_header(fh,"Message-ID",
			   headers->message_id,
			   message_encoding,
			   encode_hdr,
			   cs);

    if (headers->action)
	write_text_header(fh,"Action",
			  headers->action,
			  encode_hdr);

    if (headers->priority)
	write_text_header(fh,"Priority",
			  headers->priority,
			  message_encoding);

    if (headers->precedence)
	write_text_header(fh,"Precedence",
			  headers->precedence,
			  message_encoding);

    if (headers->expires)
	write_expires_header(fh,"Expires",
			     headers->expires,
			     message_encoding);

    if (headers->xmailer)
    	write_string_header(fh,"X-Mailer",
			    headers->xmailer,
			    message_encoding,
			    encode_hdr,
			    cs);

    if (headers->encoded_user_agent) {
	write_text_header(fh,"User-Agent",
			  headers->encoded_user_agent,
			  encode_hdr);
    }
    
    if (headers->user_header_count > 0) {
	int i;
	for (i = 0; i <  headers->user_header_count; i++) {
	    write_string_header(fh,
				give_header_name(headers->user_header[i].
						 name),
				headers->user_header[i].value,
				message_encoding,
			        encode_hdr,
				cs);
	}
    }

}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
