static char rcsid[] = "@(#)$Id: shared_mailer.c,v 2.13 2022/11/02 16:26:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/*
 * This file is compiled only if dlopen() is available, so
 * that file does not need to be guarded with #ifdef 
 */

#include "def_mailer.h"

DEBUG_VAR(Debug,__FILE__,"dl");

#include "shared_imp.h"
#include "mailer_imp.h"

#include "rc_imp.h"
#include "save_opts.h"


#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(verify_mail_domain_f NO_verify_mail_domain)
static enum verify_domain_status 
  NO_verify_mail_domain P_((const char *domain,char **rewrite,
			    int translated_value  /* -1 if not share specific */,
			    const struct dt_enum_shared * is_shared_value,
			    size_t dt_enum_shared_size,
			    const struct schedule_timelimit * now,
			    size_t                            schedule_timelimit_size,
			    struct schedule_timelimit       * valid_until,
			    struct cancel_data             ** cancel_p 
			    ));
static enum verify_domain_status NO_verify_mail_domain (domain,rewrite,
							translated_value,
							is_shared_value,
							dt_enum_shared_size,
							now,schedule_timelimit_size,
							valid_until,
							cancel_p
							)
     const char *domain;
     char **rewrite;
     int translated_value  /* -1 if not share specific */;
     const struct dt_enum_shared * is_shared_value;
     size_t dt_enum_shared_size;
     const struct schedule_timelimit * now;
     size_t                            schedule_timelimit_size;
     struct schedule_timelimit       * valid_until;
     struct cancel_data             ** cancel_p;
{
    return vd_status_no_routine;
}

S_(check_domain_name_f NO_check_domain_name)
static enum domname_check_status
   NO_check_domain_name P_((const char                      * domainname,
			    char                           ** rewrite,
			    const struct schedule_timelimit * now,
			    size_t                            schedule_timelimit_size,
			    const struct schedule_timelimit * default_valid_until /* for other data */,
			    struct schedule_timelimit       * valid_until,
			    int                             * was_error_p,
			    struct cancel_data             ** cancel_p));
static enum domname_check_status NO_check_domain_name(domainname,rewrite,now,schedule_timelimit_size,
						      default_valid_until,valid_until,was_error_p,
						      cancel_p)
     const char                      * domainname;
     char                           ** rewrite;
     const struct schedule_timelimit * now;
     size_t                            schedule_timelimit_size;
     const struct schedule_timelimit * default_valid_until /* for other data */;
     struct schedule_timelimit       * valid_until;
     int                             * was_error_p;
     struct cancel_data             ** cancel_p;
{
    return dc_status_no_routine;
}



#define SHARED_MAILER_magic	0xF904

struct sl_mailer_data {
    uint16            magic;      

    verify_mail_domain_f * verify_mdomain;
    check_domain_name_f  * check_dname;
};


S_(sl_reg_functions sl_reg_mailer)
static int sl_reg_mailer P_((struct ImpInfo *i,
			      int reg_idx));
static int sl_reg_mailer(i,reg_idx)
     struct ImpInfo *i;
     int reg_idx;
{
    /* union hack to avoid warnings about casting
     * between pointer-to-object and pointer-to-function
     */
    
    int res = 0;
    
    union F14 {
	void *                       ptr;
	provides_shared_MCF_f      * f14;
    } f14;
    
    union F18 {
	void *                       ptr;
	verify_mail_domain_f       * f18;
    } f18;

    union F21 {
	void *                       ptr;
	check_domain_name_f        * f21;
    } f21;
    
    struct reg_list *r = & (i->regs[reg_idx]);

     if (&use_shared_mailer != r->var)
	panic("SHARED PANIC",__FILE__,__LINE__,
	      "sl_reg_mailer",
	      "Wrong variable",0);

     if (r->r.mailer->magic != SHARED_MAILER_magic)
	 panic("SHARED PANIC",__FILE__,__LINE__,
	       "sl_reg_mailer",
	       "Bad magic bumber",0);
     
    f14.ptr = dlsym(i->handle, "provides_shared_MCF");
    f18.ptr = dlsym(i->handle, "verify_mail_domain2");
    f21.ptr = dlsym(i->handle, "check_domain_name");

    if (!f14.f14) {
	DPRINT(Debug,7,(&Debug, " ... NO provides_shared_MCF\n"));
    }
    
    if (!f18.f18) {
	DPRINT(Debug,7,(&Debug, " ... NO verify_mail_domain\n"));
    }
    
    if (!f21.f21) {
	DPRINT(Debug,7,(&Debug, " ... NO check_domain_name\n"));
    }

    
    if (f14.f14) {
	int count;
	size_t s_res14           = 0; 
	size_t s_opt_size        = 0;
	size_t s_send_state_size = 0;
	size_t s_cancel_size     = 0;
	size_t s_mailer_info_size = 0;
	size_t s_env_from_size   = 0;
	
	struct mailer_config *res14 = f14.f14(&count,&s_res14,
					      &s_opt_size,
					      &s_send_state_size,
					      &s_cancel_size,
					      &s_mailer_info_size,
					      &s_env_from_size);
	
	if (s_res14 != sizeof (*res14)) {
	    DPRINT(Debug,1,(&Debug,
			    "...  struct mailer_config mismatch: %d should be %d\n",
			    s_res14,sizeof (*res14)));
	} else if (s_opt_size != sizeof (struct mailer_option_list)) {
	    DPRINT(Debug,1,(&Debug,
			    "...  struct mailer_option_list mismatch: %d should be %d\n",
			    s_opt_size,sizeof (struct mailer_option_list)));

	} else if (s_send_state_size != sizeof (struct mail_send_state)) {
	    DPRINT(Debug,1,(&Debug,
			    "...  struct  mail_send_state mismatch: %d should be %d\n",
			    s_send_state_size,
			    sizeof (struct mail_send_state)));

	} else if (s_cancel_size != sizeof (struct mailer_cancel_ticket)) {
	    DPRINT(Debug,1,(&Debug,
			    "...  struct mailer_cancel_ticket mismatch: %d should be %d\n",
			    s_cancel_size,
			    sizeof (struct mailer_cancel_ticket)));
		   
	} else if (s_mailer_info_size != sizeof (struct mailer_info)) {
	    DPRINT(Debug,1,(&Debug,
			    "...  struct mailer_mailer_info mismatch: %d should be %d\n",
			    
			    s_mailer_info_size,sizeof (struct mailer_info)));

	} else if (s_env_from_size != sizeof (struct mailer_env_from)) {

	    DPRINT(Debug,1,(&Debug,
			    "...  struct mailer_env_from mismatch: %d should be %d\n",
			    s_env_from_size,sizeof (struct mailer_env_from)));


	} else {		
	    int x;
	    
	    shared_MCF_types = 
		safe_array_realloc(shared_MCF_types,
				   (shared_MCF_type_count + count),
				   sizeof (shared_MCF_types[0]));
	    
	    DPRINT(Debug,7,(&Debug,
			    " ... provides_shared_MCF:  (shared_MCF_types) count %d\n",
			    count));
	    
	    for (x = 0; x < count; x++) {
		
		if (MAILER_CONFIG_magic != res14[x].magic) {
		    DPRINT(Debug,1,(&Debug, 
				    "  ...  struct mailer_config [%d] magic mismatch %d (should be %d)\n",
				    x,res14[x].magic,MAILER_CONFIG_magic));
		    goto failure;
		}
				
		shared_MCF_types[shared_MCF_type_count+x].T = &(res14[x]);
		shared_MCF_types[shared_MCF_type_count+x].imp_idx = i;
	    }
	    shared_MCF_type_count += count;
	    res = 1;
	}

    }

    if (f18.f18) {
	DPRINT(Debug,7,(&Debug, " ... verify_mail_domain2\n"));
	
	r->r.mailer->verify_mdomain = f18.f18;
	res = 1;
    }

    if (f21.f21) {
	DPRINT(Debug,7,(&Debug, " ... check_domain_name\n"));

	r->r.mailer->check_dname = f21.f21;
	res = 1;
    }
	
 failure:
    i->regs[reg_idx].valid   = res;

    DPRINT(Debug,7,(&Debug, 
		    "sl_reg_mailer:  [%p]->regs[%d].valid = %d\n",
		    i,reg_idx,res));

    
    return res;
}

S_(sl_zero_reg_list sl_zero_mailer)
static void sl_zero_mailer P_((struct dt_shared_info *var,
				struct reg_list *r));
static void sl_zero_mailer(var,r)
     struct dt_shared_info *var;
     struct reg_list *r;
{
    r->var     = var;
    r->valid   = 0;
    r->r.mailer  = safe_malloc(sizeof (*r->r.mailer));   /* never freed ... */
    
    r->r.mailer->verify_mdomain = NO_verify_mail_domain;
    r->r.mailer->check_dname    = NO_check_domain_name;
    r->r.mailer->magic = SHARED_MAILER_magic;
}

S_(sl_unreg_functions sl_unreg_mailer)
static void sl_unreg_mailer P_((struct ImpInfo *i, int reg_idx));
static void sl_unreg_mailer(i,reg_idx)
     struct ImpInfo *i; 
     int reg_idx;
{
    struct reg_list *r = & (i->regs[reg_idx] );
    r->valid   = 0;

}

static struct shared_loader mailer_loader = {
    SHARED_LOADER_magic,
    sl_reg_mailer,
    sl_zero_mailer,
    sl_unreg_mailer
};

SHAREDLIB use_shared_mailer = {
    &mailer_loader            /* loader */,
    0,                       
    NULL, 0,

    NULL
};

struct mailer_config  * loc_mailer_type(f)
     char *f;
{
    int x;
    
    /* We must load all mailer libraries */
    load_shared_libs1(&use_shared_mailer); 

    for (x = 0; x < shared_MCF_type_count; x++) {
	if (0 == strcmp(shared_MCF_types[x].T->mailer_type,f)) {
	  
	  DPRINT(Debug,10,(&Debug, 
			   "loc_mailer_type=%p: f=%s, shared_MCF_types[%d]\n",
			   shared_MCF_types[x].T,f,x));
	  
	  return shared_MCF_types[x].T;
	}
    }

    DPRINT(Debug,10,(&Debug, 
		     "loc_mailer_type=NULL: f=%s, shared_MCF_type_count=%d\n",
		     f,shared_MCF_type_count));

    return NULL;
}

enum mailerdom_lib_status mailerdom_verify_lib_status(tag, read_flags) 
     const char *tag;
     int read_flags /* READ_FLAG_IGNORE_MISSING */;
{
    enum mailerdom_lib_status ret = mailerdomlib_not_loaded;
    
    /* DO not load library */
    enum verlib_status st = verify_library_prefix(tag,&use_shared_mailer,read_flags);

    DPRINT(Debug,14,(&Debug,
		     "mailerdom_verify_lib_status: tag=%s verify_library_prefix gives %d",
		     tag,st));
    switch (st) {
    case verlib_bad:         DPRINT(Debug,14,(&Debug," verlib_bad"));
	ret = mailerdomlib_bad;
	break;
    case verlib_not_loaded:  DPRINT(Debug,14,(&Debug," verlib_not_loaded"));
	ret = mailerdomlib_not_loaded;
	break;
    case verlib_found:       DPRINT(Debug,14,(&Debug," verlib_found"));
	ret = mailerdomlib_found;
	break;
    case verlib_delayed:     DPRINT(Debug,14,(&Debug," verlib_delayed"));
	ret = mailerdomlib_delayed;
	break;
    }
    DPRINT(Debug,14,(&Debug,"\n"));
	
    DPRINT(Debug,14,(&Debug,"mailerdom_verify_lib_status=%d",ret));
    switch (ret) {
    case mailerdomlib_bad:        DPRINT(Debug,14,(&Debug," mailerdomlib_bad"));        break;
    case mailerdomlib_not_loaded: DPRINT(Debug,14,(&Debug," mailerdomlib_not_loaded")); break;
    case mailerdomlib_found:      DPRINT(Debug,14,(&Debug," mailerdomlib_found"));      break;
    case mailerdomlib_delayed:    DPRINT(Debug,14,(&Debug," mailerdomlib_delayed"));    break;
    }
    DPRINT(Debug,14,(&Debug,"\n"));
    return ret;

}


static enum verify_domain_status process_one_verify_domain 
    P_((const char * domain,
	char      ** rewrite,
	int translated_value,
	const struct dt_enum_shared * is_shared_value,
	int var_index,
	const struct schedule_timelimit * now,
	struct schedule_timelimit       * valid_until,
	struct cancel_data             ** cancel_p 
	));
static enum verify_domain_status process_one_verify_domain(domain,rewrite,
							   translated_value,
							   is_shared_value,
							   var_index,now,
							   valid_until,cancel_p)
     const char * domain;
     char      ** rewrite;
     int translated_value;
     const struct dt_enum_shared * is_shared_value;
     int var_index;
     const struct schedule_timelimit * now;
     struct schedule_timelimit       * valid_until;
     struct cancel_data             ** cancel_p;
{
    if (var_index < 0 || var_index >= use_shared_mailer.shared_list_len)
	    panic("SHARED PANIC",__FILE__,__LINE__,
		  "process_one_verify_domain",
		  "Bad var index",0);

    if (use_shared_mailer.shared_list[var_index]->handle) {
	int r = give_rnum(use_shared_mailer.shared_list[var_index],
			  &use_shared_mailer);

	struct sl_mailer_data * mailer = 
	    use_shared_mailer.shared_list[var_index]->regs[r].r.mailer;

	if (SHARED_MAILER_magic != mailer->magic)
	    panic("SHARED PANIC",__FILE__,__LINE__,
		  "process_one_verify_domain",
		  "Bad magic number",0);

	if (use_shared_mailer.shared_list[var_index]->regs[r].valid)
	    return mailer->verify_mdomain(domain,
					  rewrite,
					  translated_value,
					  is_shared_value,
					  sizeof (* is_shared_value),
					  now,
					  sizeof (* now),
					  valid_until,cancel_p);
    } 
	
    return vd_status_no_routine;
}

enum verify_domain_result shared_verify_domain(domain,rewrite,tag,
					       translated_value,
					       is_shared_value,
					       now,
					       valid_until,cancel_p)
     const char * domain;
     char      ** rewrite;
     const char * tag; 
     int          translated_value;
     const struct dt_enum_shared * is_shared_value;
     const struct schedule_timelimit * now;
     struct schedule_timelimit       * valid_until;
     struct cancel_data             ** cancel_p
     /* May be NULL, Used if dns lookup was cancelable */;

{
    enum verify_domain_status r = vd_status_no_routine;

    if (tag) {
	int basic_index = locate_and_load_library1(tag,
						   &use_shared_mailer);

	if (basic_index < 0) {
	    DPRINT(Debug,9,(&Debug, 
			    "shared_verify_domain=%d verify_domain_not_available: %s, tag %s not found\n",
			    verify_domain_not_available,domain,tag));

	    return verify_domain_not_available;
	}

	post_init_shared_opt1(&use_shared_mailer,basic_index);
	
	r = process_one_verify_domain(domain,rewrite,translated_value,
				      is_shared_value,basic_index,
				      now,valid_until,cancel_p);

	if (vd_status_failure == r  &&
	    cancel_p && *cancel_p && is_canceled(*cancel_p)) {
	    DPRINT(Debug,9,(&Debug,
			     "shared_verify_domain: %s: DNS lookup canceled\n",
			     hostname));

	    goto fail;
	}
	
    } else { 
	enum verify_domain_status saved_r = vd_status_no_routine;
	int i;
	struct schedule_timelimit saved_V = *now;
	   	
	/* must load all libraries */
	load_shared_libs1(&use_shared_mailer);

	/* And handle options */
	post_init_shared_options1(&use_shared_mailer); 

	
	for (i = 0; i < use_shared_mailer.shared_list_len; i++) {
	    struct schedule_timelimit V = *now;
	    if (valid_until)
		V = *valid_until;
	    
	    r = process_one_verify_domain(domain,rewrite,-1,NULL,i,
					  now,
					  valid_until ? &V : NULL,
					  cancel_p);
	    
	    if (vd_status_failure == r  &&
		cancel_p && *cancel_p && is_canceled(*cancel_p)) {
		DPRINT(Debug,9,(&Debug,
				"shared_verify_domain: %s: DNS lookup canceled\n",
				hostname));
		
		goto fail;
	    }

	    if (vd_status_fallback == r) {
		saved_r = r;
		saved_V = V;
	    } else if (vd_status_no_routine != r) {
		if (valid_until)
		    *valid_until = V;
		break;
	    }

	    if (rewrite && *rewrite) {
		free(*rewrite);
		*rewrite = NULL;
	    }
	}
	
	if (vd_status_no_routine == r) {
	    r = saved_r;
	    if (valid_until)
		*valid_until = saved_V;
	}
    }
    
 fail:

    if (valid_until) {
	char * A = schedule_timeout_string(valid_until);
	if (A) {
	   DPRINT(Debug,9,(&Debug,
			   "shared_verify_domain: %s, valid until %s\n",
			   domain,A));
	   free(A);
	}
    }
    
    switch(r) {
    case vd_status_no_routine: 
	DPRINT(Debug,9,(&Debug, 
			"shared_verify_domain=%d verify_domain_not_available: %s\n",
			verify_domain_not_available,domain));
	return verify_domain_not_available;
    case vd_status_fallback:   
	DPRINT(Debug,9,(&Debug, 
			"shared_verify_domain=%d verify_domain_fallback: %s\n",
			verify_domain_fallback,domain));
	return verify_domain_fallback;
    case vd_status_failure:    
	DPRINT(Debug,9,(&Debug, 
			"shared_verify_domain=%d verify_domain_failure: %s\n",
			verify_domain_failure,domain));
	return verify_domain_failure;
    case vd_status_not_found:  
	DPRINT(Debug,9,(&Debug, 
			"shared_verify_domain=%d verify_domain_not_found: %s\n",
			verify_domain_not_found,domain));
	return verify_domain_not_found;
    case vd_status_verified:    
	DPRINT(Debug,9,(&Debug, 
			"shared_verify_domain=%d verify_domain_ok: %s",
			verify_domain_ok,domain));

	if (rewrite && *rewrite) {
	    DPRINT(Debug,9,(&Debug,", rewrite to: %s",
			    *rewrite));
	}
	DPRINT(Debug,9,(&Debug,"\n"));
	return verify_domain_ok;
    case vd_domain_no_mail:
	DPRINT(Debug,9,(&Debug, 
			"shared_verify_domain=%d verify_domain_no_mail: %s",
			verify_domain_no_mail,domain));

	if (rewrite && *rewrite) {
	    DPRINT(Debug,9,(&Debug,", rewrite to: %s",
			    *rewrite));
	}
	DPRINT(Debug,9,(&Debug,"\n"));
	return verify_domain_no_mail;
    case vd_domain_bad_syntax:
	DPRINT(Debug,9,(&Debug, 
			"shared_verify_domain=%d verify_domain_bad_syntax: %s\n",
			verify_domain_bad_syntax,domain));
	return verify_domain_bad_syntax;
    }

    return verify_domain_failure;

}


enum domname_check_status process_one_check_domname P_((const char                      * domainname,
							char                           ** rewrite,
							int                               var_index,
							const struct schedule_timelimit * now,
							const struct schedule_timelimit * default_valid_until
							/* for other data */,			 
							struct schedule_timelimit       * valid_until,
							int                             * was_error_p,
							struct cancel_data             ** cancel_p));
enum domname_check_status process_one_check_domname(domainname,rewrite,var_index,
						    now,default_valid_until,valid_until,
						    was_error_p,cancel_p)
     const char                      * domainname;
     char                           ** rewrite;
     int                               var_index;
     const struct schedule_timelimit * now;
     const struct schedule_timelimit * default_valid_until /* for other data */;			  
     struct schedule_timelimit       * valid_until;
     int                             * was_error_p;
     struct cancel_data             ** cancel_p;
{
    if (var_index < 0 || var_index >= use_shared_mailer.shared_list_len)
	    panic("SHARED PANIC",__FILE__,__LINE__,
		  "process_one_check_domname",
		  "Bad var index",0);

    if (use_shared_mailer.shared_list[var_index]->handle) {
	int r = give_rnum(use_shared_mailer.shared_list[var_index],
			  &use_shared_mailer);

	struct sl_mailer_data * mailer = 
	    use_shared_mailer.shared_list[var_index]->regs[r].r.mailer;

	if (SHARED_MAILER_magic != mailer->magic)
	    panic("SHARED PANIC",__FILE__,__LINE__,
		  "process_one_check_domname",
		  "Bad magic number",0);

		if (use_shared_mailer.shared_list[var_index]->regs[r].valid)
		    return mailer->check_dname(domainname,
					       rewrite,
					       now,
					       sizeof (* now),
					       default_valid_until,	   
					       valid_until,
					       was_error_p,
					       cancel_p);

    }
    
    return dc_status_no_routine;
}


enum check_dname_result shared_check_dname(domainname,rewrite,tag,
					   now,default_valid_until,
					   valid_until,was_error_p,cancel_p)
     const char                      * domainname;
     char                           ** rewrite;
     const char                      * tag;
     const struct schedule_timelimit * now;
     const struct schedule_timelimit * default_valid_until  /* for other data */;	       
     struct schedule_timelimit       * valid_until;
     int                             * was_error_p;
     struct cancel_data             ** cancel_p
     /* May be NULL, Used if dns lookup was cancelable */;
{
    enum check_dname_result       ret = check_dname_failure;  /* No mapping for status */
    enum domname_check_status       r = dc_status_no_routine;
    
    if (tag) {

	int basic_index = locate_and_load_library1(tag,
						   &use_shared_mailer);

	if (basic_index < 0) {
	    DPRINT(Debug,9,(&Debug, 
			    "shared_check_dname: %s, tag %s not found\n",
			    domainname,tag));
	    
	    ret = check_dname_no_routine;
	    goto bailout;
	}

	post_init_shared_opt1(&use_shared_mailer,basic_index);
	
	r = process_one_check_domname(domainname,rewrite,basic_index,
					  now, default_valid_until,
					  valid_until,
					  was_error_p,cancel_p);

	if (dc_status_failure == r &&
	    cancel_p && *cancel_p && is_canceled(*cancel_p)) {
	    DPRINT(Debug,9,(&Debug,"shared_check_dname: %s: DNS lookup canceled\n",
			    domainname));
	    goto fail;
	}
	
    } else {
	enum domname_check_status saved_r = dc_status_no_routine;
	int i;
	struct schedule_timelimit saved_V = *now;
	
	/* must load all libraries */
	load_shared_libs1(&use_shared_mailer);

	/* And handle options */
	post_init_shared_options1(&use_shared_mailer); 

	
	for (i = 0; i < use_shared_mailer.shared_list_len; i++) {
	    struct schedule_timelimit V = *now;
	    if (valid_until)
		V = *valid_until;
	    
	    r = process_one_check_domname(domainname,rewrite,i,
					  now, default_valid_until,
					  valid_until ? &V : NULL,
					  was_error_p,cancel_p);
	    
	    if (dc_status_failure == r &&
		cancel_p && *cancel_p && is_canceled(*cancel_p)) {
		DPRINT(Debug,9,(&Debug,"shared_check_dname: %s: DNS lookup canceled\n",
				domainname));
		goto fail;
	    }
	    
	    if (dc_status_query_blacklisted == r) {
		saved_r = r;
		saved_V = V;
	    } else if (dc_status_no_routine != r) {
		if (valid_until)
		    *valid_until = V;
		break;
	    }
	    
	    if (rewrite && *rewrite) {
		free(*rewrite);
		*rewrite = NULL;
	    }	
	}
	
	if (dc_status_no_routine == r) {
	    r = saved_r;
	    if (valid_until)
		*valid_until = saved_V;
	}
    }
   
 fail:

    DPRINT(Debug,9,(&Debug,
		    "shared_check_dname: %s",domainname));
    
    if (valid_until) {
	char * A = schedule_timeout_string(valid_until);
	if (A) {
	    DPRINT(Debug,9,(&Debug,", valid until %s",
			    A));
	    free(A);
	}
    }

    if (rewrite && *rewrite) {
	DPRINT(Debug,9,(&Debug,", rewrite to: %s",
			*rewrite));
    }
    
    DPRINT(Debug,9,(&Debug,", r=%d",r));
    switch (r) {
    case dc_status_no_routine:
	DPRINT(Debug,9,(&Debug," dc_status_no_routine => check_dname_no_routine"));
	ret = check_dname_no_routine;
	break;
    case dc_status_query_blacklisted:
	DPRINT(Debug,9,(&Debug," dc_status_query_blacklisted => check_dname_query_blacklisted"));
	ret = check_dname_query_blacklisted;
	break;
    case dc_status_failure:
	DPRINT(Debug,9,(&Debug," dc_status_failure => check_dname_failure"));
	ret =  check_dname_failure;
	break;
    case dc_status_not_found:
	DPRINT(Debug,9,(&Debug," dc_status_not_found => check_dname_not_found"));
	ret = check_dname_not_found;
	break;
    case dc_status_have_name:
	DPRINT(Debug,9,(&Debug," dc_status_have_name => check_dname_have_name"));
	ret = check_dname_have_name;
	break;
    case dc_status_bad_syntax:
	DPRINT(Debug,9,(&Debug," dc_status_bad_syntax => check_dname_bad_syntax"));
	ret = check_dname_bad_syntax;
	break;
    }
    DPRINT(Debug,9,(&Debug,"\n"));

 bailout:
    
    DPRINT(Debug,9,(&Debug,"shared_check_dname=%d",ret));
    switch (ret) {
    case check_dname_no_routine:        DPRINT(Debug,9,(&Debug," check_dname_no_routine")); break;
    case check_dname_query_blacklisted: DPRINT(Debug,9,(&Debug," check_dname_query_blacklisted"));
	break;
    case check_dname_failure:           DPRINT(Debug,9,(&Debug," check_dname_failure")); break;
    case check_dname_not_found:         DPRINT(Debug,9,(&Debug," check_dname_not_found")); break;
    case check_dname_have_name:         DPRINT(Debug,9,(&Debug," check_dname_have_name")); break;
    case check_dname_bad_syntax:        DPRINT(Debug,9,(&Debug," check_dname_bad_syntax")); break;
    }    
    DPRINT(Debug,9,(&Debug,": %s",
		    domainname));
    if (rewrite && *rewrite) {
	DPRINT(Debug,9,(&Debug,", rewrite to: %s",
			*rewrite));
    }
    DPRINT(Debug,9,(&Debug,"\n"));
    
    return ret;
}

 /*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
