static char rcsid[] = "@(#)$Id: mime_encode.c,v 2.3 2020/05/21 02:58:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *            or Kari Hurtta <elm@elmme-mailer.org>
 *
 * Moved base64_encode(), line_quoted_printable_encode() and
 * quoted_printable_encode(), add_parameter() from src/mime_encode.c
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "def_mailer.h"

DEBUG_VAR(Debug,__FILE__,"mime");


void base64_encode (srcfp, mailer, istext, top_encoding, source_is_binary)
     FILE *srcfp;
     struct out_state *mailer;
     int istext;
     int top_encoding;
     int source_is_binary;
{
  int c1, c2, c3 = 0;
  int ch1, ch2, ch3, ch4;
  int chars = 0;
  int last_c = 0;

  DPRINT(Debug,9,(&Debug, 
		   "base64_encode: istext=%d, top_encoding=%d\n",
		   istext,top_encoding));

  if (source_is_binary) {  /* EOLN is already coded as CR LF */
      DPRINT(Debug,9, (&Debug,
		       "base64_encode: source_is_binary set, setting istext=0\n"));
      istext = 0;
  }

  for (;;) {
      c1 = fgetc (srcfp);
      if (c1 == -1)
	  break;
      if (istext && last_c != '\r' && c1 == '\n') {
	  /* In text end of line must be coded as CR LF */
	  c1 = '\r';
	  c2 = '\n';
      }
      else
	  c2 = fgetc (srcfp);

      if (istext && c1 != '\r' && c2 == '\n') {
	  /* In text end of line must be coded as CR LF */
	  c2 = '\r';
	  c3 = '\n';
      }
      else if (c2 != -1)
	  c3 = fgetc (srcfp);
 
      if (istext && c2 != '\r' && c3 == '\n') {
	  /* In text end of line must be coded as CR LF */
	  ungetc(c3,srcfp);
	  c3 = '\r';
      }
      
      last_c = c3;
 
      ch1 = c1 >> 2;
      ch1 = to64(ch1);
      
      if (c2 != -1) {
	  ch2 = ((c1 & 0x3) << 4) | (c2 >> 4);
      ch2 = to64(ch2);
      
      if (c3 != -1) {
	  ch3 = ((c2 & 0xf) << 2) | (c3 >> 6);
	  ch3 = to64(ch3);
	  ch4 = c3 & 0x3f;
	  ch4 = to64(ch4);
      }
      else {
	  ch3 = (c2 & 0xf) << 2;
	  ch3 = to64(ch3);
	  ch4 = '=';
      }
      }
      else {
	  ch2 = (c1 & 0x3) << 4;
	  ch2 = to64(ch2);
	  ch3 = '=';
	  ch4 = '=';
      }
      
      state_putc (ch1, mailer);
      state_putc (ch2, mailer);
      state_putc (ch3, mailer);
      state_putc (ch4, mailer);
      chars += 4;
      
      if (chars >= 76) {
	  /* Uses also mailer->EOLN_is_CRLF, so encoding_top is not required */
	  print_EOLN(mailer,top_encoding);
	  chars = 0;
      }	
  }
  
  /* Uses also mailer->EOLN_is_CRLF, so encoding_top is not required */
  print_EOLN(mailer,top_encoding);
  
  return;
}


void line_quoted_printable_encode (input,mailer,len,istext,top_encoding,
				   source_is_binary) 
     char *input;
     struct out_state *mailer;
     int len; /* length of data -- be binary clean */
     int istext; /* if binary (not text) also CRLF need to be encoded */
     int top_encoding;
     int source_is_binary;
{
    int chars = 0;
    char buffer[STRING];
    unsigned char c1, c2, c3;
    unsigned char lastchar = 0;
    unsigned char lastchar2 = 0;
  
    DPRINT(Debug,9,(&Debug,  
		    "line_quoted_printable_encode: len=%d, istext=%d, top_encoding=%d,source_is_binary=%d\n",
		    len,istext, top_encoding,source_is_binary));
    
    if (istext) {  
	if (source_is_binary) { /* EOLN is already coded as CR LF */
	    
	   if (len > 1 && 
	       input[len-2] == '\r' && input[len-1] == '\n') { 
	    
	       lastchar2 = input[len-2];
	       lastchar  = input[len-1];
	       
	       len -= 2;
	   }
	   
	} else {
	    if (len > 0 && input[len-1] == '\n') {
		lastchar = input[len-1];
		input[len-1] = '\0';
		len--;
		if (len > 0 && input[len-1] == '\r')  {   /* Was CR LF */
		    lastchar2 = input[len-1];
		    input[len-1] = '\0';
		    len--;
		} else if (top_encoding == ENCODING_BINARY ||
			   out_state_EOLN_is_CRLF(mailer))
		    lastchar2 = '\r';     /* Simulate it */
	    }
	}
    }
    
    /* I don't test agaist macros bacause these encodings are recommended
     * according MIME Draft Standard anyway and MIME encodings are
     * reversible.
     *
     * DONT_ESCAPE_MESSAGES refers '>' escaping -- not reversible
     * MIME encoding -- '>' escaping was not reversible -- this is.
     *
     * We also want do these encodings when sending (copy == 0)
     * not only when copying to another folder 
     *            -- K E H <hurtta@dionysos.FMI.FI>                     */

    while (len > 0)  {
	/* Assume that buffer don't have newlines (or they have binary data) ...
	   this routine encodes one line */
	c1 = (unsigned char) *input++;
	len--;

	if (c1 == '=') {
	    if (chars > 72) {	    
		buffer[chars++] = '=';
		buffer[chars++] = '\0';
		chars = 0;
		
		state_puts (buffer, mailer);

		/* Uses also mailer->EOLN_is_CRLF, so top_encoding is not required */
		print_EOLN(mailer,top_encoding);
	    }
	    buffer[chars++] = '=';
	    buffer[chars++] = '3';
	    buffer[chars++] = 'D';
	}    
	/*  printable characters -- EXCEPT:   Encode "From " in beginning */
	else if (((c1 > 31 && c1 < 127) && 
		  ((c1 != ' ' || chars != 4 || 
		    strncmp(buffer,"From",4) != 0)
		   /* Encode "." if only in line alone */
		   && (c1 != '.' || chars != 0 || len > 0)
		   /* Last space must encode also */
		   && (c1 != ' ' || len > 0))) 
		 ||
		 (c1 == 9 && len > 0 && istext)) { 
	    /* Don't make sense wrap before last character, when last character
	     * is not encoded -- wrapping and character use equal number of columns.
	     * But left space for '=\n' if we will print it in end of function
	     * instead of '\n'. */
	    if (chars > 74 && (len > 0 || !lastchar)) {
		buffer[chars++] = '=';
		buffer[chars++] = '\0';
		chars = 0;
		
		state_puts (buffer, mailer);

		/* Uses also mailer->EOLN_is_CRLF, so top_encoding is not required */
		print_EOLN(mailer,top_encoding);
	    }
	    buffer[chars++] = c1;
	}
	else {
	    if (chars > 72) {
		buffer[chars++] = '=';
		buffer[chars++] = '\0';
		chars = 0;
		
		state_puts (buffer, mailer);

		/* Uses also mailer->EOLN_is_CRLF, so top_encoding is not required */
		print_EOLN(mailer,top_encoding);
	    }
	    c2 = (c1 >> 4) & 0xf;
	    c3 = c1 & 0xf;
	    buffer[chars++] = '=';
	    buffer[chars++] = hexchars[c2];
	    buffer[chars++] = hexchars[c3];
	}
    }
    
    /* Make sure to flush the buffer.  */
    if (chars > 0) {
	buffer[chars] = '\0';
	state_puts (buffer, mailer);
    }
    if (lastchar2)
	state_putc (lastchar2, mailer);
    if (lastchar) {
	state_putc(lastchar,mailer);
    } else { /* If input line don't terminate NL then print shoft wrap to end
	      * instead of hard NL */
	state_puts ("=", mailer);

	/* Uses also mailer->EOLN_is_CRLF, so top_encoding is not required */
	print_EOLN(mailer,top_encoding);
    }
}



void quoted_printable_encode(srcfp, mailer, istext, top_encoding, source_is_binary)
     FILE *srcfp;
     struct out_state *mailer;
     int istext;  /* if binary (not text) also CRLF need to be encoded */
     int top_encoding;
     int source_is_binary;
{
    char buffer[VERY_LONG_STRING];
    int len;
    
    DPRINT(Debug,10,(&Debug, 
		     "quoted_printable_encode: istext=%d, top_encoding=%d, source_is_binary=%d\n",
		     istext,top_encoding, source_is_binary));
    
    if (istext) {
	/* mail_gets is in ../lib -- it handles also NUL characters */
	while ((len = mail_gets (buffer, sizeof buffer, srcfp)) > 0)
	    line_quoted_printable_encode (buffer, mailer, len, istext,
					  top_encoding,source_is_binary);
    } else {
	/* mail_gets may add LF to end of file if file don't end with LF
	 * So it is not good for binary data */
	while ((len = fread(buffer, 1, sizeof(buffer), srcfp)) > 0)
	    line_quoted_printable_encode (buffer, mailer, len, istext,
					  top_encoding,source_is_binary);
    }
    
    return;
}

void add_parameter(opts,name,value,size,quoted) 
     char *opts;
     const char *name, *value;
     int size, quoted;
{
    int len = strlen(opts);
    int ln = strlen(name);
    char * ptr = opts + len;
    int need_quotation = 0;
    
    /* Following characters require quotation: ( ) < > @ , ; : \ " / [ ] ? =
     * Also whitespace requires quotation. See Mime Draft Standard
     */
    if (!quoted && (NULL != strpbrk(value,"()<>@,;:\\\"/[]?= \t")
		    || value[0] == '\0'))
	need_quotation = 1;
    
    if (len + strlen(value) + ln + 4 + 2 * need_quotation > size)
	return; /* Don't fit anyway */
    
    if (ptr != opts) {
	*ptr++ = ';'; *ptr++ = ' ';
    }
    if (need_quotation) 
	elm_sfprintf(ptr,size - (ptr-opts),FRM("%s=%Q"),
		 name,value);
    else
	elm_sfprintf(ptr,size - (ptr-opts),FRM("%s=%s"),
		     name,value);
    return;
}

 
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
