static char rcsid[] = "@(#)$Id: init.c,v 2.14 2020/05/22 06:15:54 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.14 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mailer.h"
#include "hdr_imp.h"
#include "rc_imp.h"
#include "save_opts.h"
#ifdef USE_DLOPEN
#include "shared_imp.h"
#endif
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"mailer");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif


static ZZZ_SAVE_TYPE mailer_info_data[] = {
    { "generate-message-id",  ZZZ_DT_FUNC_(FL_SHOWSYS,message_id_func), ZZZ_TAIL },
    {"mailer",                ZZZ_DT_FUNC_(FL_SYS,mailerfunc), ZZZ_TAIL },
#ifdef USE_DLOPEN
    {"use-mailer-library",    ZZZ_DT_SHARED(&use_shared_mailer), ZZZ_TAIL },
#endif
};

static int COUNT=(sizeof(mailer_info_data)/sizeof(ZZZ_SAVE_TYPE));
static save_info_recs *mailer_info = (save_info_recs *) mailer_info_data;


S_(env_from_change_hook real_env_from_change)
static int real_env_from_change P_((struct mailer_env_from *X,
				     const char * value));

static int real_env_from_change(X,value)
     struct mailer_env_from *X;
     const char * value;
{
    int r =  mailer_env_from_change(X,value);
    
    DPRINT(Debug,8,(&Debug,"real_env_from_change=%d; value=%s\n",
		    r,value));
    
    return r;
}



void init_mailerlib(read_flags)
     int read_flags /* READ_FLAG_IGNORE_MISSING */;
{


    init_default_mailer(read_flags);
    set_env_from_change_hook(real_env_from_change);
    register_delayed(mailer_info,COUNT,
		     read_flags
		     );

#ifdef USE_DLOPEN
    register_list(&use_shared_mailer);
#endif

    add_init_default_hook(&init_mailer_defaults);
    add_free_rc_hook(&message_id_free_rc);
    add_free_rc_hook(&free_senderhelper);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
