static char rcsid[] = "@(#)$Id: getfullnam.c,v 2.4 2014/07/14 15:07:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/getfullname.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** 

**/

#include "elm_defs.h"
#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif

DEBUG_VAR(Debug,__FILE__,"config");

char * get_full_name(logname)
     char *logname;
{
    /* return a pointer to the full user name for the passed logname
     * or NULL if cannot be found
     * If PASSNAMES get it from the gcos field, otherwise get it
     * from ~/.fullname.
     */
    
    struct passwd *pass;
    
    if((pass = getpwnam(logname)) == NULL)
	return(NULL);
    
    return get_fullname1(pass,logname);
}

char * get_fullname1(pass,logname)
     struct passwd *pass;
     const char *logname;
{
#ifndef PASSNAMES
    FILE *fp;
    char fullnamefile[SLEN];
#endif
    static char fullname[SLEN];

#ifdef PASSNAMES	/* get full_username from gcos field */
    strfcpy(fullname, gcos_name(pass->pw_gecos, logname),
		sizeof fullname);
#else			/* get full_username from ~/.fullname file */
    elm_sfprintf(fullnamefile, sizeof fullnamefile,
		 FRM("%s/.fullname"), pass->pw_dir);
    
    if(access(fullnamefile, READ_ACCESS) != 0)
	return(NULL);		/* fullname file not accessible to user */
    if((fp = fopen(fullnamefile, "r")) == NULL)
	return(NULL);		/* fullname file cannot be opened! */
    if(fgets(fullname, SLEN, fp) == NULL) {
	fclose(fp);
	return(NULL);		/* fullname file empty! */
    }
    fclose(fp);
    no_ret(fullname);	/* remove trailing '\n' */
#endif
    return(fullname);
}

 
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
