static char rcsid[] = "@(#)$Id: getarpdate.c,v 2.5 2018/06/27 13:55:49 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/getarpdate.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"config");

const char *arpa_dayname[8] = { "Sun", "Mon", "Tue", "Wed", "Thu",
				"Fri", "Sat", "" };

const char *arpa_monname[13] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
				 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};

char * get_arpa_date()
{
	/** returns an ARPA standard date.  The format for the date
	    according to DARPA document RFC-822 is exemplified by;

	       	      Mon, 12 Aug 85 6:29:08 MST


	    Actually generates following kind result:
                      
                      Mon, 12 Aug 1985 06:29:00 +0400 (MST)

	**/

	static char buffer[SLEN];	/* static character buffer       */
	time_t	  curr_time;		/* time in seconds....		 */
	struct tm curr_tm;		/* Time structure, see CTIME(3C) */
	long      tzmin;		/* number of minutes off gmt 	 */
	int	  tzsign;		/* + or - gmt 			 */
	struct tm * tm1;
	
	(void) time(&curr_time);
	tm1 = localtime(&curr_time);
	if (tm1) {
	    /*
	     * The get_tz_mins() routine steps on the static data returned
	     * by localtime(), so we need to save off the value obtained here.
	     */

	    curr_tm = *tm1;
	    
	    if ((tzmin = -get_tz_mins(curr_time)) >= 0) {
		tzsign = '+';
	    } else {
		tzsign = '-';
		tzmin = -tzmin;
	    }

	    elm_sfprintf(buffer, sizeof buffer,
			 FRM("%s, %d %s %d %02d:%02d:%02d %c%02d%02d (%s)"),
			 arpa_dayname[curr_tm.tm_wday],
			 curr_tm.tm_mday, arpa_monname[curr_tm.tm_mon], 
			 curr_tm.tm_year + 1900,
			 curr_tm.tm_hour, curr_tm.tm_min, curr_tm.tm_sec,
			 tzsign, tzmin / 60, tzmin % 60, get_tz_name(&curr_tm));
	
	    return buffer;
	} else {
	     DPRINT(Debug,1,(&Debug,
			     "get_arpa_date curr_time=%ld -- localtime failed\n",
			     (long)curr_time));
	     return "";
	}
}


#ifdef _TEST
int debug = 1;
main()
{
	printf("system(\"date\") says:   ");
	fflush(stdout);
	system("date");
	fflush(stdout);
	printf("get_arpa_date() says:  %s\n", get_arpa_date());
	exit(0);
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
