static char rcsid[] = "@(#)$Id: expand.c,v 2.8 2017/05/03 19:34:21 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/expand.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/read.rc: 
 *  That code was following copyright:
 *
 *  The Elm Mail System
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This is a library routine for the various utilities that allows
    users to have the standard 'Elm' folder directory nomenclature
    for all filenames (e.g. '+', '=' or '%').  It should be compiled
    and then linked in as needed.

**/

#include "elm_defs.h"
#include "s_elmrc.h"

DEBUG_VAR(Debug,__FILE__,"config");

extern nl_catd elm_msg_cat;	/* message catalog	    */

int expand(filename, size)
     char *filename;
     int size;
{    
    if (filename[0] == '+' || filename[0] == '%' || filename[0] == '=') {
	char  buffer[SLEN];

	/* give_dt_estr_as_str adds / to end */
	const char * str = give_dt_estr_as_str(&folders_e,"maildir",
					       NULL,NULL);

	if (!str)
	    return 0;

	strfcpy(buffer,str, sizeof buffer);

	strfcat(buffer,filename+1, sizeof buffer);
  
	strfcpy(filename, buffer, size);	
    }
    return 1;
}

static char *monthnames[12] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
};

static char *daynames[7] = {
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};

/* Returns 0 if no expansion done
           1 if expansion done
	  -1 on failure
*/
int expand_path(dest, src, destlen)
     char *dest;	/* pointer to space to hold the result	*/
     const char *src;	/* pointer to string to expand		*/
     unsigned destlen;	/* size of the destination buffer	*/
{
    const char *src0 UNUSED_VAROK = src;
    char *dest0 UNUSED_VAROK = dest;
    int ret = 0;	     /* assume success */

    time_t		now;
    struct tm		*tm;


    time(&now);
    tm = localtime(&now);
    if (!tm) {
	DPRINT(Debug,1,(&Debug, 
			"expand_path()=-1, localtime failed\n"));
	return -1;	

    }

    if (destlen < 1) {
	DPRINT(Debug,1,(&Debug, 
			"expand_path()=-1, src=%s, destlen=%d\n", 
			src,destlen));
	return -1;	
    }
	
    --destlen;		/* reserve space for trailing '\0' */

    /*
     * Copy through the rest, performing $NAME expansion where appropriate.
     */

    while (destlen > 0 && *src != '\0') {

	switch(*src) {
	    
	    /*
	    ** Environment variable expansion
	    */
	case '$': {

	    /*
	     * Get the environment parameter name into "envname_buf"
	     * and advance "src" to the next path component.
	     */
	    const char *envname_front = ++src;
	    const char *expval;
	    int len, p;
	    char envname_buf[SLEN];
    
	    if ('{' == *src) {
		envname_front = ++src;		
		if ((len = strcspn(src, "}")) == 0) {
		    DPRINT(Debug,5,(&Debug,"Bad variable\n"));

		    strnfcpy(dest, "${", 2, destlen,&p);
		    dest +=  p;
		    destlen -= p;

		    continue;
		}
		
		src += len +1;
	    } else {

		if ((len = strcspn(src, "/@%")) == 0)
		    len = strlen(src);
		src += len;
	    }

	    strnfcpy(envname_buf, envname_front, len, 
		     sizeof(envname_buf),NULL);

	    /*
	     * Copy over the environment expansion.  If the environment
	     * parameter is undefined then copy over unchanged and set
	     * a fail return status.
	     */

	    if (1 == len && '$' == envname_buf[0]) {
		static char buffer1[20];

		/* Handle $$ as pid */
		elm_sfprintf(buffer1,sizeof buffer1,
			     FRM("%d"), getpid());

		expval = buffer1;
	    } else if ((expval = getenv(envname_buf)) == NULL) {
		*dest++ = '$';
		--destlen;
		expval = envname_buf;
		ret = -1;
		DPRINT(Debug,5,(&Debug,
			    "getenv(%s) FAILED\n",envname_buf));
	    } else {
		DPRINT(Debug,61,(&Debug,
				 "getenv(%s)=%s\n", 
				 envname_buf,expval));
	    }
	    len = strlen(expval);
	    strnfcpy(dest, expval, len, destlen,&p);
	    dest +=  p;
	    destlen -= p;
	    

	    if (0 == ret)
		ret = 1;
	
	}
	    break;

	case '%': {
		src++;

		/*
		** Handle date expansion
		*/
	        switch(*src) {
		    int p;

		case 'h':	/* Month name */
		    
		    strnfcpy(dest, monthnames[tm->tm_mon], 3, destlen,&p);
		    dest +=  p;
		    destlen -= p;
		    
		    break;
		case 'a':	/* Day of the week */
		    
		    strnfcpy(dest, daynames[tm->tm_wday], 3, destlen,&p);
		    dest +=  p;
		    destlen -= p;
		    
		    break;
		case 'y':	/* Last 2 digits of the year */
		    p = elm_sfprintf(dest,destlen,FRM("%02d"), 
				     tm->tm_year % 100);
		    dest += p;
		    destlen -= p;
		    break;
		case 'Y':	/* Last 4 digits of the year */
		    p = elm_sfprintf(dest,destlen,FRM("%04d"), 
				     tm->tm_year+1900);
		    dest += p;
		    destlen -= p;
		    break;
		case 'm':	/* Month number (1-12) */
		    p = elm_sfprintf(dest,destlen,FRM("%02d"), 
				     tm->tm_mon+1);
		    dest += p;
		    destlen -= p;
		    break;
		case 'd':	/* Day of the month */
		    p = elm_sfprintf(dest,destlen,FRM("%02d"), 
				     tm->tm_mday);
		    dest += p;
		    destlen -= p;
		    break;
		case 'j':	/* Julian day */
		    p = elm_sfprintf(dest,destlen,FRM("%03d"), 
				     tm->tm_yday+1);
		    dest += p;
		    destlen -= p;
		    break;
		case '%':
		    if (destlen > 0) 
			*dest++ = '%';
		    else
			ret = -1;
		    break;
		default:
		    if (destlen > 1) {
			destlen -= 2;
			*dest++ = '%';
			*dest++ = *src;
		    }
		    else
			ret = -1;
		    break;
	        }
	        src++;
	}
	    break;
	default:

	    *dest++ = *src++;
	    --destlen;
	    break;
	}
    }

    *dest = '\0';
    if (destlen <= 0)
	ret = -1;

    DPRINT(Debug,(ret == 0 ? 11: 5),(&Debug,
				     "expand_path()=%d, src=%s, dest=%s\n", 
				     ret,src0,dest0));
    
    return ret;
}

int expand_meta(dest, src, destlen)
     char *dest;	/* pointer to space to hold the result	*/
     const char *src;	/* pointer to string to expand		*/
     unsigned destlen;	/* size of the destination buffer	*/
{
    const char *src0 UNUSED_VAROK = src;
    char *dest0      UNUSED_VAROK = dest;
    const char * c;
    int ret = 0;

    if (destlen < 1) {
	DPRINT(Debug,1,(&Debug, 
		    "expand_meta()=-1, src=%s, destlen=%d\n", 
		    src,destlen));
	return -1;	
    }

    --destlen;		/* reserve space for trailing '\0' */

    if (src[0] == '+' || src[0] == '%' || src[0] == '=') {
	const char * expval;
	int len,p;

	/* give_dt_estr_as_str adds / to end */
	const char * str = give_dt_estr_as_str(&folders_e,"maildir",NULL,NULL);

	if (!str) {
	    expval = "=";
	    ret = -1;
	    len = 1;
	} else {
	    expval = str;
	    len = strlen(str);
	}
	strnfcpy(dest, expval, len, destlen,&p);
	dest += p;
	destlen -= p;
	++src;

	if ('/' == src[0] && str) 
	    src++;

	if (expand_path(dest,src,destlen+1) < 0)
	    ret = -1;

    } else if (src[0] == '#') {

	DPRINT(Debug,3,(&Debug,
			"expand_meta: # aka hashmark is not supported\n"));
	ret = -1;


    } else if (src[0] == '&') {

	DPRINT(Debug,3,(&Debug,
			"expand_meta: & aka remote (IMAP) folder is not supported\n"));
	ret = -1;
	
    } else if (src[0] == '{' && NULL != (c = strpbrk(src,"}/")) &&
	       *c == '}' && *(c+1) == '/') {
	int l = (c - src) + 1;

	char result[STRING];
	int len,p;
	
	if (home[0] != '\0' && 4 == l && 0 == strncmp(src,"{rc}",l)) {
	    len = elm_sfprintf(result, sizeof result,
			       FRM("%s/.elm"),home);
	    src += l;
	} else if (5 == l && 0 == strncmp(src,"{lib}",l)) {
	    len = elm_sfprintf(result, sizeof result,
			       FRM("%s"),LIBHOME);
	    src += l;
	} else if (5 == l && 0 == strncmp(src,"{etc}",l)) {
	    len = elm_sfprintf(result, sizeof result,
			       FRM("%s"),ETCHOME);
	    src += l;
	} else if (5 == l && 0 == strncmp(src,"{bin}",l)) {
	    len = elm_sfprintf(result, sizeof result,
			       FRM("%s"),BINHOME);
	    src += l;
	} else if (5 == l && 0 == strncmp(src,"{doc}",l)) {
	    const char * attachment_dir_val = 
		give_dt_estr_as_str(&attachment_dir_e,
				    "attachment-dir",
				    NULL,NULL);
	    
	    if (!attachment_dir_val)
		attachment_dir_val = "";
	    
	    len = elm_sfprintf(result, sizeof result,
			       FRM("%s"),attachment_dir_val);
	    src += l;
	    if (!attachment_dir_val[0]) {
		DPRINT(Debug,3,(&Debug,
				"expand_meta: {doc} aka attachment-dir is not set\n"));
		ret = -1;
	    }
	} else {
	    strnfcpy(result,src,l,sizeof result,NULL);
	    len = l;
	    ret = -1;
	}
	strnfcpy(dest, result, len, destlen,&p);
	dest += p;
	destlen -= p;

	if (expand_path(dest,src,destlen+1) < 0)
	    ret = -1;

    } else {	
	if (expand_env(dest,src,destlen+1) < 0)
	    ret = -1;
    }

    DPRINT(Debug,(ret == 0 ? 10: 1),(&Debug,
				     "expand_meta()=%d, src=%s, dest=%s\n", 
				     ret,src0,dest0));

    return ret;   
}

/*
 ** Copy a string from the source buffer (src) to the destination buffer
** (dst) performing various expansions along the way:
**
**   Source string		-->		Destination string
**   -------------				------------------
**
**	$VAR					  value of $VAR from
**						  the environment
**
**	${VAR}					  same as above.
**
**	~/					  user's home directory
**
**	%h					  current month name
**						  (3 letter abbreviation)
**
**	%y					  current year (modulo 100)
**
**      %Y                                        current year
** 
**	%m					  current month number (01-12)
**
**	%j					  day of the year (001-366)
**
**	%d					  day of the month (01-31)
**
**      %%                                        % character
**
** Returns:  0 if successful, -1 if error occurs
**
** Example:
**
**	JUNK = bar in the current environment:
**	Current date = 1/1/95
**
**	~/$JUNK/mail.%h%y  -->  /usr/whoever/bar/mail.Jan95
**
**      if you want to embed "$JUNK" within a string, use '{}':
**
**	~/${JUNK}xx/mail.%h%y  -->  /usr/whoever/barxx/mail.Jan95
**
 */
int expand_env(dest, src, destlen)
     char *dest;	/* pointer to space to hold the result	*/
     const char *src;	/* pointer to string to expand		*/
     unsigned destlen;	/* size of the destination buffer	*/
{
    int ret = 0;		/* assume success */
    const char *src0 UNUSED_VAROK = src;

    if (destlen < 1) {
	DPRINT(Debug,1,(&Debug, 
			"expand_env()=-1, src=%s, destlen=%d", 
			src,destlen));	
	return -1;	
    }
    --destlen;		/* reserve space for trailing '\0' */

    /*
     * Replace "~" at front with user's home directory.
     */
    if (src[0] == '~' && (src[1] == '\0' || src[1] == '/')) {
	const char *expval;
	int len, p;
	if (home[0] == '\0') {
	    expval = "~";
	    ret = -1;
	} else {
	    expval = home;
	}
	if ((len = strlen(expval)) > destlen)
	    len = destlen;
	strnfcpy(dest, expval, len, destlen, &p);
	dest +=  p;
	destlen -=  p;
	++src;
    }

    if (expand_path(dest,src,destlen+1) < 0)
	ret = -1;

    DPRINT(Debug,(ret == 0 ? 12: 4),(&Debug,
				     "expand_env()=%d, src=%s, dest=%s\n", 
				     ret,src0,dest));
    
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

