static char rcsid[] = "@(#)$Id: cs_fallback.c,v 2.3 2014/07/14 15:07:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "s_me.h"
#include "cs_imp.h"

DEBUG_VAR(Debug,__FILE__,"charset");

static struct {
    unsigned char c;
    uint16 c1;
} fallback_table[] = {
    { '\r', 0x000D },
    { '\n', 0x000A },
    { '\t', 0x0009 },
    /* This table defines mapping between charset used in string
     * constants and unicode. This includes only characters, which
     * are likely to be existed in all sets.
     */  
    { ' ', 0x0020        /* ;*;SPACE;;; */            },
    { '!', 0x0021        /* ;*;EXCLAMATION MARK;;; */ },
    { '"', 0x0022        /* ;*;QUOTATION MARK;;; */   },
    { '%', 0x0025        /* ;*;PERCENT SIGN;;; */     },
    { '&', 0x0026        /* ;*;AMPERSAND;;; */        },
    { '(', 0x0028        /* ;*;LEFT PARENTHESIS;;OPENING PARENTHESIS; */ },
    { ')', 0x0029        /* ;*;RIGHT PARENTHESIS;;CLOSING PARENTHESIS; */ },
    { '*', 0x002A        /* ;*;ASTERISK;;; */  },
    { '+', 0x002B        /* ;*;PLUS SIGN;;; */ },
    { ',', 0x002C        /* ;*;COMMA;;;  */ },
    { '-', 0x002D        /* ;*;HYPHEN-MINUS;;; */ },
    { '.', 0x002E        /* ;*;FULL STOP;;PERIOD; */ },
    { '/', 0x002F        /* ;*;SOLIDUS;;SLASH; */ },
    { '0', 0x0030        /* ;*;DIGIT ZERO;;; */ },
    { '1', 0x0031        /* ;*;DIGIT ONE;;; */ },
    { '2', 0x0032        /* ;*;DIGIT TWO;;; */ },
    { '3', 0x0033        /* ;*;DIGIT THREE;;; */ },
    { '4', 0x0034        /* ;*;DIGIT FOUR;;; */ },
    { '5', 0x0035        /* ;*;DIGIT FIVE;;; */ },
    { '6', 0x0036        /* ;*;DIGIT SIX;;; */ },
    { '7', 0x0037        /* ;*;DIGIT SEVEN;;; */ },
    { '8', 0x0038        /* ;*;DIGIT EIGHT;;; */ },
    { '9', 0x0039        /* ;*;DIGIT NINE;;; */ },
    { ':', 0x003A        /* ;*;COLON;;; */ },
    { ';', 0x003B        /* ;*;SEMICOLON;;; */ },
    { '<', 0x003C        /* ;*;LESS-THAN SIGN;;; */ },
    { '=', 0x003D        /* ;*;EQUALS SIGN;;; */ },
    { '>', 0x003E        /* ;*;GREATER-THAN SIGN;;; */ },
    { '?', 0x003F        /* ;*;QUESTION MARK;;; */ },
    { 'A', 0x0041        /* ;*;LATIN CAPITAL LETTER A;;; */ },
    { 'B', 0x0042        /* ;*;LATIN CAPITAL LETTER B;;; */ },
    { 'C', 0x0043        /* ;*;LATIN CAPITAL LETTER C;;; */ },
    { 'D', 0x0044        /* ;*;LATIN CAPITAL LETTER D;;; */ },
    { 'E', 0x0045        /* ;*;LATIN CAPITAL LETTER E;;; */ },
    { 'F', 0x0046        /* ;*;LATIN CAPITAL LETTER F;;; */ },
    { 'G', 0x0047        /* ;*;LATIN CAPITAL LETTER G;;; */ },
    { 'H', 0x0048        /* ;*;LATIN CAPITAL LETTER H;;; */ },
    { 'I', 0x0049        /* ;*;LATIN CAPITAL LETTER I;;; */ },
    { 'J', 0x004A        /* ;*;LATIN CAPITAL LETTER J;;; */ },
    { 'K', 0x004B        /* ;*;LATIN CAPITAL LETTER K;;; */ },
    { 'L', 0x004C        /* ;*;LATIN CAPITAL LETTER L;;; */ },
    { 'M', 0x004D        /* ;*;LATIN CAPITAL LETTER M;;; */ },
    { 'N', 0x004E        /* ;*;LATIN CAPITAL LETTER N;;; */ },
    { 'O', 0x004F        /* ;*;LATIN CAPITAL LETTER O;;; */ },
    { 'P', 0x0050        /* ;*;LATIN CAPITAL LETTER P;;; */ },
    { 'Q', 0x0051        /* ;*;LATIN CAPITAL LETTER Q;;; */ },
    { 'R', 0x0052        /* ;*;LATIN CAPITAL LETTER R;;; */ },
    { 'S', 0x0053        /* ;*;LATIN CAPITAL LETTER S;;; */ },
    { 'T', 0x0054        /* ;*;LATIN CAPITAL LETTER T;;; */ },
    { 'U', 0x0055        /* ;*;LATIN CAPITAL LETTER U;;; */ },
    { 'V', 0x0056        /* ;*;LATIN CAPITAL LETTER V;;; */ },
    { 'W', 0x0057        /* ;*;LATIN CAPITAL LETTER W;;; */ },
    { 'X', 0x0058        /* ;*;LATIN CAPITAL LETTER X;;; */ },
    { 'Y', 0x0059        /* ;*;LATIN CAPITAL LETTER Y;;; */ },
    { 'Z', 0x005A        /* ;*;LATIN CAPITAL LETTER Z;;; */ },
    
    { 'a', 0x0061        /* ;*;LATIN SMALL LETTER A;;; */ },
    { 'b', 0x0062        /* ;*;LATIN SMALL LETTER B;;; */ },
    { 'c', 0x0063        /* ;*;LATIN SMALL LETTER C;;; */ },
    { 'd', 0x0064        /* ;*;LATIN SMALL LETTER D;;; */ },
    { 'e', 0x0065        /* ;*;LATIN SMALL LETTER E;;; */ },
    { 'f', 0x0066        /* ;*;LATIN SMALL LETTER F;;; */ },
    { 'g', 0x0067        /* ;*;LATIN SMALL LETTER G;;; */ },
    { 'h', 0x0068        /* ;*;LATIN SMALL LETTER H;;; */ },
    { 'i', 0x0069        /* ;*;LATIN SMALL LETTER I;;; */ },
    { 'j', 0x006A        /* ;*;LATIN SMALL LETTER J;;; */ },
    { 'k', 0x006B        /* ;*;LATIN SMALL LETTER K;;; */ },
    { 'l', 0x006C        /* ;*;LATIN SMALL LETTER L;;; */ },
    { 'm', 0x006D        /* ;*;LATIN SMALL LETTER M;;; */ },
    { 'n', 0x006E        /* ;*;LATIN SMALL LETTER N;;; */ },
    { 'o', 0x006F        /* ;*;LATIN SMALL LETTER O;;; */ },
    { 'p', 0x0070        /* ;*;LATIN SMALL LETTER P;;; */ },
    { 'q', 0x0071        /* ;*;LATIN SMALL LETTER Q;;; */ },
    { 'r', 0x0072        /* ;*;LATIN SMALL LETTER R;;; */ },
    { 's', 0x0073        /* ;*;LATIN SMALL LETTER S;;; */ },
    { 't', 0x0074        /* ;*;LATIN SMALL LETTER T;;; */ },
    { 'u', 0x0075        /* ;*;LATIN SMALL LETTER U;;; */ },
    { 'v', 0x0076        /* ;*;LATIN SMALL LETTER V;;; */ },
    { 'w', 0x0077        /* ;*;LATIN SMALL LETTER W;;; */ },
    { 'x', 0x0078        /* ;*;LATIN SMALL LETTER X;;; */ },
    { 'y', 0x0079        /* ;*;LATIN SMALL LETTER Y;;; */ },
    { 'z', 0x007A        /* ;*;LATIN SMALL LETTER Z;;; */ }
};

static uint16 from_fallback_cs[256] = { 0 };
static int initialized = 0;

static void init_fallback P_((void));
static void init_fallback() {
    int i;

    for (i = 0; i < 256; i++)
	from_fallback_cs[i] = MAPPING_NONE;

    for (i = 0; i < sizeof fallback_table / sizeof fallback_table[0]; i++) {
	from_fallback_cs[fallback_table[i].c]  =  fallback_table[i].c1;
    }


    DPRINT(Debug,4,(&Debug, 
		    "Fallback map initialized\n"));

    initialized = 1;
}

uint16 map_fallback(c)
     unsigned int c;
{
    if (!initialized)
	init_fallback();
    return from_fallback_cs[c];
}


unsigned char map_fallback_rev(val, found)
     unsigned int val;
     int *found;
{
    int i;

    for (i = 0; i < sizeof fallback_table / sizeof fallback_table[0]; i++) {
	if (fallback_table[i].c1 == val) {
	    *found = 1;
	    return fallback_table[i].c;
	}
    }
    *found = 0;
    return '?';  /* Not found */
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
