static char rcsid[] = "@(#)$Id: convert_status.c,v 2.1 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  convert_status() moved from lib/posixsig.c                     
 *
 *  That is based on Elm 2.4 lib/posixsig.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "defs_major.h"
#include "convert_status.h"

static const char * dummy_xxx UNUSED_VAROK = rcsid;

int convert_status(status,exit_code) 
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
     union wait status;
#else
     int status;
#endif
     int *exit_code;
{
  int sig;

#ifdef	WEXITSTATUS
  *exit_code = WEXITSTATUS(status);
  if (WIFSIGNALED(status)) {
      sig        = WTERMSIG(status);
  } else
     sig        = 0;
#else
# ifdef	BSD_TYPE
  *exit_code = status.w_retcode;
  sig        = status.w_termsig;
# else
  *exit_code = status >> 8;
  sig        = status & 128;
# endif
#endif

  return sig;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
