static char rcsid[] = "@(#)$Id: charset_input.c,v 2.5 2016/03/21 20:26:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "s_me.h"
#include "cs_imp.h"

DEBUG_VAR(Debug,__FILE__,"charset");

struct charset_state * new_state_1(set)
     charset_t set;
{
    struct charset_state * res = safe_zero_alloc (sizeof (* res));

    if (CS_charset_magic != set->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"new_state_1",
	      "Bad magic number (set)",0);

    res->magic        = CHARSET_STATE_magic;
    res->charset      = set;
    res->caller_flags = 0;    /* Not used here, but maybe by caller */
    res->ready = 0;

    res->charset->charset_type->cs_init_s_it(res);

    return res;
}

struct charset_state * new_state(set)
     charset_t set;
{
    struct charset_state * res;

    DPRINT(Debug,60,(&Debug, 		    
	       "new_state(%p)   ('%s'; type=%p '%s')\n",
	       set,
	       set->MIME_name ? 
	       set->MIME_name : "<none>",
	       set->charset_type,
	       set->charset_type->type_name));

    if (CS_charset_magic != set->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"new_state_1",
	      "Bad magic number (set)",0);
    

    /* Initialize associated map if not done already ... */       
    if (set->map_info && !set->map_info->map_initialized)
	set->map_info->map_init_it(set->map_info);

    res = new_state_1(set);

    DPRINT(Debug,60,(&Debug, 
		     "new_state=%p\n",res));
    return res;
}

void free_state_internal(state)
     struct charset_state **state;
{
    if (CHARSET_STATE_magic != (*state)->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"free_state_internal",
	      "Bad magic number",0);

    (*state)->charset->charset_type->cs_free_s_it(*state);

    (*state)->charset = NULL;

    (*state)->magic  = 0;      /* Invalidate */
    free(*state);
    *state = NULL;
}

void free_state(state)
     struct charset_state **state;
{
    if (CHARSET_STATE_magic != (*state)->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"free_state",
	      "Bad magic number",0);

    if (CS_charset_magic != (*state)->charset->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"free_state",
	      "Bad magic number (charset)",0);
    
    DPRINT(Debug,60,(&Debug, 
		     "free_state((*state)=%p)   ('%s'; type=%p '%s')\n",
		     (*state),
		     (*state)->charset->MIME_name ? 
		     (*state)->charset->MIME_name : "<none>",
		     (*state)->charset->charset_type,
		     (*state)->charset->charset_type->type_name));
    free_state_internal(state);
}

int state_ready(st)
     struct charset_state *st;
{
    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_ready",
	      "Bad magic number",0);

    if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"ready_state",
	      "Bad magic number (charset)",0);

    DPRINT(Debug,60,(&Debug, 
		     "ready_state(%p)=%d   ('%s'; type=%p '%s')\n",
		     st,st->ready,
		     st->charset->MIME_name ? 
		     st->charset->MIME_name : "<none>",
		     st->charset->charset_type,
		     st->charset->charset_type->type_name));

    if (st->ready) {
	DPRINT(Debug,61,(&Debug," .... character: %C\n",st)); 
    }

    return st->ready;
}

/* Unready state */
void reset_state(st, hard)
     struct charset_state *st;
     int hard;
{
    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"reset_state",
	      "Bad magic number",0);

    if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"ready_state",
	      "Bad magic number (charset)",0);

    DPRINT(Debug,60,(&Debug, 
		     "reset_state(%p,hard=%d)   (ready=%d; '%s'; type=%p '%s')\n",
		     st,hard,
		     st->ready,
		     st->charset->MIME_name ? 
		     st->charset->MIME_name : "<none>",
		     st->charset->charset_type,
		     st->charset->charset_type->type_name));
    
    if (hard) {
	st->charset->charset_type->cs_free_s_it(st);
	st->charset->charset_type->cs_init_s_it(st);
    } else {
	st->charset->charset_type->cs_soft_reset_s_it(st);
    }
}

int add_streambyte_to_state(st,ch)
     struct charset_state *st; 
     int ch;
{
    int res;

    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"add_streambyte_to_state",
	      "Bad magic number",0);

    if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"ready_state",
	      "Bad magic number (charset)",0);

    DPRINT(Debug,60,(&Debug, 
		     "add_streambyte_to_state(%p)  ('%s'; type=%p '%s')\n",
		     st,
		     st->charset->MIME_name ? 
		     st->charset->MIME_name : "<none>",
		     st->charset->charset_type,
		     st->charset->charset_type->type_name));
    if (st->charset == display_charset) {
	DPRINT(Debug,61,(&Debug, 
		   "add_streambyte_to_state -- ch=%d '%c'\n",ch,ch));    
    } else {
	DPRINT(Debug,61,(&Debug, 
			 "add_streambyte_to_state -- ch=%d\n",ch));    
    }


    res = st->charset->charset_type->cs_add_streambyte_to_s_it(st,ch);

    DPRINT(Debug,60,(&Debug, 
		     "add_streambyte_to_state=%d\n",res));

    return res;
}

int state_same_char(A,B,ignore_case)
     struct charset_state *A;
     struct charset_state *B;
     int ignore_case;
{
    int ret = -1;

    if (CHARSET_STATE_magic != A->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_same_char",
	      "Bad magic number (A)",0);
    if (CHARSET_STATE_magic != B->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_same_char",
	      "Bad magic number (B)",0);

    if (CS_charset_magic != A->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_same_char",
	      "Bad magic number (A, charset)",0);
    if (CS_charset_magic != B->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_same_char",
	      "Bad magic number (B, charset)",0);

    DPRINT(Debug,60,(&Debug, 
		     "state_same_state(%p,%p)   ('%s'; type=%p '%s', '%s'; type=%p '%s')\n",
		     A,B,
		     A->charset->MIME_name ? 
		     A->charset->MIME_name : "<none>",
		     A->charset->charset_type,
		     A->charset->charset_type->type_name,
		     B->charset->MIME_name ? 
		     B->charset->MIME_name : "<none>",
		     B->charset->charset_type,
		     B->charset->charset_type->type_name));

    if (!A->ready) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_same_state",
	      "State not ready (A)",0);
    if (!B->ready) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_same_state",
	      "State not ready (B)",0);

    if (A->charset == B->charset)
	ret = A->charset->charset_type->cs_s_it_same_char(A,B,ignore_case);

    /* -1 indicates that unicode values should be used on comparision ... */
    if (ret < 0) {
	int found1, found2;
	uint16 val1 = 
	    A->charset->charset_type->cs_give_unicode_from_s_it(A,&found1);
	uint16 val2 = 
	    A->charset->charset_type->cs_give_unicode_from_s_it(B,&found2);

	if (found1 && found2) {
	    if (ignore_case) {
		/* TODO: Should lowercase ANY unicode value ... */

		val1 = unicode_ch(val1,UOP_lowercase);
		val2 = unicode_ch(val2,UOP_lowercase);

		if (!val1 || !val2) {
		    ret = 0;
		    goto fail;
		}
		    
	    }
	    ret = (val1 == val2);
	} else
	    ret = 0;
    }

 fail:
    DPRINT(Debug,60,(&Debug,        
		     "state_same_char=%d\n",ret));

    return ret;
}

int state_printable(st)
     struct charset_state *st;
{
    int ret;

    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_printable",
	      "Bad magic number",0);

    if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_printable",
	      "Bad magic number (A, charset)",0);

    DPRINT(Debug,60,(&Debug, 
		     "state_printable(%p)   ('%s'; type=%p '%s')\n",
		     st,
		     st->charset->MIME_name ? 
		     st->charset->MIME_name : "<none>",
		     st->charset->charset_type,
		     st->charset->charset_type->type_name));
    
    if (!st->ready) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_printable",
	      "State not ready",0);

    ret = st->charset->charset_type->cs_s_it_printable(st);
    
    if (ret < 0) { /* Use unicode values ... */
	int found;
	uint16 val = 
	    st->charset->charset_type->cs_give_unicode_from_s_it(st,&found);
	
	if (!found)
	    ret = 0;
	else if (unicode_ch(val,UOP_printable))
	    ret = 1;
	else
	    ret = 0;
    }

    DPRINT(Debug,60,(&Debug,
		     "state_printable=%d\n",ret));

    return ret;
}

int state_is_onebyte(st)
     struct charset_state *st;
{
    int ret;
    /* If character corresponds one byte on stream, returns it.
     * Otherwise returns 0. This is used implement ReadCh().
     * It is assumend that returned character corresponds to
     * code characterter set (and perhaps also US-ASCII)
     */

    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_is_onebyte",
	      "Bad magic number",0);

    if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_is_onebyte",
	      "Bad magic number (A, charset)",0);

    DPRINT(Debug,60,(&Debug, 
		     "state_is_onebyte(%p)   ('%s'; type=%p '%s')\n",
		     st,
		     st->charset->MIME_name ? 
		     st->charset->MIME_name : "<none>",
		     st->charset->charset_type,
		     st->charset->charset_type->type_name));
    
    if (!st->ready) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"state_is_onebyte",
	      "State not ready",0);

    ret = st->charset->charset_type->cs_s_it_is_onebyte(st);

    DPRINT(Debug,60,(&Debug,
		     "state_is_onebyte=%d\n",ret));

    return ret;
}

uint16 give_unicode_from_state(st)
     struct charset_state *st;
{
    int found;
    uint16 val; 

    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"give_unicode_from_state",
	      "Bad magic number",0);

    if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,
	      "give_unicode_from_state",
	      "Bad magic number (charset)",0);

    DPRINT(Debug,60,(&Debug, 			    
		     "give_unicode_from_state(%p)   ('%s'; type=%p '%s')\n",
		     st,
		     st->charset->MIME_name ? 
		     st->charset->MIME_name : "<none>",
		     st->charset->charset_type,
		     st->charset->charset_type->type_name));

    if (!st->ready) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,
	      "give_unicode_from_state",
	      "State not ready",0);	   

    val = st->charset->charset_type->cs_give_unicode_from_s_it(st,&found);

    DPRINT(Debug,60,(&Debug,
	       "give_unicode_from_state=%d (found=%d)\n",val,found));

    return val;
}

charset_t get_state_charset(st)
     const struct charset_state *st;
{
    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"get_state_charset",
	      "Bad magic number",0);

   if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,
	      "get_state_charset",
	      "Bad magic number (charset)",0);

   return st->charset;
}

void set_state_caller_flags(st,caller_flags)
     struct charset_state *st;
     int caller_flags;
{
    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"set_state_caller_flags",
	      "Bad magic number",0);

     if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,
	      "set_state_caller_flags",
	      "Bad magic number (charset)",0);
     st->caller_flags = caller_flags;
}

int get_state_caller_flags(st)
     struct charset_state *st;
{

    if (CHARSET_STATE_magic != st->magic) 
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,"get_state_caller_flags",
	      "Bad magic number",0);

    if (CS_charset_magic != st->charset->magic)
	panic("CHARSET STATE PANIC",__FILE__,__LINE__,
	      "get_state_caller_flags",
	      "Bad magic number (charset)",0);
    return st->caller_flags;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */


