static char rcsid[] = "@(#)$Id: atonum.c,v 2.6 2020/05/12 18:18:18 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/atonum.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1993 USENET Community Trust
 *****************************************************************************/

#include "elm_defs.h"

/* INT_MAX */
#include <limits.h>

DEBUG_VAR(Debug,__FILE__,"core");

/*
 * This is similar to atoi(), but it complains if the string
 * contains any non-numeric characters.  Returns the numeric
 * value >= 0 on success, -1 on error. Does not accept negative
 * numbers as atoi() acceps
 */
int atonum(str)
     const char *str;
{
    int value;

    if (*str == '\0')
	return -1;
    value = 0;
    while (isdigit(*str)) {
	int v;
	if (INT_MAX / 10 < value) {	    
	    DPRINT(Debug,8,(&Debug,"atonum overflows: %s\n",
			    str));
	    return -1;
	}
				   
	
	value = (value*10);
	v = (*str++ - '0');

	if (INT_MAX -v < value) {
	    DPRINT(Debug,8,(&Debug,"atonum overflows: %s\n",
			    str));
	    return -1;
	}
	
	value += v;
    }
    return (*str == '\0' ? value : -1);
}


#ifdef _TEST
#include <stdio.h>
main()
{
	char buf[1024];
	while (gets(buf) != NULL)
		printf("atonum(%s) = %d\n", buf, atonum(buf));
	putchar('\n');
	exit(0);
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
