static char rcsid[] = "@(#)$Id: init.c,v 1.17 2021/07/13 07:58:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.17 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_alias.h"
#include "s_me.h"
#include "rc_imp.h"
#include "save_opts.h"

DEBUG_VAR(Debug,__FILE__,"alias");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

static char * EDITOR_PROPLINE [] = 
    { "auto", "emacs", "ignore", NULL };
ENUMERATE editor_al_propline = {
    editor_propline_auto,
    NUM_editor_propline,
    &(EDITOR_PROPLINE[0]),
    NULL,
    0   	/* no boolean  */,
    NULL	/* not delayed */,
    NULL
};

struct aliases_map     * system_aliases_map;
charset_t                system_aliases_cs;
struct editor_propline * system_aliases_pl;

struct aliases_map     * user_aliases_map;
charset_t                user_aliases_cs;
struct editor_propline * user_aliases_pl;
struct file_changes      user_aliases_change = FILE_CHANGES_INIT;


int user_aliases_needwrite;

static ZZZ_SAVE_TYPE alias_info_data[] = {
    {"editor-al-propline",   ZZZ_DT_ENUM(&editor_al_propline),  ZZZ_TAIL },
};

static int COUNT=(sizeof(alias_info_data)/sizeof(ZZZ_SAVE_TYPE));
static save_info_recs *alias_info = (save_info_recs *) alias_info_data;

S_(dump_conf_map_f dump_user_aliases_file)
static int dump_user_aliases_file P_((FILE *f,const char *actor,
				       char *version_buff,
				       int        * erro_res));
static int dump_user_aliases_file(f,actor,version_buff,errno_res) 
     FILE       * f;
     const char * actor;
     char       * version_buff;
     int        * errno_res;
{
    user_aliases_needwrite = 0;
    
    return dump_aliases_map(f,user_aliases_map,NULL,actor,version_buff,
			    user_aliases_cs,user_aliases_pl,
			    & user_aliases_change, errno_res);
}

S_(dump_message_f user_aliases_file_written)
static void user_aliases_file_written P_((char *fname));
static void user_aliases_file_written(fname)
     char *fname;
{
    lib_error(CATGETS(elm_msg_cat, MeSet, 
		      MeAliasesInfoSavedIn,
		      "Aliases info saved in file %s."), 
	      fname);
}

S_(merge_conf_map_f merge_user_aliases_file)
static int merge_user_aliases_file P_((const char  * fname,
				       FILE        * f));
static int merge_user_aliases_file(fname,f)
     const char  * fname;
     FILE        * f;
{
    int r;
    int errors = 0;

    if (!user_aliases_map) {
	DPRINT(Debug,10,(&Debug,
			 "merge_user_aliases_file: %s: creatig new user_aliases_map\n",
			 fname));
			 
	
	user_aliases_map = new_aliases_map();
    }
    
    r = merge_aliases_map(fname,f,
			  user_aliases_map,
			  &errors,
			  &user_aliases_cs,
			  &user_aliases_pl,
			  &user_aliases_needwrite,
			  NULL,
			  & user_aliases_change);
    

    if (!r) {
	DPRINT(Debug,10,(&Debug,
			 "merge_user_aliases_file: %s: merge_aliases_map failed\n",
			 fname));	
    }

    if (errors) {
	DPRINT(Debug,10,(&Debug,
			 "merge_user_aliases_file: %s: %d errors\n",
			 fname,errors));
    }

    return r;
}


S_(init_default_hook init_alias_defaults)
static void init_alias_defaults P_((int *errors));
static void init_alias_defaults(errors)
     int *errors;
{
    DPRINT(Debug,10,(&Debug,"init_alias_defaults: starting\n"));

    system_aliases_map = load_aliases_map(system_aliases_file,errors,
					  &system_aliases_cs,
					  &system_aliases_pl,
					  NULL /* suggest_rewrite */,
					  NULL /* struct file_changes */);
    
    register_conf_write(USER_ALIASES_FILE,user_aliases_file,
			dump_user_aliases_file,
			user_aliases_file_written,
			&user_aliases_needwrite,
			merge_user_aliases_file
			);

    DPRINT(Debug,10,(&Debug,"init_alias_defaults: done\n"));
}

S_(init_default_hook alias_read_rc_file)
static void alias_read_rc_file P_((int *errors));
static void alias_read_rc_file(errors)
     int *errors;
{
    
    DPRINT(Debug,10,(&Debug,"alias_read_rc_file: starting\n"));

    user_aliases_map = load_aliases_map(user_aliases_file,errors,
					&user_aliases_cs,
					&user_aliases_pl,
					&user_aliases_needwrite,
					&user_aliases_change
					);


    if (user_aliases_needwrite) {
	DPRINT(Debug,10,(&Debug,
			 "alias_read_rc_file: Need rewrite aliases %s\n",
			 user_aliases_file));
    }

    DPRINT(Debug,10,(&Debug,"alias_read_rc_file: done\n"));
}



S_(free_rc_hook free_alias_rc_file)
static void free_alias_rc_file P_((void));
static void free_alias_rc_file() 
{
    DPRINT(Debug,8,(&Debug, "free_alias_rc_file: Freeing aliases maps\n"));

    if (user_aliases_map)
	free_aliases_map(&user_aliases_map);
    if (system_aliases_map)
	free_aliases_map(&system_aliases_map);

}



void init_aliaslib(read_flags)
    int read_flags /* READ_FLAG_IGNORE_MISSING */;
{
    register_delayed(alias_info,COUNT,read_flags);
    add_init_default_hook(&init_alias_defaults);
    add_read_rc_file_hook(&alias_read_rc_file);
    add_free_rc_hook(&free_alias_rc_file);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
