case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot="../.."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting lib/alias/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 1.15 2021/07/13 07:58:36 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                  (was hurtta+elm@posti.FMI.FI)
#      or  Kari Hurtta <elm@elmme-mailer.org>
#
#
#
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
LN              =       $ln
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
REG             =       ../../bin/elmregister 

$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot

!GROK!THIS!

if $test "$make_sets_make" != "$define" ; then  

        cat >>Makefile <<!GROK!THIS!
MAKE            =       $make
!GROK!THIS!

fi

if $test "$d_shared" = "$define" ; then
   A=
   if $test "$soname_include_path" = y ; then
	A="$shlib/"
   fi

cat >>Makefile <<SUBSTITUTE
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-alias.so$d_shared_rev
SONAME          = ${soname_opt}${A}libelmme-alias.so$d_shared_rev
SOTARG          = ../../shlib/libelmme-alias.so

SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
INSTLIB         =
SONAME		=
SOTARG          = 
!NO!SUBS!

fi

$cat >>Makefile <<'!NO!SUBS!'
IHDR		=	../../hdrs
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
OBJS            =      aliases.o address_alias.o alias_vector.o oldaliases.o \
 init.o aliasexpand.o commentfile.o filelock.o

all:	Makefile ../../libs/libelmme-alias.a $(SOTARG)
install_s: all $(INSTLIB)

uninstall_s:
	$(REG) rm $(INSTLIB)

clean: 
	rm -f $(OBJS) ../../shlib/libelmme-alias.so ../../libs/libelmme-alias.a

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_alias.h: $(IHDR)/elm_defs.h $(INCLDIR)/addrlib.h $(INCLDIR)/aliaslib.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh 
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

../misc/commentfile.o:
	cd ../misc; $(MAKE) $(MJ) $(MFLAGS) commentfile.o
commentfile.o: ../misc/commentfile.o
	$(LN) -f ../misc/$@ $@ || $(CP) ../misc/$@ $@

../misc/filelock.o:
	cd ../misc; $(MAKE) $(MJ) $(MFLAGS) filelock.o
filelock.o: ../misc/filelock.o
	$(LN) -f ../misc/$@ $@ || $(CP) ../misc/$@ $@

aliases.o:   def_alias.h $(INCLDIR)/s_me.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/commentfile.h  $(INCLDIR)/filelock.h
address_alias.o: def_alias.h $(INCLDIR)/s_me.h  
alias_vector.o:	def_alias.h
oldaliases.o: def_alias.h $(INCLDIR)/s_newalias.h $(INCLDIR)/elmlib.h 
init.o: def_alias.h $(INCLDIR)/s_me.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/rc_imp.h
aliasexpand.o: def_alias.h $(INCLDIR)/s_elm.h 

../../libs/libelmme-alias.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

../../shlib/libelmme-alias.so: $(OBJS)
	$(CC) $(LFLAGS) $(SONAME) -o $@ $(OBJS) 

$(INSTLIB): ../../shlib/libelmme-alias.so
	$(REG) copy -m 644 $? $@

!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi
