static char rcsid[] = "@(#)$Id: split_addr.c,v 2.1 2018/07/30 16:50:52 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *          or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_addr.h"


DEBUG_VAR(Debug,__FILE__,"addr");


/* returns:   1 if dequoted,
              0 if unmodified
	     -1 if overflow
	     -2 if syntax error
*/

int strcpy_dequote(target,source,size)
     char * target; 
     const char * source; 
     int size;
{
    int r = 0;

    int q = 0;
    const char *s;
    char *t;
    int overflow     = 0;
    int syntax_error = 0;

#define ADD(x) { int X = (x); \
	if (t < target + size - 1) *t++=X; else overflow++; \
	}

    for (s = source, t = target; *s; s++) {
	if (q) {
	    if ('"' == *s) {
		q = !q;
	    } else if ('\\' == *s) {
		s++;
		if (!*s) {
		    syntax_error++;
		}
		ADD(*s);
	    } else {
		ADD(*s);
	    }
	} else {
	    if ('"' == *s) {
		r = 1;
		q = !q;
	    } else {
		if ('\\' == *s) {
		    syntax_error++;
		}
		ADD(*s);
	    }
	}
    }
    *t = '\0';

    if (syntax_error) {
	DPRINT(Debug,2,(&Debug,
			"strcpy_dequote: syntax error: source=%s\n",
			source));		   
	r = -2;
    } else if (overflow) {
	DPRINT(Debug,2,(&Debug,
			"strcpy_dequote: overflow: source=%s\n",
			source));
	
	r = -1;
    }

    return r;
}

/* Returns mailname (@domain part) useful for sender address 

   returns first item from "mailname" elmrc option

   if it is inside of (), retunrs NULL
   if it does not include dot (.), returns NULL

   returns NULL if "mailname" elmrc option is not set

*/

const char * useful_mailname()
{
    const char * ret = NULL;
    
    const char **mailname_list = give_dt_path_as_elems(&mailname,"mailname");

    if (mailname_list && mailname_list[0] && mailname_list[0][0]) {
	const char * R = mailname_list[0];
	
	/* Ignore "(none)"  */

	int l;

	if ('(' == R[0] && (2 < (l = strlen(R))) && ')' == R[l-1]) {
	    DPRINT(Debug,10,(&Debug,"useful_mailname: ignoring mailname value %s\n",R));
	} else {
	    const char * x;

	    for (x = R; *x; x++) {
		if ('.' == *x) {
		    ret = R;
		    break;
		}
	    }

	    if (!ret) {
		DPRINT(Debug,10,(&Debug,"useful_mailname: ignoring mailname value %s\n",R));
	    }	    
	}
	    
    } else {
	DPRINT(Debug,10,(&Debug,"useful_mailname: mailname not set\n"));
    }

    if (ret) {
	DPRINT(Debug,10,(&Debug,"useful_mailname=%s\n",ret));
    }
    
    return ret;
}


static int is_pattern P_((const char *xx));
static int is_pattern(xx)
     const char *xx;
{
    return strpbrk(xx,"*?") != NULL;
}

int match_local_addr(addr,pattern)
     const char *addr;
     const char *pattern;
{

    if (0 == strcmp(addr,pattern)) {
	return 1;
    }

    if (is_pattern(pattern)) {
	if (compare_helper(addr,pattern,0)) {
	    return 1;
	}
    }

    return 0;
}


#define SPLIT_ADDR_magic        0xEF01

void clear_split_addr(addr)
     struct split_addr *addr;
{
    if (SPLIT_ADDR_magic != (addr)->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"free_split_addr",
	      "Bad magic number",0);

    if ((addr)->local_part) {
	free((addr)->local_part);
	(addr)->local_part = NULL;
    }
    (addr)->local_part_dequote = 0;

    if ((addr)->local_part_raw) {
	free((addr)->local_part_raw);
	(addr)->local_part_raw = NULL;
    }

    if ((addr)->host_part) {
	free((addr)->host_part);
	(addr)->host_part = NULL;
    }
}

/* Return 1, if address was splitted */
int split_internet_address(result,addr)
     struct split_addr *result;
     const char *addr;
{
    const char * host_part = qstrpbrk((char *)addr,"@");

    result->magic  = 0;


    if (host_part) {
	
	int LEN = host_part - addr +1;
	char * buffer = safe_malloc(LEN);
	char * buffer1 = safe_malloc(LEN);
	int D1;
	
	strncpy(buffer1,addr,host_part - addr);
	buffer1[host_part - addr] = '\0';
	
	D1 = strcpy_dequote(buffer,buffer1,LEN);
       
	DPRINT(Debug,27,(&Debug,
			 "split_internet_address: %s => user part=%s%s, host part=%s\n",
			 addr,buffer,
			 D1 > 0 ? " (dequoted)" : "",
			 host_part+1));


	result->magic = SPLIT_ADDR_magic;
	result->local_part = buffer;
	result->local_part_dequote = D1;
	result->local_part_raw = buffer1;

	result->host_part  = safe_strdup(host_part+1);
	return 1;
    }

    return 0;
}


int match_splitted_addr(addr,pattern)
     struct split_addr *addr;
     struct split_addr *pattern;
{

    if (SPLIT_ADDR_magic != addr->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"match_splitted_addr",
	      "Bad magic number (addr)",0);
    if (SPLIT_ADDR_magic != pattern->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"match_splitted_addr",
	      "Bad magic number (pattern)",0);


    if (0 == strcmp(addr->local_part,
		    pattern->local_part) &&
	0 == istrcmp(addr->host_part,
		     pattern->host_part)) {
			
	return 1;
    }

    if (is_pattern(pattern->local_part) ||
	is_pattern(pattern->host_part)) {

	if (compare_helper(addr->local_part,
			   pattern->local_part,0) 
	    &&
	    compare_helper(addr->host_part,
			   pattern->host_part,1)) {

	    return 1;
	}
    }

    return 0;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
