static char rcsid[] = "@(#)$Id: mailer.c,v 2.5 2016/03/21 20:26:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"mailer");

static void add_to_vector P_((char **vector,int *idx, int count,
			      struct addr_list *list));

static void add_to_vector(vector,idx,count,list)
     char **vector;
     int *idx; 
     int count;
     struct addr_list *list;
{
    if (list) {
	int num = addr_list_item_count(list);
	int i;
	
	for (i = 0; i < num; i++) {
	    int group = -1;
	    /* It is assumed that address does not inlcude 
	       route path !
	    */
	    
	    const struct address * address = 
		addr_list_get_item(list,i,&group);
	    
	    const char * addr = address_get_ascii_addr(address);
	    
	    if (!addr || !addr[0])
		continue;
	    
	    if ((*idx) >= count)
		panic("ADDR PANIC",__FILE__,__LINE__,"add_to_vector",
		      "Overflow",0);
	    
	    vector[(*idx)++] = safe_strdup(addr);
	}
    }
}

char **argv_from_headers (headers)
     struct mailing_headers * headers;
{
    int count = 0;
    char **res;
    int idx = 0,i;
    
    if (headers->to.addrs)
	count += addr_list_item_count(headers->to.addrs);
    if (headers->cc.addrs)
	count += addr_list_item_count(headers->cc.addrs);
    if (headers->bcc.addrs)
	count += addr_list_item_count(headers->bcc.addrs);


    DPRINT(Debug,6,
	   (&Debug,  "argv_from_headers, count=%d\n",count));
    
    if (count < 1)
	return NULL;

    res = safe_calloc((count + 1),sizeof (char *));
    
    dump_expanded_address(6,"argv_from_headers -- enter (to)",headers->to);

    add_to_vector(res,&idx,count,headers->to.addrs);


    dump_expanded_address(6,"argv_from_headers -- enter (cc)",headers->cc);

    add_to_vector(res,&idx,count,headers->cc.addrs);

    dump_expanded_address(6,"argv_from_headers -- enter (bcc)",headers->bcc);

    add_to_vector(res,&idx,count,headers->bcc.addrs);
    
    res[idx] = NULL;
    
    DPRINT(Debug,6,
	   (&Debug, "           idx=%d\n",idx));
    for (i = 0; i < idx; i++) 
	DPRINT(Debug,6,
	       (&Debug, "           [%d]=%s\n",i,res[i]));


    return res;
}

void free_argv(argv)
     char ***argv;
{
    char **res = *argv;

    
    int i;

    for (i = 0; res[i]; i++) {
	free(res[i]);
	res[i] = NULL;

    }

    DPRINT(Debug,6,
	   (&Debug, "free_argv: i=%d\n",i));

    free(*argv);
    *argv = NULL;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
