static char rcsid[] = "@(#)$Id: getaddr.c,v 2.15 2021/07/13 07:58:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.15 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* This routines does parsing from char *


   File parsetring.c includes correspond address parsing routine for 
   struct string *
*/
    


#include "def_addr.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"addr");

char *scanned_to_str(scanned)
     char **scanned;
{
    int idx;
    char * res = safe_strdup("");

    DPRINT(Debug,25,(&Debug, 
		    "scanned_to_str:"));

    for (idx = 0; scanned[idx]; idx++) {
	DPRINT(Debug,25,(&Debug, " [%d]=%s",idx,scanned[idx]));
	res = strmcat(res,scanned[idx]);
    }
    DPRINT(Debug,25,(&Debug, "\nscanned_to_str=%p=%s\n",res,res));

    return res;
}


void zero_tmpstore(res)
     struct tmpstore  *res;
{

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)res,sizeof (*res));
    
    res->magic     = TMPSTORE_magic;
    res->addr      = NULL;
    res->fullname  = NULL;
    res->comment   = NULL;
}

void tmpstore_to_result(result,res,group_num,defcharset)
     struct addr_list *result;
     struct tmpstore  *res;
     int group_num;
     charset_t defcharset;
{
    const char *A UNUSED_VAROK;
    const char *B UNUSED_VAROK;
    struct address  * address = NULL;

    if (TMPSTORE_magic != res->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"tmpstore_to_result",
	      "Bad magc number",0);
    
    res->addr = strmcat(res->addr,"");
    if (!res->fullname)
	res->fullname = new_string(defcharset);
    if (!res->comment)
	res->comment = new_string(defcharset);
    
    
    DPRINT(Debug,11,(&Debug, 					     
		     "tmpstore_to_result: res.addr    =%s\n",res->addr));
    DPRINT(Debug,11,(&Debug, 
		     "                      res.fullname=%S\n",res->fullname));
    
    A = get_string_MIME_name(res->fullname);
    B = get_string_lang(res->fullname);
    DPRINT(Debug,11,(&Debug, 
		     "                         cs=%s lang=%s\n",
		     A ? A : "<none>",
		     B ? B : "<none>"));
    
    
    DPRINT(Debug,11,(&Debug, 
		     "                      res.comment =%S\n",res->comment));
    
    A = get_string_MIME_name(res->comment);
    B = get_string_lang(res->comment);
    DPRINT(Debug,11,(&Debug, 
		     "                         cs=%s lang=%s\n",
		     A ? A : "<none>",
		     B ? B : "<none>"));
    address = new_address(res->addr,res->fullname,res->comment);
    
    free(res->addr); res->addr = NULL;
    free_string(&res->fullname);
    free_string(&res->comment);
    
    add_address_to_list(result,address,group_num);
    free_address(&address);
}


struct address   * parse_one_address(buffer,demime,defcharset)
     const char *buffer;
     int demime;
     charset_t defcharset;
{
    struct address * ret = NULL;
    char **tokenized = rfc822_tokenize(buffer);
    int walk = 0, next_point;

    char **scanned = NULL;
    struct string *comments = NULL;

    struct string * phrase        = NULL;
    char          * ascii_address = NULL;

    /* if buffer is empty, tokenized[0] == NULL
       tokenized is not NULL
    */
    if (!tokenized)
	return NULL;

    look_special_tokens(tokenized,":<>,;",walk,&next_point,demime,
			defcharset,&comments,&scanned);

    /* Get phrase */

    if (tokenized[next_point] &&
	'<' == tokenized[next_point][0]) {

	if (scanned) {
	    phrase = scanned_to_phrase(scanned, demime, defcharset);
	    free_rfc822tokenized(scanned);   
	}

	if (tokenized[next_point+1] &&
	    '>' == tokenized[next_point+1][0]) {


	    DPRINT(Debug,10,(&Debug, 
			     "parse_one_address: Bounce address <> seen\n"));
	    
	    ascii_address = safe_strdup("");
	    
	    walk = next_point+2;
	    
	    goto was_bounce_address;
	}
	
    skip_route:
	walk = next_point+1;

	look_special_tokens(tokenized,":<>,;",walk,&next_point,demime,
			    defcharset,&comments,&scanned);
	
	/* Skip route addr */
	if (tokenized[next_point] && 
	    (',' == tokenized[next_point][0] ||
	     ':' == tokenized[next_point][0])) {

	    if (scanned) {
		free_rfc822tokenized(scanned);   
		scanned = NULL;
	    }

	    goto skip_route;
	}

	if (! tokenized[next_point] ||
	    '>' != tokenized[next_point][0])
	    goto syntax_error;

	if (scanned) {
	    ascii_address = scanned_to_str(scanned);
	    free_rfc822tokenized(scanned);   
	    scanned = NULL;
	}

	walk = next_point+1;

    was_bounce_address:
	
	look_special_tokens(tokenized,":<>,;",walk,&next_point,demime,
			    defcharset,&comments,&scanned);

	if (scanned && scanned[0])
	    goto syntax_error; 

    } else if (! tokenized[next_point]) {
	/* Store address */

	if (scanned) {
	    ascii_address = scanned_to_str(scanned);
	    free_rfc822tokenized(scanned);   
	    scanned = NULL;
	}


    } else {
    syntax_error:
	
	DPRINT(Debug,1,(&Debug, 
			"parse_one_address: parse error, address=%s\n",
			buffer));
	if (tokenized[next_point])
	    DPRINT(Debug,1,(&Debug, 
			    "parse_one_address:  next token: %s\n",
			    tokenized[next_point]));

	lib_error(CATGETS(elm_msg_cat, MeSet,
			  MeParseErrorAddress,
			  "Parse error on address: %s"),
		  buffer);
    }
	
    if (scanned) {
	free_rfc822tokenized(scanned);  
	scanned = NULL;
    }

    free_rfc822tokenized(tokenized);   
    tokenized = NULL;

    ret = new_address(ascii_address,phrase,comments);

    if (ascii_address)
	free(ascii_address);
    if (phrase)
	free_string(&phrase);
    if (comments)
	free_string(&comments);
	    
    return ret;
} 

struct addr_list * parse_header_address(headername,buffer,demime,defcharset,
					header_error)
     const char *headername;
     const char *buffer;
     int demime;
     charset_t defcharset;
     struct header_errors **header_error;
{

    int count=1;
    int outer, inner;
    int tok_end;
    int group_num = -1;

    struct {
	int in_group;
	enum angle_bracket_mode { 
	    before_angle_bracket,
	    in_angle_bracket,
	    after_angle_bracket 
	} in_angle_bracket;	
    } state;

    struct tmpstore res;

    char **tokenized = rfc822_tokenize(buffer);
    struct addr_list *result = NULL;

    DPRINT(Debug,9,(&Debug, 
		    "parse_header_address: headername=%s buffer=%s\n",
		    headername ? headername : "<not given>",
		    buffer));

    zero_tmpstore(&res);

    /* if buffer is empty, tokenized[0] == NULL
       tokenized is not NULL
    */
    
    if (!tokenized)
	return NULL;

    for (tok_end = 0; tokenized[tok_end]; tok_end++)
	if (tokenized[tok_end][0] == ',')
	    count++;

    DPRINT(Debug,11,(&Debug, 
		     "parse_header_address: count=%d, tok_end=%d\n",
		     count,tok_end));

    result = new_empty_addr_list(count);

    state.in_group         = 0;
    state.in_angle_bracket = before_angle_bracket;

    res.addr      = NULL;
    res.fullname  = NULL;
    res.comment   = NULL;

    for (outer = 0; outer < tok_end; outer = inner) {
	char **scanned = NULL;
	struct string *comments = NULL;
	char tok = '\0';
      
	DPRINT(Debug,25,(&Debug, 
			 "parse_header_address: [%d]=%.10s... state: in_group=%d in_angle_bracket=%d\n",
			 outer,tokenized[outer],state.in_group,
			 state.in_angle_bracket));
	
	look_special_tokens(tokenized,":<>,;",outer,&inner,demime,
			    defcharset,&comments,&scanned);
	
	if (inner < tok_end) {
	    tok = tokenized[inner][0];
	    DPRINT(Debug,25,(&Debug, 
			     "parse_header_address: [%d] token=%c (%s)\n",inner,tok,tokenized[inner]));
	    inner++;
	} else {
	    tok = '\0';
	    DPRINT(Debug,25,(&Debug, 
			     "parse_header_address: [%d] token=EOS\n",inner));
	}
      	    
	/* state engine */
	if (!state.in_group) {

	    switch (state.in_angle_bracket) {

	    case before_angle_bracket:
	    new_address:

		DPRINT(Debug,25,(&Debug, 
				 "parse_header_address: [%d] not in group, before angle bracket\n",
				 inner));

		switch(tok) {
		    
		case ':':
		    group_num = -1;
		    
		    if (scanned && scanned[0]) {
			struct string *str = scanned_to_phrase(scanned,
							       demime,
							       defcharset);
			DPRINT(Debug,25,(&Debug, 
					 "... storing group phrase: %S\n",str));
			
			group_num = add_group_to_list(result,str);
			free_string(&str);			
		    }
		    
		    state.in_group = 1;
		    break;
		    
		case '<': 
		    if (scanned && scanned[0]) {
			struct string *str = scanned_to_phrase(scanned,
							       demime,
							       defcharset);
			DPRINT(Debug,25,(&Debug, 
					 "... storing address phrase: %S\n",str));
			append_string(&res.fullname,str,1);
			free_string(&str);
		    }

		    state.in_angle_bracket = in_angle_bracket;
		    break;
		    
		case '>':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token '>'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraGreaterThan,
						     "PARSE ERROR: Extra > on %s header"),
					     headername);

		    break;
		    
		case ';':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token ';'\n"));
		    
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraSemicolon,
						     "PARSE ERROR: Extra ; on %s header"),
					     headername);
		    break;
		    
		case ',':
		default: /* \0 */	 
		    
		    if (scanned  && scanned[0]) {
			char *str = scanned_to_str(scanned);

			if (res.addr) {
			    DPRINT(Debug,25,(&Debug,
					     ".... parse error, already address: %s\n",
					     res.addr));
			}

			DPRINT(Debug,25,(&Debug, 
					 "... storing address: %s\n",str));
			res.addr = strmcat(res.addr,str);
			free(str);

			if (comments && convert_comment && 
			    !res.fullname) {
			    DPRINT(Debug,25,(&Debug, 
					     "... storing comments (as fullname): %S\n",comments));
			    res.fullname = comments;
			    comments = NULL;

			} 			
		    }   

		    if (comments) {
			DPRINT(Debug,25,(&Debug,  
					 "... storing comments: %S\n", comments));
			append_string(&res.comment,comments,1);
			free_string(&comments);
		    } 
		    

		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }			

		    if (!state.in_group &&
			group_num != -1) {
			DPRINT(Debug,25,(&Debug, "... Resetting group number\n"));
			group_num = -1;
		    }

		    break;
		    
		}

		break;

	    case in_angle_bracket:

		DPRINT(Debug,25,(&Debug, 
				 "parse_header_address: [%d] not in group, in angle bracket\n",
				 inner));

		switch(tok) {    /* state.in_bracket */
		    
		case ':': 
		    DPRINT(Debug,25,(&Debug, 
				     "... skipping route\n"));
		    break;
		    
		case '<':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token '<'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraLessThan,
						     "PARSE ERROR: Extra < on %s header"),
					     headername);
		    break;
		    
		case '>': store_addr1:

		    if (res.addr) {
			DPRINT(Debug,25,(&Debug,
					 ".... parse error, already address: %s\n",
					 res.addr));
		    }

		    if (scanned  && scanned[0]) {
			char *str = scanned_to_str(scanned);
			DPRINT(Debug,25,(&Debug, 
					 "... storing address: %s\n",str));
			res.addr = strmcat(res.addr,str);
			free(str);
		    }

		    if (res.addr || res.fullname || res.comment) {

			/* NOTE: There may be (comment) after <addr>
			         so wait for it if not end of string
			*/

			if (inner >= tok_end) {
			    DPRINT(Debug,25,(&Debug, 
					     "... parsed address (EOS), group %d\n",
					     group_num));
			    tmpstore_to_result(result,&res,group_num,defcharset);
			}
		    
		    }

		    state.in_angle_bracket = after_angle_bracket;
		    
		    break;
		    
		case ',': 
		    DPRINT(Debug,25,(&Debug, 
				     "... skipping route\n"));
		    break;
		    
		case ';': 
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token ';'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraSemicolon,
						     "PARSE ERROR: Extra ; on %s header"),
					     headername);		    
		    break;
		    
		default: /* \0 */	  
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing '>'\n"));
		    
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingGreaterThan,
						     "PARSE ERROR: Missing > on %s header"),
					     headername);
		    
		    goto store_addr1;	  
		}
	    	 
		break;

	    case after_angle_bracket:
		
		DPRINT(Debug,25,(&Debug, 
				 "parse_header_address: [%d] not in group, after angle bracket\n",
				 inner));
		
		if (scanned  && scanned[0]) {
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing ','\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingComma,
						     "PARSE ERROR: Missing , on %s header"),
					     headername);
		    
		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }
		    state.in_angle_bracket = before_angle_bracket;
		    goto new_address;
		}

		switch(tok) {
		case ':':
		case '<': {
		    
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing ','\n"));
		    
		    
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingComma,
						     "PARSE ERROR: Missing , on %s header"),
					     headername);
		    
		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }
		    state.in_angle_bracket = before_angle_bracket;
		    goto new_address;
		}
		
		case '>':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token '>'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraGreaterThan,
						     "PARSE ERROR: Extra > on %s header"),
					     headername);
		    
		    break;
		    
		case ';':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token ';'\n"));
		    
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraSemicolon,
						     "PARSE ERROR: Extra ; on %s header"),
					     headername);
		    break;
		    
		case ',':
		default: /* \0 */
		    

		    if (comments) {
			DPRINT(Debug,25,(&Debug,  
					 "... storing comments: %S\n", comments));
			append_string(&res.comment,comments,1);
			free_string(&comments);
		    } 


		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }			

		    if (!state.in_group &&
			group_num != -1) {
			DPRINT(Debug,25,(&Debug, "... Resetting group number\n"));
			group_num = -1;
		    }
		    
		    state.in_angle_bracket = before_angle_bracket;

		    break;
		}

	    }
   
	} else { /* state.in_group */
	    
	    switch (state.in_angle_bracket) {
		
	    case before_angle_bracket:
	    new_address_in_group:

		DPRINT(Debug,25,(&Debug, 
				 "parse_header_address: [%d] in group, before angle bracket\n",
				 inner));

		switch(tok) {
		case ':': 
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token ':'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraColon,
						     "PARSE ERROR: Extra : on %s header"),
					     headername);
		    break;
		    
		case '<':
		    if (scanned && scanned[0]) {
			struct string *str = scanned_to_phrase(scanned,
							       demime,
							       defcharset);
			DPRINT(Debug,25,(&Debug, 
					 "... storing address phrase: %S\n",str));
			
			append_string(& res.fullname,str,1);
			free_string(&str);
		    }
		    
		    state.in_angle_bracket = in_angle_bracket;
		    break;
		    
		case '>':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token '>'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraGreaterThan,
						     "PARSE ERROR: Extra > on %s header"),
					     headername);

		    break;

		case ';': store_addr2:
		    DPRINT(Debug,25,(&Debug, 
				     "... end of group\n"));

		    state.in_group = 0;
		    /* Resetting group_num is delayed ... */

		    /* FALLTHRU */
		case ',': 
		    if (scanned  && scanned[0]) {
			char *str = scanned_to_str(scanned);

			if (res.addr) {
			    DPRINT(Debug,25,(&Debug,
					     ".... parse error, already address: %s\n",
					     res.addr));
			}

			DPRINT(Debug,25,(&Debug, 
					 "... storing address: %s\n",str));
			res.addr = strmcat(res.addr,str);
			free(str);

			if (comments && convert_comment && 
			    !res.fullname) {
			    DPRINT(Debug,25,(&Debug, 
					     "... storing comments (as fullname): %S\n",
					     comments));
			    res.fullname = comments;
			    comments = NULL;			      
			} 
		    } 
		    
		    if (comments) {
			DPRINT(Debug,25,(&Debug, 
					 "... storing comments: %S\n", comments));
			
			append_string(&res.comment,comments,1);
			free_string(&comments);
		    }
		    
		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }
		    
		    if (!state.in_group &&
			group_num != -1) {
			DPRINT(Debug,25,(&Debug, "... Resetting group number\n"));
			group_num = -1;
		    }

		    break;
		default: /* \0 */
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing ';'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingSemicolon,
						     "PARSE ERROR: Missing ; on %s header"),
					     headername);		    
		    goto store_addr2;
		    
		} 
		
		break;

	    case in_angle_bracket:
		
		DPRINT(Debug,25,(&Debug, 
				 "parse_header_address: [%d] in group, in angle bracket\n",
				 inner));
		
		switch(tok) { 
		    
		case ':': 
		    DPRINT(Debug,25,(&Debug, 
				     "... skipping route\n"));
		    break;

		case '<':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token '<'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraLessThan,
						     "PARSE ERROR: Extra < on %s header"),
					     headername);

		    break;

		case ';': 
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token ';', missing '>' ... end of group\n"));
		    state.in_group = 0;
		    /* Resetting group_num is delayed ... */

		   if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingGreaterThan2,
						     "PARSE ERROR: ; seen -- missing > on %s header"),
					     headername);
		     
		    
		    /* FALLTHRU */
		    case '>': store_addr3:
			if (scanned && scanned[0]) {
			    char *str = scanned_to_str(scanned);
			    DPRINT(Debug,25,(&Debug, 
					     "... storing address: %s\n",str));
			    res.addr = strmcat(res.addr,str);
			    free(str);
			}
			
			if (res.addr || res.fullname || res.comment) {

			    /* NOTE: There may be (comment) after <addr>
			       so wait for it if not end of string
			    */
			    
			    if (inner >= tok_end) {
				DPRINT(Debug,25,(&Debug, "... parsed address (EOS), group %d\n",
						 group_num));
				tmpstore_to_result(result,&res,group_num,defcharset);
			    }			
			}

			state.in_angle_bracket = after_angle_bracket;
			break;
			
		case ',': 
		    DPRINT(Debug,25,(&Debug, 
				     "... skipping route\n"));
		    break;
		    
		default: /* \0 */
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing '>', missing ';' ... end of group\n"));
		    state.in_group = 0;
		    /* Resetting group_num is delayed ... */
		  
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingGreaterThan3,
						     "PARSE ERROR: Missing > and missing ; on %s header"),
					     headername);
  
		    goto store_addr3;
		}
		break;

		case after_angle_bracket:
		
		DPRINT(Debug,25,(&Debug, 
				 "parse_header_address: [%d] in group, after angle bracket\n",
				 inner));

		if (scanned  && scanned[0]) {
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing ','\n"));
		    
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingComma,
						     "PARSE ERROR: Missing , on %s header"),
					     headername);
		    
		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }
		    state.in_angle_bracket = before_angle_bracket;
		    goto new_address_in_group;
		}

		switch(tok) {
		case ':': 
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token ':'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraColon,
						     "PARSE ERROR: Extra : on %s header"),
					     headername);
		    break;

		case '<': 
		    
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing ','\n"));
		    
		    
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingComma,
						     "PARSE ERROR: Missing , on %s header"),
					     headername);
		    
		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }
		    state.in_angle_bracket = before_angle_bracket;
		    goto new_address_in_group;
		    
		case '>':
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, next token '>'\n"));
		    
		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeExtraGreaterThan,
						     "PARSE ERROR: Extra > on %s header"),
					     headername);
		    
		    break;
		    
		case ';':
		store_addr4:
		    DPRINT(Debug,25,(&Debug, 
				     "... end of group\n"));
		    
		    state.in_group = 0;
		    /* Resetting group_num is delayed ... */

		    /* FALLTHRU */
		case ',': 

		    if (comments) {
			DPRINT(Debug,25,(&Debug, 
					 "... storing comments: %S\n", comments));
			
			append_string(&res.comment,comments,1);
			free_string(&comments);
		    }
		    
		    if (res.addr || res.fullname || res.comment) {
			DPRINT(Debug,25,(&Debug, "... parsed address, group %d\n",
					 group_num));
			tmpstore_to_result(result,&res,group_num,defcharset);
		    }
		    
		    if (!state.in_group &&
			group_num != -1) {
			DPRINT(Debug,25,(&Debug, "... Resetting group number\n"));
			group_num = -1;
		    }

		    state.in_angle_bracket = before_angle_bracket;

		    break;

		default: /* \0 */
		    DPRINT(Debug,25,(&Debug, 
				     "... Parse error, missing ';'\n"));

		    if (headername)
			process_header_error(header_error,
					     CATGETS(elm_msg_cat, MeSet,
						     MeMissingSemicolon,
						     "PARSE ERROR: Missing ; on %s header"),
					     headername);		    
		    goto store_addr4;
		    
		} 
		
		break;	    
	    }
	}
	
      
	/* do not convert here comment to fullname even when convert_comment
	 * is set!
	 */
	
	if (comments) {
	    DPRINT(Debug,25,(&Debug, " ... ignoring comments: %S\n", comments));


	    free_string(&comments);
	}

	if (scanned)
	    free_rfc822tokenized(scanned);
    }
    
    free_rfc822tokenized(tokenized);

    if (res.addr) {
	DPRINT(Debug,3,(&Debug, 
			"parse_header_address: res.addr NOT NULL: %s\n", 
			res.addr));
	free(res.addr); res.addr = NULL;
    }
    if (res.fullname) {
	DPRINT(Debug,3,(&Debug, 
			"parse_header_address: res.fullname NOT NULL: %S\n",
			res.fullname));
	free_string(&res.fullname);
    }
    if (res.comment) {
	DPRINT(Debug,3,(&Debug, 
			"parse_header_address: res.comment NOT NULL: %S\n",
			res.comment));
	free_string(&res.comment);
    }
    res.magic = 0;    /* Invalidate */    

    DPRINT(Debug,11,(&Debug, 
		     "parse_header_address: %d addresses, %d groups\n",
		     addr_list_item_count(result),addr_list_group_count(result)));
    
    DPRINT(Debug,11,(&Debug, 
		     "parse_header_address=%p\n",
		     result));
    
    return result;
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
