static char rcsid[] = "@(#)$Id: dispaddr.c,v 2.6 2017/05/03 19:34:21 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"addr");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}

static unsigned const char *cs2us P_((const char *str));
static unsigned const char *cs2us(str) 
     const char *str;
{
    return (const unsigned char *)str;
}


static void add_to_string P_((struct string    ** f1,
			      const struct address * address));
static void add_to_string(f1,address)
     struct string    ** f1;
     const struct address * address;
{
    struct string    * f = *f1;

    const char          * addr     = address_get_ascii_addr(address);
    const struct string * fullname = address_get_phrase(address);

    const struct string  * t   = fullname;
    struct string  * t1  = new_string2(display_charset,cs2us(addr ? addr : "<<NONE>>"));

    if (!t || !string_len(t))
	t = t1;

    if (!f)
	    f = dup_string(t);
    else {
	struct string  * t2 = dup_string(f);
	struct string  * t3;
	
	add_ascii_to_string(t2,s2us(", "));
	t3 = cat_strings(t2,t,0);
	free_string(&f);
	f = t3;
	
	free_string(&t2);
    }
    free_string(&t1);

    *f1 = f;
}

static struct string * addr_to_str P_((const struct addr_list *addr));
static struct string * addr_to_str(addr)
     const struct addr_list *addr;
{
    struct string    * f = NULL;

    if (addr) {
	int idx, addr_item_count = addr_list_item_count(addr);
	
	/* go through all addresses in this line */
	
	for (idx = 0; idx < addr_item_count; idx++) {
	    int group = -1;
	    const struct address * address = 
		addr_list_get_item(addr,idx,&group);
	    
	    add_to_string(&f,address);
	}
    }

    return f;
}

int DisplayAddress(h, f, usraddr)
     struct header_rec    * h;
     struct string       ** f;
     const struct address * usraddr;   /* from address from hashmark */
{
    int using_to = 0;
    const struct address * p = NULL;

    int user_is_recipient = 0;
    struct string *to_addr = NULL;

    DPRINT(Debug,9,(&Debug, 		      		 
		    "DisplayAddress: h (header_rec)=%p env_from=%s",
		    h,h->env_from));
    if (usraddr) {
	const char * usraddr_a  UNUSED_VAROK =  
	    address_get_ascii_addr(usraddr);

	DPRINT(Debug,9,(&Debug, " usraddr=%s\n",
			usraddr_a ?  usraddr_a : "<NULL>"));
    }
    DPRINT(Debug,9,(&Debug,"\n"));
  
    *f = NULL;

    if (!h->to  ||
	0 == addr_list_item_count(h->to)) {
	/* No To: address, must select From: address anyway.... */
	goto was_from;
    }
    
    if (h->from) {
	int idx, addr_item_count = addr_list_item_count(h->from);

	for (idx = 0; idx < addr_item_count; idx++) {
	    int group = -1;

	    const struct address * tmp =
		addr_list_get_item(h->from,idx,&group);

	    /* okay_address_l returns FALSE if it IS user's address */
	    if (!okay_address_l(tmp,NULL,usraddr)) {
		p = tmp;
		break;
	    }
	}

    }

    if (h->to) {
	int idx, addr_item_count = addr_list_item_count(h->to);

	for (idx = 0; idx < addr_item_count; idx++) {
	    int group = -1;
	    const struct address * address = 
		addr_list_get_item(h->to,idx,&group);
	    
	    const char          * addr    UNUSED_VAROK  = 
		address_get_ascii_addr(address);

	    if (!okay_address_l(address, NULL, usraddr)) {
		DPRINT(Debug,6,(&Debug,
				"DisplayAddress: Mail as addressed to user (TO): %s\n",
				addr ? addr : "<<NONE>>"));
		
		user_is_recipient = 1;
		
	    } else if (okay_address_l(address, h->from, usraddr)) {
		
		DPRINT(Debug,6,(&Debug,
				"DisplayAddress: Picking up address %s\n",
				addr ? addr : "<<NONE>>"));
		
		add_to_string(&to_addr,address);
	    }
	}
    }

    if (h->cc) {
	int idx, addr_item_count = addr_list_item_count(h->cc);
	
	for (idx = 0; idx < addr_item_count; idx++) {
	    int group = -1;
	    const struct address * address = 
		addr_list_get_item(h->cc,idx,&group);
		
	    const char          * addr   UNUSED_VAROK  = 
		address_get_ascii_addr(address);

	    if (!okay_address_l(address, NULL, usraddr)) {
		DPRINT(Debug,6,(&Debug,
				"DisplayAddress: Mail is addressed to user (CC): %s\n",
				addr ? addr : "<<NONE>>"));

		user_is_recipient = 1;
	    }
	}
    }

    DPRINT(Debug,6,(&Debug,
		    "DisplayAddress: user_is_recipient=%d\n",
		    user_is_recipient));
    if (p) {

	const char          * addr   UNUSED_VAROK
	    = address_get_ascii_addr(p);
	DPRINT(Debug,6,(&Debug,
			"DisplayAddress: ... I have recipient, addr=%s\n",
			addr ? addr : "<<NONE>>"));
    }

    if (p || addr_is_user (h->env_from)) {
	/* I sent this message.  Use the TO address.  
	 * (perhaps I have also receiver... hmm.)
	 */

	DPRINT(Debug,6,(&Debug,
			"DisplayAddress: User sent this message: %s\n",
			h->env_from));

	if (to_addr) {
	    *f = to_addr;
	    to_addr = NULL;
	} else
	    *f = addr_to_str(h->to);

	if (*f)
	    using_to = TRUE;
	else
	    goto was_from;

    } else if (!user_is_recipient && to_addr && showto) {

	/* This message is not addressed to user and
	   showto is set.
	 */

	*f = to_addr; 
	to_addr = NULL;
	using_to = TRUE;
	          
    } else { /* This message is addressed to me (or sender of mail). */
    was_from:

	if (*f)
	    free_string(f);

	*f = addr_to_str(h->from);
	if (!*f) {
	    if ('\0' == h->env_from[0] || 0 == strcmp(h->env_from,"<>"))
		*f = new_string2(display_charset,s2us("Mailer Daemon"));
	    else
		*f = new_string2(display_charset,s2us(h->env_from));
	}
    }

    if (to_addr)
	free_string(&to_addr);

    /* This does not work correctly with unknown character 
       sets... */
    remove_control(*f);
    
    DPRINT(Debug,6,(&Debug,
		    "DisplayAddress=%d, *f=%S, showto=%d\n",
		    using_to,*f,showto));
    return(using_to);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
