static char rcsid[] = "@(#)$Id: address.c,v 2.9 2021/07/13 07:58:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"addr");

#define ADDR_magic           0xE801

struct address {
    
    unsigned short magic;        /* ADDR_magic       */

    char           * ascii_address;
    struct string  * phrase;
    struct string  * comment;

};

/* ---------------------------------------------------------------------------- */

void free_address(addr)
     struct address **addr;
{
    if (ADDR_magic != (*addr)->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"free_address",
	      "Bad magic number",0);
    
    if ((*addr)->ascii_address)
	free((*addr)->ascii_address);
    (*addr)->ascii_address = NULL;

    if ((*addr)->phrase)
	free_string(& ((*addr)->phrase));

    if ((*addr)->comment)
	free_string(& ((*addr)->comment));

    (*addr)->magic = 0;      /* Invalidate */
    free(*addr);
    (*addr) = NULL;

}

struct address * new_address(ascii_addr,phrase,comment)
     const char * ascii_addr;
     const struct string  * phrase;
     const struct string  * comment;
{

    struct address *ret = safe_zero_alloc(sizeof(*ret));

    ret->magic = ADDR_magic;

    ret->ascii_address = 
	ascii_addr ? safe_strdup(ascii_addr) : NULL;
    ret->phrase =
	phrase ? dup_string(phrase) : NULL;
    ret->comment =
	comment ? dup_string(comment) : NULL;

    return ret;
}


struct address * dup_address(addr)
     const struct address *addr;
{
    if (ADDR_magic != addr->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"dup_address",
	      "Bad magic number",0);

    return new_address(addr->ascii_address,
		       addr->phrase,
		       addr->comment);
}


const struct string * address_get_phrase(addr)
     const struct address *addr;
{

    if (ADDR_magic != addr->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"address_get_phrase",
	      "Bad magic number",0);

    return addr->phrase;
}

const struct string * address_get_comment (addr)
     const struct address *addr;
{
    if (ADDR_magic != addr->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"address_get_comment",
	      "Bad magic number",0);


    return addr->comment;
}

const char * address_get_ascii_addr(addr)
     const struct address *addr;
{
    if (ADDR_magic != addr->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"address_get_ascii_addr",
	      "Bad magic number",0);

    return addr->ascii_address;
}


/* Rerurn 1 if address have all datat as NULL 
   (Note that <> is not NULL on that case)
*/

int address_is_empty(addr)
     const struct address * addr;
{
    if (ADDR_magic != addr->magic)
	panic("ADDR PANIC",__FILE__,__LINE__,"address_is_empty",
	      "Bad magic number",0);

    if ( addr->phrase)
	return 0;

    if (addr->comment)
	return 0;

    if (addr->ascii_address)
	return 0;

    return 1;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
