case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot="../.."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting lib/addr/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.17 2024/06/10 18:05:34 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                  (was hurtta+elm@posti.FMI.FI)
#      or  Kari Hurtta <elm@elmme-mailer.org>
#
#
#
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
REG             =       ../../bin/elmregister 

$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot

!GROK!THIS!

if $test "$d_shared" = "$define" ; then
   A=
   if $test "$soname_include_path" = y ; then
	A="$shlib/"
   fi

cat >>Makefile <<SUBSTITUTE
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-addr.so$d_shared_rev
SONAME          = ${soname_opt}${A}libelmme-addr.so$d_shared_rev
SOTARG          = ../../shlib/libelmme-addr.so

SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
INSTLIB         =
SONAME		=
SOTARG          = 
!NO!SUBS!

fi

$cat >>Makefile <<'!NO!SUBS!'
IHDR		=	../../hdrs
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
OBJS            =       init.o addr_list.o address.o getaddr.o mlist.o \
 dispaddr.o mailer.o headers.o outheaders.o write_hdr.o okay_addr.o \
 error.o parsestring.o getid.o message-id.o references.o outexpires.o \
 date.o parsarpdat.o getword.o split_addr.o duplicate.o md5c.o md5_wrapper.o \
 digest.o outdate.o file_changes.o

all:	Makefile ../../libs/libelmme-addr.a $(SOTARG)
install_s: all $(INSTLIB)

uninstall_s:
	$(REG) rm $(INSTLIB)

clean: 
	rm -f $(OBJS) ../../shlib/libelmme-addr.so ../../libs/libelmme-addr.a

.PRECIOUS: $(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_addr.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_addr.h: $(IHDR)/elm_defs.h $(INCLDIR)/addrlib.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh 
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

init.o:      def_addr.h $(INCLDIR)/rc_imp.h $(INCLDIR)/save_opts.h
addr_list.o: def_addr.h 
address.o:   def_addr.h 
digest.o:    def_addr.h
duplicate.o: def_addr.h 
get_addr.o:  def_addr.h 
file_changes.o: def_addr.h
mlist.o:     def_addr.h $(INCLDIR)/mlist_imp.h $(INCLDIR)/mlist_common.h
md5c.o:		def_addr.h md5_global.h md5.h
md5_wrapper.o:	def_addr.h md5_global.h md5.h $(INCLDIR)/digest_imp.h
dispaddr.o:   def_addr.h
mailer.o:    def_addr.h
headers.o:   def_addr.h $(INCLDIR)/s_me.h $(INCLDIR)/hdr_imp.h
outheaders.o: def_addr.h $(INCLDIR)/s_me.h $(INCLDIR)/hdr_imp.h
okay_addr.o: def_addr.h
split_addr.o: def_addr.h
write_hdr.o: def_addr.h
getaddr.o:   def_addr.h $(INCLDIR)/s_me.h
error.o:     def_addr.h
getid.o:     def_addr.h $(INCLDIR)/s_me.h
message-id.o:  def_addr.h
references.o:  def_addr.h
parsestring.o: def_addr.h
outdate.o:  def_addr.h
outexpires.o:  def_addr.h
date.o:        def_addr.h
parsarpdat.o:  def_addr.h
getword.o:     def_addr.h

../../libs/libelmme-addr.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

../../shlib/libelmme-addr.so: $(OBJS)
	$(CC) $(LFLAGS) $(SONAME) -o $@ $(OBJS) 

$(INSTLIB): ../../shlib/libelmme-addr.so
	$(REG) copy -m 644 $? $@

!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi
