case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot=".."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

case "$d_strstr" in
define)	strsrc= strobj= ;;
*)	strsrc="strstr.c"
	strobj="strstr.o"
	;;
esac

case "$d_strftime" in
define)	ftimesrc= ftimeobj= ;;
*)	ftimesrc="strftime.c"
	ftimeobj="strftime.o"
	;;
esac

case "$d_msgcat" in
define) msgcatsrc= msgcatobj= ;;
*)      msgcatsrc=msgcat.c
        msgcatobj=msgcat.o
	;;
esac

case "$d_dlopen_libs" in
define)  sharedsrc="shared.c shared_config.c shared_connect.c shared_base.c shared_all.c"
	 sharedobj="shared.o shared_config.o shared_connect.o shared_base.o shared_all.o"
	 ;;
*)	 sharedsrc=
	 sharedobj=
	;;
esac

case "$d_wchar" in
define)  widesrc="cs_wfallback.c"
         wideobj="cs_wfallback.o"
	 ;;
*)       widesrc=
	 wideobj=
	 ;;
esac

echo "Extracting lib/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.34 2023/12/13 16:55:32 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Modified by Kari Hurtta Kari Hurtta <hurtta+elm@siilo.FMI.FI>
#                                (was  hurtta+elm@posti.FMI.FI)
#         or  Kari Hurtta <elm@elmme-mailer.org>
######################################################################
# Based on Elm 2.4 lib/Makefile.SH. That code was following copyright:
#
#	Copyright (c) 1986,1987 Dave Taylor
#	Copyright (c) 1988-1992 USENET Community Trust
######################################################################
#
#
# Variables
#	Variables established by Configure
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
LIBSO           =       $dlopen_lib
SED		=	$sed
CHMOD		=	$chmod
LINT		=	$lint
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
MV		=	$mv
TOUCH		=	$touch
TAGS		=	ctags

EGREP		=	$egrep
SORT		=	$sort
UNIQ		=	$uniq
DIFF		=	$diff 

STRSRC		=	$strsrc
STROBJ		=	$strobj

FTIMESRC	=	$ftimesrc
FTIMEOBJ	=	$ftimeobj

MSGCATSRC	=	$msgcatsrc
MSGCATOBJ	=	$msgcatobj

SHAREDSRC	=	$sharedsrc
SHAREDOBJ	=	$sharedobj

WIDESRC         =       $widesrc
WIDEOBJ         =       $wideobj

$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

case "$ccflags$optimize" in
	*-DDEBUG*)
cat >>Makefile <<SUBSTITUTE
DEBUGSRC = debug.c
DEBUGOBJ = debug.o
SUBSTITUTE
	;;
	*)
cat >>Makefile <<SUBSTITUTE
DEBUGSRC = 
DEBUGOBJ = 
SUBSTITUTE
	;;
esac

if $test "$d_shared" = "$define" ; then

	A=
	if $test "$soname_include_path" = y ; then
		A="$shlib/"
	fi

cat >>Makefile <<SUBSTITUTE
SHLIST          = ../shlib/libelmme-base.so
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-base.so$d_shared_rev
SONAME          = ${soname_opt}${A}libelmme-base.so$d_shared_rev
SHLIB		= $shlib
SUBSTITUTE

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =
INSTLIB         =
SONAME		=
SHLIB		= 
!NO!SUBS!

fi

$cat >>Makefile <<'!NO!SUBS!'

#	Other general variables
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) 
IHDR		=	../hdrs
INCLDIR		=	$(SRCROOT)/hdrs
SHELL		=	/bin/sh
REG		=	../bin/elmregister

# 	Lists
LIB_OBJ		=	atonum.o	\
			bindata.o	\
			mmaputil.o	\
			mparse.o	\
			can_open.o	\
			cancel.o        \
			chloc.o		\
			conf_writer.o	\
			convert_status.o \
			charset.o       \
			precompiled_sets.o \
			charset_input.o \
			cs_binary.o	\
			cs_iso2022.o	\
			cs_fallback.o	\
			cs_utf.o	\
			cs_unknown.o    \
                        $(WIDEOBJ)      \
			date_util.o	\
			$(DEBUGOBJ)	\
                        delay_unlink.o  \
			digest_wrapper.o \
			dynarray.o	\
			errno.o		\
			expand.o	\
			file_util.o     \
			gcos_name.o	\
			get_tz.o	\
			hdrdecode.o	\
			hdrencode.o	\
			getaddr.o	\
			getarpdate.o	\
			getfullnam.o	\
			in_string.o	\
			iso2022.o 	\
			iso2022_map.o	\
			istrcmp.o	\
			ldstate.o	\
			len_next.o	\
			mail_gets.o	\
			$(MSGCATOBJ)	\
			okay_addr.o	\
			opt_utils.o	\
			out_entity.o	\
			output.o	\
			panic.o		\
			pager_lineext.o \
			pager_range.o	\
			pgrng_bfr_binding.o \
			posixsig.o	\
			putenv.o	\
			qstrings.o	\
			rc_delay.o	\
			rc_handle.o	\
			rc_parse.o	\
			rc_propline.o	\
			read_rc.o	\
			remote_mbx.o	\
			reverse.o	\
			rfc822tlen.o	\
			stringtok.o	\
			safemalloc.o	\
			$(SHAREDOBJ)	\
			sb_file.o       \
			sb_mem.o        \
			schedule.o	\
                        schedule_time.o \
			service_list.o	\
			shiftlower.o	\
			sortlist.o	\
			state.o		\
			state_in.o	\
			state_in_gets.o	\
			state_out.o	\
			state_out_buffer.o \
                        static-hosts.o  \
			streamsched.o	\
			strfcpy.o	\
			strincmp.o	\
			string.o	\
			string_alt.o	\
			string_sort.o	\
			stringbuffer.o	\
			striparens.o	\
			$(STROBJ)	\
			$(FTIMEOBJ)	\
			strmcpy.o	\
			syscall.o	\
			terminal.o	\
			unicode.o	\
			unidata.o	\
			write_rc.o      \
			safeopen.o

all:			magic_diffs Makefile ../libs/libelmme-base.a $(SHLIST)

install_s:	Makefile ../libs/libelmme-base.a $(INSTLIB)

uninstall_s:		
	$(REG) rm $(INSTLIB)

../libs/libelmme-base.a:		$(LIB_OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

XXfilelist:	$(SRCROOT)/MANIFEST
		awk '$$1 ~ /\.[ch]$$/ { print "$(SRCROOT)/"$$1 }' $? > $@

magic_res3:	XXfilelist
		rm -f x??
		cat $? | split -100
		cp /dev/null  magic_res3
		for filelist in x??; do $(EGREP) -h '#define .*_magic' `cat $$filelist` >> magic_res3 || true; done

magic_res1:	magic_res3
		$(SORT) < $? | $(UNIQ) > magic_res1 

magic_res2:	MAGIC 
		$(SORT) $? > magic_res2		

magic_diffs:	magic_res1 magic_res2		
		@if $(DIFF) -c -b magic_res1 magic_res2 > magic_diffs; then  \
		   echo "lib/MAGIC OK" ; \
                else \
                   echo "lib/MAGIC NOT up of date !!!" ; \
                   cat magic_diffs ; \
	           exit 1; \
                fi

tags:

clean:		
		$(RM) $(LIB_OBJ) ../libs/libelmme-base.a ../shlib/libelmme-base.so

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(IHDR)/elm_defs.h $(IHDR)/shared_imp.h \
 $(IHDR)/defs_major.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/shared_imp.h:	 ../shared_libs/include/shared.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

#	Dependencies of C object files

putenv.o:	$(IHDR)/defs_major.h
strstr.o:	$(IHDR)/defs_major.h

atonum.o:	$(IHDR)/elm_defs.h
bindata.o:	$(IHDR)/elm_defs.h $(INCLDIR)/mmaputil.h \
 $(INCLDIR)/cs_imp.h $(INCLDIR)/s_me.h $(INCLDIR)/bindata.h
mmaputil.o:	$(IHDR)/elm_defs.h $(INCLDIR)/mmaputil.h
dynarray.o:	$(IHDR)/elm_defs.h
aliasdb.o:	$(IHDR)/elm_defs.h 
can_open.o:	$(IHDR)/elm_defs.h
cancel.o:       $(IHDR)/elm_defs.h $(INCLDIR)/s_me.h
chloc.o:	$(IHDR)/elm_defs.h
charset.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h \
 $(IHDR)/shared_imp.h
conf_writer.o:	$(IHDR)/elm_defs.h $(INCLDIR)/conf_writer_imp.h
lib/convert_status.o: $(IHDR)/defs_major.h $(IHDR)/convert_status.h
mparse.o:	$(IHDR)/elm_defs.h
precompiled_sets.o: $(INCLDIR)/cs_imp.h $(INCLDIR)/elmlib.h $(INCLDIR)/elm_defs.h
charset_input.o: $(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
cs_binary.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h \
 $(INCLDIR)/bindata.h
cs_fallback.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
cs_wfallback.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
cs_utf.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h
cs_unknown.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/cs_imp.h $(INCLDIR)/cs_terminal.h 
cs_iso2022.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/cs_imp.h $(INCLDIR)/cs_terminal.h
date_util.o:	$(IHDR)/elm_defs.h
debug.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_elm.h \
  $(INCLDIR)/patchlevel.h
delay_unlink.o:	$(IHDR)/elm_defs.h $(INCLDIR)/schedule_time.h \
  $(INCLDIR)/s_me.h 
digest_wrapper.o: $(IHDR)/elm_defs.h $(INCLDIR)/digest_imp.h
errno.o:	$(IHDR)/elm_defs.h
expand.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_elmrc.h 
file_util.o:    $(IHDR)/elm_defs.h $(INCLDIR)/s_elm.h \
  $(INCLDIR)/s_me.h 
gcos_name.o:	$(IHDR)/elm_defs.h
get_tz.o:	$(IHDR)/elm_defs.h
getaddr.o:	$(IHDR)/elm_defs.h
getarpdate.o:	$(IHDR)/elm_defs.h
getfullnam.o:	$(IHDR)/elm_defs.h
hdrdecode.o:  	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h  
hdrencode.o:  	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h  
in_string.o:	$(IHDR)/elm_defs.h
iso2022.o: 	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/cs_imp.h
iso2022_map.o: 	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/cs_imp.h
istrcmp.o:	$(IHDR)/elm_defs.h
ldstate.o:	$(IHDR)/elm_defs.h
len_next.o:	$(IHDR)/elm_defs.h
mail_gets.o:	$(IHDR)/elm_defs.h
msgcat.o:	$(INCLDIR)/msgcat.h $(IHDR)/elm_defs.h
okay_addr.o:	$(IHDR)/elm_defs.h
opt_utils.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_error.h
out_entity.o:	$(IHDR)/elm_defs.h $(INCLDIR)/state_imp.h
output.o:	$(IHDR)/elm_defs.h
panic.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h
pager_lineext.o:	$(IHDR)/elm_defs.h $(INCLDIR)/pg_lineext_imp.h \
 $(INCLDIR)/sb_imp.h
pager_range.o:	$(IHDR)/elm_defs.h $(INCLDIR)/pg_range_imp.h \
  $(INCLDIR)/pg_params_imp.h $(INCLDIR)/elmme-magic.h
pgrng_bfr_binding.o:	$(IHDR)/elm_defs.h $(INCLDIR)/pg_range_imp.h \
  $(INCLDIR)/pg_params_imp.h $(IHDR)/elmme-magic.h
posixsig.o:	$(IHDR)/elm_defs.h
rc_delay.o:	$(IHDR)/elm_defs.h $(INCLDIR)/save_opts.h \
  $(INCLDIR)/rc_imp.h $(INCLDIR)/s_elmrc.h 
rc_handle.o:	$(IHDR)/elm_defs.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/s_elm.h $(INCLDIR)/rc_imp.h $(IHDR)/shared_imp.h \
 $(INCLDIR)/s_elmrc.h 
rc_parse.o:	$(IHDR)/elm_defs.h $(INCLDIR)/rc_imp.h $(INCLDIR)/s_elm.h \
  $(INCLDIR)/save_opts.h
rc_propline.o:	$(IHDR)/elm_defs.h $(INCLDIR)/rc_imp.h
read_rc.o:      $(IHDR)/elm_defs.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/unidata.h $(INCLDIR)/cs_imp.h $(INCLDIR)/connection_imp.h \
 $(INCLDIR)/schedule_time.h
remote_mbx.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/mbx_imp.h $(IHDR)/shared_imp.h $(INCLDIR)/ss_imp.h \
 $(INCLDIR)/connection_imp.h $(INCLDIR)/schedule_time.h $(INCLDIR)/save_opts.h
qstrings.o:	$(IHDR)/elm_defs.h
reverse.o:	$(IHDR)/elm_defs.h
rfc822tlen.o:	$(IHDR)/elm_defs.h
stringtok.o:	$(IHDR)/elm_defs.h
safemalloc.o:	$(IHDR)/elm_defs.h
safeopen.o:	$(IHDR)/elm_defs.h
shared.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_elm.h \
 $(IHDR)/shared_imp.h $(INCLDIR)/mbx_imp.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/cs_imp.h $(INCLDIR)/ss_imp.h \
 $(INCLDIR)/mailer_imp.h $(INCLDIR)/schedule_time.h \
 $(INCLDIR)/connection_imp.h
shared_config.o: $(IHDR)/elm_defs.h $(IHDR)/shared_imp.h \
 $(INCLDIR)/cs_imp.h $(INCLDIR)/save_opts.h
shared_connect.o:  $(IHDR)/elm_defs.h \
 $(IHDR)/shared_imp.h $(INCLDIR)/rc_imp.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/cs_imp.h  \
 $(INCLDIR)/mbx_imp.h $(INCLDIR)/ss_imp.h $(INCLDIR)/mailer_imp.h \
 $(INCLDIR)/schedule_time.h
shared_base.o:  $(IHDR)/elm_defs.h \
 $(IHDR)/shared_imp.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/save_opts.h $(INCLDIR)/cs_imp.h \
 $(IHDR)/connection_imp.h $(INCLDIR)/schedule_time.h
shared_all.o:  $(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(IHDR)/shared_imp.h $(INCLDIR)/save_opts.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/cs_imp.h 
sb_file.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/sb_imp.h $(INCLDIR)/pg_range_imp.h \
 $(INCLDIR)/pg_lineext_imp.h $(INCLDIR)/elmme-magic.h \
 $(INCLDIR)/pg_params_imp.h
sb_mem.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/sb_imp.h $(INCLDIR)/pg_range_imp.h \
 $(INCLDIR)/pg_lineext_imp.h $(INCLDIR)/elmme-magic.h \
 $(INCLDIR)/pg_params_imp.h
schedule.o:	$(IHDR)/elm_defs.h $(INCLDIR)/schedule_time.h \
  $(INCLDIR)/s_me.h
schedule_time.o: $(IHDR)/elm_defs.h $(INCLDIR)/schedule_time.h
service_list.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/s_me.h $(INCLDIR)/connection_imp.h \
 $(IHDR)/shared_imp.h $(INCLDIR)/ss_imp.h $(INCLDIR)/rc_imp.h \
 $(INCLDIR)/schedule_time.h $(INCLDIR)/service_imp.h
shiftlower.o:	$(IHDR)/elm_defs.h
sortlist.o:	$(IHDR)/elm_defs.h
state.o:	$(IHDR)/elm_defs.h $(INCLDIR)/state_imp.h
state_in.o:	$(IHDR)/elm_defs.h $(INCLDIR)/state_imp.h
state_in_gets.o:	$(IHDR)/elm_defs.h $(INCLDIR)/state_imp.h
state_out.o:	$(IHDR)/elm_defs.h $(INCLDIR)/state_imp.h \
  $(INCLDIR)/pg_range_imp.h $(INCLDIR)/elmme-magic.h \
  $(INCLDIR)/pg_params_imp.h
state_out_buffer.o:	$(IHDR)/elm_defs.h $(INCLDIR)/state_imp.h \
  $(INCLDIR)/pg_range_imp.h
static-hosts.o: $(IHDR)/elm_defs.h  $(INCLDIR)/connection_imp.h \
  $(INCLDIR)/schedule_time.h $(INCLDIR)/service_imp.h \
  $(INCLDIR)/s_me.h
streamsched.o:	$(IHDR)/elm_defs.h $(INCLDIR)/ss_imp.h $(INCLDIR)/mbx_imp.h \
 $(IHDR)/shared_imp.h $(INCLDIR)/schedule_time.h
strfcpy.o:      $(IHDR)/elm_defs.h
strftime.o:     $(IHDR)/elm_defs.h
string.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h \
 $(IHDR)/shared_imp.h
string_alt.o:	$(IHDR)/elm_defs.h $(INCLDIR)/elmme-magic.h
string_sort.o:	$(IHDR)/elm_defs.h $(INCLDIR)/cs_imp.h
stringbuffer.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/sb_imp.h $(INCLDIR)/pg_range_imp.h \
 $(INCLDIR)/pg_lineext_imp.h
strmcpy.o:      $(IHDR)/elm_defs.h
strincmp.o:	$(IHDR)/elm_defs.h
striparens.o:	$(IHDR)/elm_defs.h
syscall.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_elm.h  
terminal.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h $(INCLDIR)/cs_terminal.h
unicode.o:	$(IHDR)/elm_defs.h $(INCLDIR)/s_me.h $(INCLDIR)/cs_imp.h \
 $(INCLDIR)/unidata.h
unidata.o:      $(IHDR)/elm_defs.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/unidata.h
write_rc.o:     $(IHDR)/elm_defs.h $(INCLDIR)/s_elmrc.h 
!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
../shlib/libelmme-base.so: $(LIB_OBJ)
		$(CC) $(LFLAGS) $(SONAME) -o $@ $(LIB_OBJ) $(LIBSO)

$(SHLIB):
		$(REG) mkdir $(SHLIB)

$(INSTLIB):	$(SHLIB) ../shlib/libelmme-base.so
		$(REG) copy -m 644 ../shlib/libelmme-base.so $@
!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

!NO!SUBS!

fi



