/* $Id: shared_imp.h,v 2.13 2022/11/02 16:26:29 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "../shared_libs/include/shared.h"

extern struct shared_CT {
    struct connection_type *T;
    struct ImpInfo * imp_idx;
}          * shared_connection_types;
extern int   shared_connection_type_count;

extern struct shared_ST {
    struct stream_type * T;
    struct ImpInfo * imp_idx;
}          * shared_stream_types;
extern int   shared_stream_type_count;

extern struct shared_SEOT {
  struct SE_option_type * T;
  struct ImpInfo * imp_idx;
}          * shared_SE_option_types;
extern int   shared_SE_option_type_count;

extern struct shared_CST {
   struct  charset_type       * T;
   struct ImpInfo * imp_idx;
 }          * shared_CS_types;
extern int    shared_CS_type_count;

extern struct  charset_type * find_shared_CS_type P_((const char *val));

extern int cs_auto_charset P_((const char *name,
			       struct  charset_type **type,
			       struct  map_info **map));

extern int verify_shared_index P_((struct ImpInfo *i));

extern struct shared_MCF {
  struct mailer_config * T;
  struct ImpInfo       * imp_idx;
}        * shared_MCF_types;
extern int shared_MCF_type_count;

#define IMPINFO_magic		0xF91F

struct ImpInfo {
    unsigned short magic;   /* IMPINFO_magic */
    
    char * tag;
    char * shname;
    void * handle;
    
    struct reg_list {
	struct dt_shared_info *var;
	int valid;
	
	int updated;
	union {
	    void * dummy;
	    
	    struct sl_base_data    * base;
	    struct sl_config_data  * config;
	    struct sl_connect_data * connect;
	    struct sl_mailer_data  * mailer;
	    struct sl_mbox_data    * mbox;
	    struct sl_smtp_data    * smtp;
	} r;
    }                        * regs;
    int                      regs_count;

    struct rc_save_info_rec * rc_options;
    size_t                    rc_option_count;

    RC_post_init_f          * rc_post_init;
    wants_rand_bits_f       * wants_rand_bits;
    RC_fill_enum_values_f   * fill_enum_values;
    free_shared_cache_f     * free_shared_cache;

    unsigned int              valid          :1;
    unsigned int              base_lists_updated :1;    
    unsigned int              post_init_done :1;
    unsigned int              delayed        :1;

};

/* zero cell of array */
typedef void sl_zero_reg_list P_((struct dt_shared_info *var,
				  struct reg_list *r));



typedef int sl_reg_functions P_((struct ImpInfo *i,
				 int reg_idx));
typedef void sl_unreg_functions P_((struct ImpInfo *i,
				    int reg_idx));

#define SHARED_LOADER_magic     0xF900

struct  shared_loader {
    uint16            magic;      

    sl_reg_functions  *func_reg;
    sl_zero_reg_list    *func_zero;
    sl_unreg_functions  *func_unreg;
};

extern void load_shared_libs1 P_((struct dt_shared_info *var));
extern void post_init_shared_options1 P_((struct dt_shared_info *var));
extern void post_init_shared_opt1 P_((struct dt_shared_info *var,
				      int idx));


extern int locate_and_load_library1 P_((const char *prefix,
					struct dt_shared_info *var));
extern int give_rnum P_((struct ImpInfo * I, struct dt_shared_info *var));

extern enum verlib_status {
        verlib_bad         = -1,
	verlib_not_loaded  = 0,
	verlib_found,
	verlib_delayed
} verify_library_prefix P_((const char *prefix,
			    struct dt_shared_info *var,
			    int read_flags /* READ_FLAG_IGNORE_MISSING */
			    ));


extern struct ImpInfo **library_list;
extern int              library_list_count;

extern struct ImpInfo * give_impinfo P_((const char * tag));
extern int reg_code1 P_((struct ImpInfo *I, int r));
extern void load_shared_libs P_((void));
extern int tag_ok P_((const char *name));
extern void load_code0 P_((struct ImpInfo *I));
extern void register_list P_((SHAREDLIB *Z));
extern void reg_code_libs P_((struct ImpInfo *I));


extern void register_hidden_library P_((struct dt_shared_info *parent,
					struct dt_shared_info *lib));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */


