/* @(#)$Id: sb_imp.h,v 2.6 2023/12/13 16:55:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#if ANSI_C
struct pgrng_bfr_binding;
#endif

#define STRINGBUFFER_magic   0xEB0D

struct stringbuffer {
    unsigned short             magic;    /* STRINGBUFFER_magic */

    int refcount;

    struct sb_type           * buffer_type;
    union {
	void                * dummy;
	struct sb_in_file   * file;
	struct sb_in_mem    * mem;
    } a;

    int have_next_lineext;
};

typedef int  sb_init_buffer P_((struct stringbuffer *buffer));
typedef void sb_free_buffer P_((struct stringbuffer *buffer));
typedef void sb_add_line_to_stringbuffer P_((struct stringbuffer *buffer,
					     const struct string *string,
					     int pg_flags,struct pager_range *range,
					     struct pgrng_bfr_binding  * binding));
typedef int sb_linecount_stringbuffer P_((const struct stringbuffer *ptr));
typedef struct string *sb_get_line_from_stringbuffer P_((struct stringbuffer *buffer,
							 int ptr,
							 int *pg_flags,
							 struct pager_range **range,
							 struct pager_lineext **first_extension));


typedef void sb_add_pager_range_to_stringbuffer P_((struct stringbuffer 
						    * buffer,
						    struct pgrng_bfr_binding 
						    * binding,
						    struct pager_range 
						    * range));
/* Caller must call free_pager_range() */
typedef struct pager_range * sb_get_pager_range_from_stringbuffer 
    P_((struct stringbuffer * buffer, int index));

typedef void sb_add_lineext_to_stringbuffer P_((struct stringbuffer *buffer,
						const struct string *string,
						int pg_flags,struct pager_range *range,
						struct pgrng_bfr_binding  * binding));

typedef struct string *sb_walk_lineext_on_stringbuffer P_((struct stringbuffer *buffer,
							   struct pager_lineext **walk_extension,
							   int *pg_flags,
							   struct pager_range **range));


/* entity is processed as lineext */
typedef enum stringbuffer_entity_result sb_add_entity_to_stringbuffer
    P_((struct stringbuffer       * buffer,
	const struct out_entity   * oe,
	int                         pg_flags,
	struct pager_range        * range,
	struct pgrng_bfr_binding  * binding));

typedef void sb_add_pager_param_to_stringbuffer
    P_((struct stringbuffer       * buffer,
	struct pgrng_bfr_binding  * binding,
	struct pager_range        * range,
	enum pager_param_opcode     opcode,
	struct pager_param_value  * param_value));

typedef struct pager_param_value * sb_get_pager_param_from_stringbuffer
     P_((struct stringbuffer      * buffer,
	 struct pager_range       * range,
	 enum pager_param_opcode    opcode,
	 int                      * next_pos,
	 struct pgrng_bfr_binding * binding,
	 int                      * found_pos
	 ));

#define SB_TYPE_magic	     0xEB0E

struct sb_type {
    unsigned short                  magic;   /* SB_TYPE_magic */
    sb_init_buffer                * sb_init_it;
    sb_free_buffer                * sb_free_it;
    sb_add_line_to_stringbuffer   * sb_add_line_to_it;
    sb_linecount_stringbuffer     * sb_linecount_it;
    sb_get_line_from_stringbuffer * sb_get_line_from_it;
    sb_add_pager_range_to_stringbuffer * sb_add_pager_range_to_it;
    sb_get_pager_range_from_stringbuffer * sb_get_pager_range_from_it;
    sb_add_lineext_to_stringbuffer * sb_add_lineext_to_it;
    sb_walk_lineext_on_stringbuffer * sb_walk_lineext_on_it;
    sb_add_entity_to_stringbuffer   * sb_add_entity_to_it;
    sb_add_pager_param_to_stringbuffer   * sb_add_pager_param_to_it;
    sb_get_pager_param_from_stringbuffer * sb_get_pager_param_from_it;
};

extern struct sb_type   sb_in_mem;
extern struct sb_type   sb_in_file;

/* ----------------- */

extern struct string *walk_lineext_on_stringbuffer P_((struct stringbuffer 
						       *buffer,
						       struct pager_lineext 
						       **walk_extension,
						       int *pg_flags,
						       struct pager_range 
						       **range));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
