/* @(#)$Id: save_opts.h,v 2.71 2024/06/10 18:05:34 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.71 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 hdrs/save_opts.h. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from hdrs/save_opts.h. 
 *  That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/*
 *	Defines for the storage of options portion of the Elm system.
 */


struct OLD_optsmenu {
    char letter;                /* menu letter on options screen */
    char *menu;                 /* menu prompt */
    int  menu_msg;              /* NLS message number of menu prompt */
    char *parm;                 /* parameter to modify */
    void (*post) P_((int));     /* post processing function */
    char *one_liner;            /* one line help message */
    int  one_liner_msg;         /* NLS message number of one line help message */

    const int * conditional_option_p;
};

#define FL_SHOWSYS    010      /* flag is this options should also be written to system RC */
#define FL_ASCIIFIRST 020      /* flag if processed on first pass as ASCII */
#define FL_LOCAL 0040          /* flag if changed (on user elmrc) */
#define FL_NOSPC 0100          /* flag if preserve blanks as "_" */
#define FL_SYS   0200          /* flag if only valid in system RC */
#define FL_OR    0400          /* flag if boolean value may have been set */
#define FL_AND  01000          /* flag if boolean value may have been unset */
#define FL_SAVED 02000         /* Used by elmrc-write                      */
#define FL_CHANGED 04000       /* flag is not compiled in default          */


#define PATH_file           1
#define PATH_dir            2
#define PATH_quote          4
#define PATH_expand        16
#define PATH_ascii_only    32
#define PATH_sep_comma     64
#define PATH_sep_colon    128
#define PATH_quote_single 256
#define PATH_convert_underline 512
#define PATH_initial          1024          /* not allocated */

struct dt_path_info {
    int flags;
    char * unexpanded;
    int nlen;
    char ** list;
};

#if ANSI_C
struct dt_estr_info;
struct dt_keyword_info;
struct dt_enum_shared;
#define E_(x) extern x;
#else
#define E_(x)
#endif

/* Returns 1 if success, 0 failure/no mask expansion, 
   -1 if expansion is not string 
*/
typedef int keyword_expand_func P_((struct dt_estr_info *kw,
				    struct dt_keyword_info *ki,
				    unsigned int keyword,
				    unsigned int continue_mask));

E_(keyword_expand_func null_keyword_expand)
extern int null_keyword_expand P_((struct dt_estr_info *kw,
				   struct dt_keyword_info *ki,
				   unsigned int keyword,
				   unsigned int continue_mask));
				    
struct dt_keyword_info  {
    keyword_expand_func * expand;
  
    struct keyword_val {
	char       * kw; 
	unsigned int val;              /* Is mask if continue line */
	unsigned int  is_continue_mask :1;
    } * keyword_val;  /* NULL terminated array */
}; 

#define ESTR_meta          1
#define ESTR_bin           2
#define ESTR_slash         4
#define ESTR_none          8
#define ESTR_metamail      16
#define ESTR_print_expanded  64   /* # truncates value */
#define ESTR_initial        128   /* not allocated     */

struct dt_estr_info {
    int flags;
    char * unexpanded;
    char * expanded;
    
    unsigned int  is_keyword;      /* 0 == no keyword */
    unsigned int  continue_mask;   /* flags on continue line */
    struct dt_keyword_info  *kw;  /* NULL == no keyword values */
    unsigned int  expanded_keyword;
};

#ifdef USE_DLOPEN
struct dt_shared_info {
    struct           shared_loader *loader;

    int               libraries_loaded;

    struct ImpInfo   **shared_list;
    int               shared_list_len;

    struct dt_shared_info   * hidden_var;
};
#endif

#define DT_ENUM_SHARED_magic	0xF406

typedef void free_dt_enum_shared_f P_((struct dt_enum_shared **ptr));

struct dt_enumerate_info {
    int val;            /* if val < 0 then on  struct dt_enum_shared */         
  
    int nlen;
    char **list;

    /* This allows shared modules introduce new enumerated values.
       They are used on form tag:value
    */

    struct dt_enum_shared {
	unsigned short magic;   /* DT_ENUM_SHARED_magic */

	char * tag;
	int    start_value;  /* < 0 */

	int  nlen;
	char ** list;

	free_dt_enum_shared_f * free_this;
	struct dt_enum_shared * next_shared;

    } * first_shared;

    unsigned int   have_boolean : 1;

    struct dt_enum_delayed  * delayed;
    
    char *  val_as_string;  /* dt_enum_get_value() and 
			       give_dt_enumerate_as_str() returns */
};

struct dt_sort_info {
    int val;
    struct sortval { 
	char *kw; 
	int sv; 
    } * sortval;
};

struct dt_flags_info {
    unsigned long val;

    unsigned long incremental_add;
    unsigned long incremental_sub;

    int nlen;
    char ** flagval;

    unsigned long allowed_flags;

    unsigned int absolute:1;

    char *  val_as_string;  /* dt_FLAGS_get_value() returns */
};

typedef struct rc_save_info_rec { 
    char 	     name[NLEN]; 	/* name of instruction */
    struct rc_type * dt_type;           /* DT_STR, DT_NUM, DT_BOL, etc */
    int	             flags;	        /* FL_LOCAL, FL_NOSPC, etc */
    union {
	char 	*str;
	int 	*num;
	long  *l_num;
	int 	*bol;
	char 	*chr;
	struct dt_sort_info *sort;
	struct dt_path_info *path;
	char    **mlt;

#ifdef USE_DLOPEN
	struct dt_shared_info *shared;
#endif
	struct dt_estr_info *estr;
	struct dt_enumerate_info *enumerate;
	struct string ** String;
	struct dt_flags_info     *flags;
	void     *dummy;			
    } val;
    option_func      *func_val;
    int size_val;
    union {
	const int              * conditional_option_p;
	const enum poll_method * poll_method_p;
    } conditional_option;

} save_info_recs;

#define SAVE_INFO_STR(x) (save_info[x].val.str)
#define SAVE_INFO_NUM(x) (save_info[x].val.num)
#define SAVE_INFO_BOL(x) (save_info[x].val.bol)


E_(option_func null_option_func)
extern int null_option_func P_((char **value, int enter,
				int lineno, const char *filename,
				int read_flags /* READ_FLAG_IGNORE_MISSING */
				));

#if __GNUC__ 
#define ZZZ_SAVE_TYPE save_info_recs
#define ZZZ_DT_SORT(A)       &rc_DT_SORT,0, { sort: A }, null_option_func
#define ZZZ_DT_STR(A)        DT_STR,0,   { str: A },  null_option_func
#define ZZZ_DT_STR_(x,A)     DT_STR,x, { str: A },  null_option_func
#define ZZZ_DT_BOL(A)        DT_BOL,0,   { bol: A },  null_option_func
#define ZZZ_DT_BOL_(x,A)     DT_BOL,x, { bol: A },  null_option_func
#define ZZZ_DT_MLT(A)        DT_MLT,0,   { mlt: A }, null_option_func
#define ZZZ_DT_SYN(A)        DT_SYN,0,   { str: A },  null_option_func
#define ZZZ_DT_NUM(A)        DT_NUM,0,   { num: A },  null_option_func
#define ZZZ_DT_NUM_(x,A)     DT_NUM,x,   { num: A },  null_option_func
#define ZZZ_DT_LONG(A)       DT_NUM,0,   { l_num: A },null_option_func

#define ZZZ_DT_FUNC(A)       DT_FUNC,0,  { str: NULL }, A
#define ZZZ_DT_FUNC_(x,A)    DT_FUNC,x,  { str: NULL }, A
#define ZZZ_DT_CHR(A)        &rc_DT_CHR,0,   { chr: A },  null_option_func
#define ZZZ_DT_PRM(A)        DT_PRM,0,   { num: A },  null_option_func
#define ZZZ_DT_PATH(A)       &rc_DT_PATH,0, { path: A }, null_option_func
#define ZZZ_DT_PATH_(x,A)    &rc_DT_PATH,x, { path: A }, null_option_func
#define ZZZ_DT_OBS0          &rc_DT_OBS,0, { str: NULL }, null_option_func
#define ZZZ_DT_SHARED(A)     &rc_DT_SHARED,0, { shared: A }, null_option_func
#define ZZZ_DT_ESTR(A)       &rc_DT_ESTR,0, { estr: A }, null_option_func
#define ZZZ_DT_ESTR_(x,A)    &rc_DT_ESTR,x, { estr: A }, null_option_func
#define ZZZ_DT_ENUM(A)       &rc_DT_ENUM,0, { enumerate: A }, null_option_func
#define ZZZ_DT_ENUM_(x,A)    &rc_DT_ENUM,x, { enumerate: A }, null_option_func
#define ZZZ_DT_DELAY         &rc_DT_DELAY,0,{ str: NULL }, null_option_func
#define ZZZ_DT_DELAY_(x)     &rc_DT_DELAY,x,{ str: NULL }, null_option_func
#define ZZZ_DT_DELAYSHARED      &rc_DT_DELAYSHARED,0,{ str: NULL }, null_option_func
#define ZZZ_DT_DELAYSHARED_(x)  &rc_DT_DELAYSHARED,x,{ str: NULL }, null_option_func
#define ZZZ_DT_STRING(A)     &rc_DT_STRING,0, { String: A },  null_option_func
#define ZZZ_DT_STRING_(x,A)  &rc_DT_STRING,x, { String: A },  null_option_func
#define ZZZ_DT_FLAGS(A)      &rc_DT_FLAGS,0, { flags: A }, null_option_func
#define ZZZ_DT_FLAGS_(x,A)   &rc_DT_FLAGS,x, { flags: A }, null_option_func

#define TAILCOND_INT(A)      { conditional_option_p: A }
#define TAILCOND_POLL(A)     { poll_method_p: A }

#define ZZZ_TAIL             0, { conditional_option_p: NULL }
#define NULL_TAILCOND        { conditional_option_p: NULL }

#else


/*
 *	since many C compilers cannot init a union as a static
 *	init, make the same structure with just the char * for
 *	the union pointer.
 */
typedef struct { 
    char 	 name[NLEN]; 	        /* name of instruction */
    struct rc_type * dt_type;           /* DT_STR, DT_NUM, DT_BOL, etc */
    int	          flags;	        /* FL_LOCAL, FL_NOSPC, etc */
    char 	 *str;
    option_func  *func;
    int              size_val;
    const int    * conditional_option_p;
} ZZZ_SAVE_TYPE;

#define ZZZ_DT_SORT(A) &rc_DT_SORT, 0,(char *)A, null_option_func
#define ZZZ_DT_STR(A) DT_STR, 0,A,              null_option_func
#define ZZZ_DT_STR_(x,A) DT_STR,x,A,         null_option_func 
#define ZZZ_DT_BOL(A) DT_BOL, 0,(char *)A,      null_option_func
#define ZZZ_DT_BOL_(x,A) DT_BOL,x,(char *)A, null_option_func
#define ZZZ_DT_MLT(A) DT_MLT,0,(char *)A,      null_option_func
#define ZZZ_DT_SYN(A) DT_SYN,0,A,              null_option_func
#define ZZZ_DT_NUM(A) DT_NUM,0,(char *)A,      null_option_func
#define ZZZ_DT_NUM_(x,A) DT_NUM,x,(char *)A,      null_option_func
#define ZZZ_DT_LONG(A) DT_NUM,0,(char *)A,     null_option_func

#define ZZZ_DT_FUNC(A)       DT_FUNC,0,NULL, A
#define ZZZ_DT_FUNC_(x,A)    DT_FUNC,x,NULL, A
#define ZZZ_DT_CHR(A) &rc_DT_CHR,0,(char *)A, null_option_func
#define ZZZ_DT_PRM(A) DT_PRM,0,(char *)A, null_option_func
#define ZZZ_DT_PATH(A)       &rc_DT_PATH,0, (char *)A, null_option_func
#define ZZZ_DT_PATH_(x,A)    &rc_DT_PATH,x, (char *)A, null_option_func
#define ZZZ_DT_OBS0          &rc_DT_OBS,0, NULL , null_option_func
#define ZZZ_DT_SHARED(A)     &rc_DT_SHARED,0, (char *)A, null_option_func
#define ZZZ_DT_ESTR(A)       &rc_DT_ESTR,0, (char *)A, null_option_func
#define ZZZ_DT_ESTR_(x,A)    &rc_DT_ESTR,x, (char *)A, null_option_func
#define ZZZ_DT_ENUM(A)       &rc_DT_ENUM,0, (char *)A, null_option_func
#define ZZZ_DT_ENUM_(x,A)    &rc_DT_ENUM,x, (char *)A, null_option_func
#define ZZZ_DT_DELAY         &rc_DT_DELAY,0, NULL, null_option_func
#define ZZZ_DT_DELAY_(x)     &rc_DT_DELAY,x, NULL, null_option_func
#define ZZZ_DT_DELAYSHARED   &rc_DT_DELAYSHARED,0,NULL, null_option_func
#define ZZZ_DT_DELAYSHARED_(x)  &rc_DT_DELAYSHARED,x,NULL, null_option_func
#define ZZZ_DT_STRING(A)     &rc_DT_STRING,0, (char *)A,  null_option_func
#define ZZZ_DT_STRING_(x,A)  &rc_DT_STRING,x, (char *)A,  null_option_func
#define ZZZ_DT_FLAGS(A)      &rc_DT_FLAGS,0,  (char *)A, null_option_func
#define ZZZ_DT_FLAGS_(x,A)   &rc_DT_FLAGS,x,  (char *)A, null_option_func

#define TAILCOND_INT(A)      A 
#define TAILCOND_POLL(A)     (int *) A

#define                      ZZZ_TAIL 0, NULL
#define NULL_TAILCOND        NULL
#endif



/* write_rc.c */


extern void write_rc_part P_((FILE       * targetfile_F,
			      const char * part_tag /* NULL for main part */,
			      FILE       * commentfile_F /* NULL if no commentfile */,
			      int          global,
			      charset_t    rcset,
			      struct rc_save_info_rec * rc_options,
			      size_t                    rc_option_count));

/* shared.c */

extern void print_local_shared_options P_((FILE *F, int global,
					   charset_t rcset,
					   int default_commentfile));
extern void post_init_shared_options P_((int *errors, 
					 int read_flags /* READ_FLAG_IGNORE_MISSING */
					 ));
extern void free_shared_rc_options P_((void));

/* shared_config.c */

/* change default of unset options */

extern void post_init_change_config P_((int *errors,int flag,
					const char * tag,
					struct rc_save_info_rec * rc_options,
					size_t                    rc_option_count,
					size_t rec_size));

/* read_rc.c */

E_(option_func nameresfunc)
extern int nameresfunc P_((char **value, int enter,
			   int lineno, const char *filename,
			   int read_flags /* READ_FLAG_IGNORE_MISSING */
			   ));

extern char elmrc_charset[SLEN];

/* lib/remote_mbx.c */

E_(option_func connect_mode_func)
extern int connect_mode_func P_((char **value, int enter,
				 int lineno, const char *filename,
				 int read_flags /* READ_FLAG_IGNORE_MISSING */
				 ));


/* ===================================================================== */

#ifdef SAVE_OPTS

/* "lists" for DT_MLT.  These and DT_SYN could be eliminated if support
   of the old parameter names was dropped.
*/
static char *SIGS[]=      {"remotesignature","localsignature",NULL};
static char *ALWAYSLEAVE[]=    {"alwayskeep",     "!alwaysstore",NULL};

static char *ASK[]       ={"askdelete","askkeep","askstore", NULL};
static char *AUTOCOPY[]  ={"!askreplycopy","replycopy",NULL};

static char *MAILCAPS[]    = { "internal-mailcaps", "metamail-mailcaps", NULL};
static char *PROMPTAFTER[] = { "prompt-after-metamail", 
			       "prompt-after-pager", NULL};

ZZZ_SAVE_TYPE save_info_data[] = {

    {"@charset",                ZZZ_DT_STR_(FL_ASCIIFIRST,elmrc_charset), 
     sizeof elmrc_charset,                                              NULL_TAILCOND },
    {"add-in-reply-to-phrase",  ZZZ_DT_BOL(&add_irt_phrase),            ZZZ_TAIL },
    {"add-sender",              ZZZ_DT_ENUM_(FL_SYS,&add_sender_header), ZZZ_TAIL },
    {"address-lookup",          ZZZ_DT_ENUM_(FL_SHOWSYS,
					     &address_lookup),          ZZZ_TAIL },    
    {"alias-group-phrase",      ZZZ_DT_BOL(&alias_group_phrase),        ZZZ_TAIL },
    {"aliassortby",		ZZZ_DT_SORT(&alias_sortby),             ZZZ_TAIL },
    {"allow-charset-switching", ZZZ_DT_BOL(&allow_charset_switching),   ZZZ_TAIL },
    {"allow-setuid",            ZZZ_DT_BOL_(FL_SYS,&allow_setuid),      ZZZ_TAIL },
    {"alteditor",		ZZZ_DT_ESTR(&alternative_editor_e),     ZZZ_TAIL },
    {"alternatives",	        ZZZ_DT_PATH(&alternative_addresses),    ZZZ_TAIL },
    {"alwaysdelete",	        ZZZ_DT_BOL(&always_del),                ZZZ_TAIL },
    {"alwayskeep",		ZZZ_DT_BOL(&always_keep),               ZZZ_TAIL },
    {"alwaysleave",		ZZZ_DT_MLT(ALWAYSLEAVE),                ZZZ_TAIL },
    {"alwaysstore",		ZZZ_DT_BOL(&always_store),              ZZZ_TAIL },
    {"arrow",		        ZZZ_DT_BOL_(FL_OR,&arrow_cursor),       ZZZ_TAIL },
    {"ask",			ZZZ_DT_MLT(ASK),                        ZZZ_TAIL },
    {"askcc",		        ZZZ_DT_BOL(&prompt_for_cc),             ZZZ_TAIL },
    {"askdelete",               ZZZ_DT_BOL(&ask_delete),                ZZZ_TAIL },
    {"askkeep",                 ZZZ_DT_BOL(&ask_keep),                  ZZZ_TAIL },
    {"askmimeforward",          ZZZ_DT_BOL(&askmimeforward),            ZZZ_TAIL },
    {"askpgpsig",		ZZZ_DT_BOL(&pgp_askpgpsig),          0, TAILCOND_INT(&use_PGP) },
    {"askreplycopy",            ZZZ_DT_BOL(&ask_reply_copy),            ZZZ_TAIL },
    {"askstore",                ZZZ_DT_BOL(&ask_store),                 ZZZ_TAIL },
    {"attachment-dir",          ZZZ_DT_ESTR(&attachment_dir_e),         ZZZ_TAIL },
    {"attachment-fix-extension",ZZZ_DT_BOL(&attachment_fix_extension),  ZZZ_TAIL },
    {"attribution",		ZZZ_DT_STRING(&attribution_s),          ZZZ_TAIL },
    {"auto-attachment",         ZZZ_DT_ENUM(&auto_attachment),
     sizeof auto_attachment,                                            NULL_TAILCOND },
    {"auto-cc",		        ZZZ_DT_SYN("copy"),                     ZZZ_TAIL },
    {"auto-iso-8859",           ZZZ_DT_BOL(&auto_iso_8859),             ZZZ_TAIL },
    {"autocopy",		ZZZ_DT_MLT(AUTOCOPY),                   ZZZ_TAIL },
#ifdef BACKGROUD_PROCESSES       
    {"background-wait-time",    ZZZ_DT_NUM(&background_wait_time),      ZZZ_TAIL }, 
#endif
    {"bindata",                 ZZZ_DT_STR_(FL_ASCIIFIRST,raw_bindata_path),
     sizeof raw_bindata_path,                                           NULL_TAILCOND },
    {"bounce",		        ZZZ_DT_SYN("bounceback"),               ZZZ_TAIL },
    {"bounceback",	        ZZZ_DT_OBS0,                            ZZZ_TAIL },
    {"browser-tabcomplete-prompt", ZZZ_DT_BOL(&browser_tabcomplete),    ZZZ_TAIL },
    {"browser-wildcard-matching",  ZZZ_DT_ENUM(&browser_wildcards),     ZZZ_TAIL },
    {"builtinlines",	        ZZZ_DT_NUM(&builtin_lines),             ZZZ_TAIL },
    {"calendar",		ZZZ_DT_ESTR(&calendar_file_e),          ZZZ_TAIL },
    {"cc",			ZZZ_DT_SYN("askcc"),                    ZZZ_TAIL },
    {"charset",                 ZZZ_DT_SYN("text-charset"),             ZZZ_TAIL },
    {"charset-convert-ok",      ZZZ_DT_BOL(&charset_convert_ok),        ZZZ_TAIL },
    {"check-type-pattern",      ZZZ_DT_BOL(&check_type_pattern),        ZZZ_TAIL },
    {"compatcharsets",	        ZZZ_DT_OBS0,                            ZZZ_TAIL },
    {"conf-merge-locking",      ZZZ_DT_FLAGS(&conf_merge_locking),      ZZZ_TAIL },
    {"configoptions",	        ZZZ_DT_STR(config_options), 
     sizeof config_options,                                             NULL_TAILCOND },
    {"confirmappend",	        ZZZ_DT_BOL(&confirm_append),            ZZZ_TAIL },
    {"confirmcreate",	        ZZZ_DT_BOL(&confirm_create),            ZZZ_TAIL },
    {"confirmfiles",	        ZZZ_DT_BOL(&confirm_files),             ZZZ_TAIL },
    {"confirmfolders",	        ZZZ_DT_BOL(&confirm_folders),           ZZZ_TAIL },
    {"confirmprint",            ZZZ_DT_BOL(&confirm_print),             ZZZ_TAIL },
    {"confirmtagsave",	        ZZZ_DT_BOL(&confirm_tag_save),          ZZZ_TAIL },
#ifdef REMOTE_MBX
    {"connect-mode",            ZZZ_DT_FUNC_(FL_SHOWSYS,connect_mode_func),
                                                                        ZZZ_TAIL },
#endif
    {"convert-comment-to-fullname",ZZZ_DT_BOL(&convert_comment),        ZZZ_TAIL },
    {"convert-cr-to-newline-hack",ZZZ_DT_ENUM(&convert_cr_to_newline_hack), ZZZ_TAIL },
    {"convert-utf-header",      ZZZ_DT_BOL(&convert_utf_header),        ZZZ_TAIL },
    {"copy",		        ZZZ_DT_BOL(&auto_copy_sent),            ZZZ_TAIL },
    {"dead-letter-dir",         ZZZ_DT_ESTR(&dead_letter_dir_e),        ZZZ_TAIL },
    {"default-folder-status",   ZZZ_DT_ENUM(&def_folder_status),
     sizeof def_folder_status,                                          NULL_TAILCOND },
    {"default-mime-text-charset",ZZZ_DT_STR(raw_default_mimetext_charset),
     sizeof raw_default_mimetext_charset,                               NULL_TAILCOND },
    {"default-nomime-charset",  ZZZ_DT_STR(raw_default_nomime_charset), 
     sizeof raw_default_nomime_charset,                                 NULL_TAILCOND }, 
    {"delete",		        ZZZ_DT_SYN("alwaysdelete"),             ZZZ_TAIL },
    {"displaycharset",	        ZZZ_DT_STR(raw_display_charset),
     sizeof raw_display_charset,                                        NULL_TAILCOND },
    {"dsn-success",             ZZZ_DT_BOL(&DSN_success),               ZZZ_TAIL },
    {"dsnmail",                 ZZZ_DT_ESTR(&dsn_mail_e),               ZZZ_TAIL },
    {"easyeditor",		ZZZ_DT_STR(e_editor),   sizeof e_editor, NULL_TAILCOND    },
    {"editflush",	        ZZZ_DT_BOL(&edit_flush),                ZZZ_TAIL },
    {"editor",		        ZZZ_DT_ESTR(&editor_e),                 ZZZ_TAIL },
    {"editor-al-propline",      ZZZ_DT_DELAY,                           ZZZ_TAIL },
    {"editor-elmrc-propline",   ZZZ_DT_ENUM_(FL_ASCIIFIRST,
					     &editor_elmrc_propline),   ZZZ_TAIL },
    {"editor-hm-propline",      ZZZ_DT_DELAY,                           ZZZ_TAIL },
    {"editor-ml-propline",      ZZZ_DT_DELAY,                           ZZZ_TAIL },
    {"editor-ms-propline",      ZZZ_DT_ENUM(&editor_ms_propline),       ZZZ_TAIL },
    {"editor-tfent-propline",   ZZZ_DT_DELAY,                           ZZZ_TAIL },
#if USERMAP_PROPLINE
    {"editor-usermap-propline", ZZZ_DT_DELAY,                           ZZZ_TAIL },
#endif
    {"env-from-source",         ZZZ_DT_ENUM(&env_from_source),
     sizeof env_from_source,                                            NULL_TAILCOND },
    {"escape",		        ZZZ_DT_CHR(&escape_char),               ZZZ_TAIL },
    {"expires-have-time",       ZZZ_DT_BOL(&Expires_have_time),         ZZZ_TAIL },
    {"extra-mailbox-dir",       ZZZ_DT_ESTR(&extra_mailbox_dir_e),      ZZZ_TAIL },
    {"file-browser-show-dotfiles",ZZZ_DT_BOL (&fb_show_dotfiles),       ZZZ_TAIL },
    {"file-browser-show-protection", ZZZ_DT_BOL (&fb_show_protection),  ZZZ_TAIL },
    {"file-browser-show-title", ZZZ_DT_BOL (&fb_show_title),            ZZZ_TAIL },
    {"file-browser-sortby",     ZZZ_DT_SORT(&fb_sort_order),            ZZZ_TAIL }, 
    {"folder-locking",          ZZZ_DT_FLAGS(&folder_locking),          ZZZ_TAIL },
    {"folders",		        ZZZ_DT_SYN("maildir"),                  ZZZ_TAIL },
    {"forcename",		ZZZ_DT_BOL(&force_name),                ZZZ_TAIL },
    {"form",		        ZZZ_DT_SYN("forms"),                    ZZZ_TAIL },
    {"forms",		        ZZZ_DT_OBS0,                            ZZZ_TAIL },
    {"fragment-handling",       ZZZ_DT_ENUM(&fragment_handling),        ZZZ_TAIL },
    {"fullname",		ZZZ_DT_STRING(&full_username_s),        ZZZ_TAIL },
    {"fwdattribution",	        ZZZ_DT_STRING(&fwdattribution_s),       ZZZ_TAIL },
    {"generate-message-id",     ZZZ_DT_DELAY_(FL_SHOWSYS),              ZZZ_TAIL },
    {"gpg",	                ZZZ_DT_ESTR(&gpg_path_e), 0 ,           TAILCOND_INT(&use_PGP) },
    {"header-phrase-display-mode", ZZZ_DT_ENUM(&phrase_display_mode),   ZZZ_TAIL },
    {"hostdomain",		ZZZ_DT_STR_(FL_SYS|FL_ASCIIFIRST,hostdomain), 
     sizeof hostdomain,                                                 NULL_TAILCOND },
    {"hostfullname",	        ZZZ_DT_STR_(FL_SYS|FL_ASCIIFIRST,hostfullname), 
     sizeof hostfullname,                                               NULL_TAILCOND },
    {"hostname",		ZZZ_DT_STR_(FL_SYS|FL_ASCIIFIRST,hostname),     
     sizeof hostname,                                                   NULL_TAILCOND },
    {"hpkeypad",	        ZZZ_DT_SYN("keypad"),                   ZZZ_TAIL }, 
    {"hpsoftkeys",	        ZZZ_DT_SYN("softkeys"),                 ZZZ_TAIL }, 
#ifdef REMOTE_MBX
    {"imap-charset",            ZZZ_DT_STR(raw_imap_charset),
     sizeof raw_imap_charset,                                           NULL_TAILCOND },
    {"imap-connection-cache",   ZZZ_DT_BOL(&IMAP_connection_cache),     ZZZ_TAIL },
    {"imap-dir-sortby",         ZZZ_DT_SORT(&imap_dir_sortby),          ZZZ_TAIL },
    {"imap-fast-lookup",        ZZZ_DT_BOL(&imap_fast_lookup),          ZZZ_TAIL },
    {"imap-idle-alive-interval", ZZZ_DT_NUM(&imap_idle_alive_interval), ZZZ_TAIL },
    {"imap-max-download-size",  ZZZ_DT_NUM(&imap_max_dl_size),          ZZZ_TAIL },
    {"imap-naming-convention",  ZZZ_DT_BOL(&IMAP_name_convention),      ZZZ_TAIL },
    {"imap-show-error",         ZZZ_DT_BOL(&IMAP_show_error),           ZZZ_TAIL },
    {"imap-show-greeting",      ZZZ_DT_BOL(&IMAP_show_greeting),        ZZZ_TAIL },
    {"imap-show-warning",       ZZZ_DT_BOL(&IMAP_show_warning),         ZZZ_TAIL },
    {"imap-use-examine",        ZZZ_DT_BOL(&IMAP_use_examine),          ZZZ_TAIL },
#endif
    {"incoming-mailbox",        ZZZ_DT_ESTR(&defaultfile_e),            ZZZ_TAIL },
    {"incomingfolders",         ZZZ_DT_PATH(&incomingfolders),          ZZZ_TAIL },
    {"internal-mailcap-prompt-trusted",  
     ZZZ_DT_BOL(&internal_mailcap_t_prompt),                            ZZZ_TAIL },
    {"internal-mailcap-trusted-programs",
     ZZZ_DT_PATH(&internal_mailcap_t_programs),                         ZZZ_TAIL },
    {"internal-mailcaps",       ZZZ_DT_PATH(&internal_mailcaps),        ZZZ_TAIL },
#ifdef HAVE_SCOPE
    {"ipv6-scope-id",           ZZZ_DT_FLAGS_(FL_SHOWSYS,&ipv6_scope_id), 
                                                                        ZZZ_TAIL },
#endif           
    {"iso646-charsets",         ZZZ_DT_OBS0,                            ZZZ_TAIL },
    {"keep",		        ZZZ_DT_SYN("keepempty"),                ZZZ_TAIL },
    {"keepempty",		ZZZ_DT_BOL(&keep_empty_files),          ZZZ_TAIL },
    {"keeppassfor",             ZZZ_DT_NUM(&pgp_keeppassfor), 0,        TAILCOND_INT(&use_PGP) },
    {"keypad",	                ZZZ_DT_OBS0,                            ZZZ_TAIL },
    
    {"last-read-fallback-locking",       ZZZ_DT_DELAY,                  ZZZ_TAIL }, 
    {"local-dir-sortby",        ZZZ_DT_SORT(&local_dir_sortby),         ZZZ_TAIL },
    {"local-fast-lookup",       ZZZ_DT_BOL(&local_fast_lookup),         ZZZ_TAIL },
    {"local-fs-charset",        ZZZ_DT_STR(raw_local_fs_charset), 
     sizeof raw_local_fs_charset,                                       NULL_TAILCOND },
#ifdef PIDCHECK
    {"local-lockfile-pidcheck", 
     ZZZ_DT_ENUM_(FL_SYS,&local_lockfile_pidcheck),                     ZZZ_TAIL },
#endif
    {"local-sessionlock-dir",   ZZZ_DT_STR_(FL_SYS,local_sessionlock_dir),
     sizeof local_sessionlock_dir,                                      NULL_TAILCOND },
    {"local-sessionlock-use-home",  
     ZZZ_DT_ENUM_(FL_SYS,&local_sessionlock_use_home),                  ZZZ_TAIL },
#if defined(WCHAR) && defined(__STDC_ISO_10646__)
    {"locale-charsets",         ZZZ_DT_PATH(&locale_charsets),          ZZZ_TAIL },
#endif
    {"localsignature",	        ZZZ_DT_ESTR(&local_signature_e),        ZZZ_TAIL },
#ifdef SYSCALL_LOCKING
    {"lock-folders",            ZZZ_DT_BOL(&lockfolders),               ZZZ_TAIL },
    {"lock-in-copy",            ZZZ_DT_BOL(&lock_in_copy),              ZZZ_TAIL },
#endif
    {"long-encoded-headers",    ZZZ_DT_BOL(&long_encoded_headers),      ZZZ_TAIL },
    
    {"mail-menu-time",          ZZZ_DT_FLAGS(&mail_menu_time),          ZZZ_TAIL },
    {"mail-services-lookup",    ZZZ_DT_ENUM_(FL_SHOWSYS,
					     &mail_services_lookup),    ZZZ_TAIL },
    {"mailbox",		        ZZZ_DT_OBS0,                            ZZZ_TAIL }, 
    {"mailbox-locking",         ZZZ_DT_FLAGS(&mailbox_locking),         ZZZ_TAIL },
    {"mailcap-blacklist-programs", ZZZ_DT_PATH(&mailcap_bl_programs),   ZZZ_TAIL },
    {"mailcap-select-other",    ZZZ_DT_BOL(&mailcap_select_other),      ZZZ_TAIL },
    {"mailcap-tempfile-lifetime",ZZZ_DT_NUM(&mailcap_tempfile_lifetime), 0, TAILCOND_POLL(&POLL_method) },
    {"mailcaps",                ZZZ_DT_MLT(MAILCAPS),                   ZZZ_TAIL },
    {"maildir",		        ZZZ_DT_ESTR(&folders_e),                ZZZ_TAIL },
    {"mailedit",		ZZZ_DT_SYN("editor"),                   ZZZ_TAIL },
    {"mailer",                  ZZZ_DT_DELAY_(FL_SYS),                  ZZZ_TAIL },
    {"mailhome-dir",            ZZZ_DT_ESTR_(FL_SYS,&mailhome_dir_e),   ZZZ_TAIL },
    {"mailhome-locking",        ZZZ_DT_FLAGS_(FL_SYS,&mailhome_locking),ZZZ_TAIL },
    {"mailname",                ZZZ_DT_PATH_(FL_SYS|FL_ASCIIFIRST,&mailname), 
                                                                        ZZZ_TAIL },
    {"mailpermissions",	        ZZZ_DT_PRM(&mail_permissions),          ZZZ_TAIL },
    {"map-bin-dir",             ZZZ_DT_ESTR_(FL_SYS,&map_bindir_e),     ZZZ_TAIL },
    {"map-text-dir",            ZZZ_DT_ESTR_(FL_SYS,&map_txtdir_e),     ZZZ_TAIL },
    {"menu",		        ZZZ_DT_BOL_(FL_AND,&mini_menu_rc),      ZZZ_TAIL },
    {"menu-display-host",       ZZZ_DT_BOL(&menu_display_host),         ZZZ_TAIL }, 
    {"menus",		        ZZZ_DT_SYN("menu"),                     ZZZ_TAIL },
    {"message-hide-hack",       ZZZ_DT_ENUM(&message_hide_hack),        ZZZ_TAIL },
    {"metamail",		ZZZ_DT_ESTR(&metamail_path_e),          ZZZ_TAIL },
    {"metamail-mailcaps",       ZZZ_DT_PATH(&metamail_mailcaps),        ZZZ_TAIL },
    {"metoo",		        ZZZ_DT_BOL(&metoo),                     ZZZ_TAIL },
    {"mime-encoded-filename-hack", ZZZ_DT_BOL(&mime_rfc1522_filename),  ZZZ_TAIL },
    {"mime-parameters",         ZZZ_DT_ENUM(&mime_parameters),          ZZZ_TAIL },
    {"mimebodykeywords",	ZZZ_DT_BOL(&mime_body_keywords),        ZZZ_TAIL },
    {"mimeforward",             ZZZ_DT_ENUM(&mimeforward),              ZZZ_TAIL },
    {"movepage",		ZZZ_DT_BOL(&move_when_paged),           ZZZ_TAIL },
    {"movewhenpaged",	        ZZZ_DT_SYN("movepage"),                 ZZZ_TAIL },
    {"name",		        ZZZ_DT_SYN("fullname"),                 ZZZ_TAIL },
#ifdef REMOTE_MBX
    {"name-lookup-cache-time",  ZZZ_DT_NUM(&name_lookup_cache_time),    ZZZ_TAIL },
    {"name-lookup-cancel",      ZZZ_DT_ENUM(&name_lookup_cancel),       ZZZ_TAIL },
#endif
    {"name-resolution",         ZZZ_DT_FUNC_(FL_SYS|FL_ASCIIFIRST,nameresfunc),
                                                                        ZZZ_TAIL },
    {"names",		        ZZZ_DT_BOL(&names_only),                ZZZ_TAIL },
    {"noencoding",              ZZZ_DT_ENUM(&allow_no_encoding),        ZZZ_TAIL },
    {"nohdrencoding",           ZZZ_DT_BOL(&allow_no_hdrencoding),      ZZZ_TAIL },
    {"noheader",		ZZZ_DT_BOL(&noheader),                ZZZ_TAIL },
    {"noheaderfwd",		ZZZ_DT_BOL(&noheaderfwd),             ZZZ_TAIL },
    {"page",		        ZZZ_DT_SYN("pager"),                  ZZZ_TAIL },
    {"page-known-charsets",	ZZZ_DT_BOL(&page_known_charsets),     ZZZ_TAIL },
    {"page-tagfilter",          ZZZ_DT_DELAY,                         ZZZ_TAIL },
    {"pagealternative",	        ZZZ_DT_BOL(&pagealternative),         ZZZ_TAIL },
    {"pagemultipart",	        ZZZ_DT_BOL(&pagemultipart),           ZZZ_TAIL },
    {"pager",		        ZZZ_DT_ESTR(&pager_e),                ZZZ_TAIL },
    {"pager-header-display-mode", ZZZ_DT_ENUM(&pg_header_display_mode), ZZZ_TAIL },
    {"pager-indicate-wrapping", ZZZ_DT_BOL(&pager_indicate_wrapping), ZZZ_TAIL },
    {"pager-paragraph-width",   ZZZ_DT_NUM(&pager_paragraph_width),   ZZZ_TAIL },
    {"pager-time-display",      ZZZ_DT_ENUM(&pager_time_display),     ZZZ_TAIL },
    {"pagerelated",             ZZZ_DT_ENUM(&pagerelated),            ZZZ_TAIL },
    {"pagesigned",	        ZZZ_DT_BOL(&pagesigned),              ZZZ_TAIL },
    {"pgp",		        ZZZ_DT_SYN("pgp2"), 0,                TAILCOND_INT(&use_PGP) },
    {"pgp-encrypt-type",	ZZZ_DT_ENUM(&pgp_encrypt_type),
      sizeof pgp_encrypt_type,                                          TAILCOND_INT(&use_PGP) },
     {"pgp-interactive",         ZZZ_DT_BOL(&pgp_interactive), 0,       TAILCOND_INT(&use_PGP) }, 
     {"pgp-sign-type",	        ZZZ_DT_ENUM(&pgp_sign_type),
      sizeof pgp_sign_type,                                             TAILCOND_INT(&use_PGP) },
     {"pgp-version",	        ZZZ_DT_ENUM(&send_pgp_version),
      sizeof send_pgp_version,                                          TAILCOND_INT(&use_PGP) },    
     {"pgp2",	                ZZZ_DT_ESTR(&pgp2_path_e), 0,           TAILCOND_INT(&use_PGP) },
     {"pgp5-dir",                ZZZ_DT_ESTR(&pgp5_dir_e), 0,           TAILCOND_INT(&use_PGP) },
    {"pointflagged",            ZZZ_DT_BOL(&point_to_flagged),          ZZZ_TAIL },
    {"pointnew",		ZZZ_DT_BOL(&point_to_new),              ZZZ_TAIL },
    {"pointtonew",		ZZZ_DT_SYN("pointnew"),                 ZZZ_TAIL },
#ifdef REMOTE_MBX
    {"pop-idle-alive-interval", ZZZ_DT_NUM(&pop_idle_alive_interval),   ZZZ_TAIL },
    {"pop-max-download-size",   ZZZ_DT_NUM(&pop_max_dl_size),           ZZZ_TAIL },
    {"pop-show-greeting",       ZZZ_DT_BOL(&POP_show_greeting),         ZZZ_TAIL },
#endif
    {"precedences",		ZZZ_DT_STR(allowed_precedences), 
     sizeof allowed_precedences,                                        NULL_TAILCOND },
    {"prefix",		        ZZZ_DT_STRING_(FL_NOSPC,&quote_prefix), ZZZ_TAIL },
    {"print",		        ZZZ_DT_ESTR(&printout_e),               ZZZ_TAIL },
    {"printhdrs",               ZZZ_DT_STR(printhdrs), sizeof printhdrs, NULL_TAILCOND }, 
    {"printmail",		ZZZ_DT_SYN("print"),                    ZZZ_TAIL },
    {"program-identification",  ZZZ_DT_FLAGS(&program_snd_ident),      ZZZ_TAIL },
    {"prompt-after-metamail",   ZZZ_DT_BOL(&prompt_after_metamail),     ZZZ_TAIL },
    {"prompt-after-pager",      ZZZ_DT_BOL(&prompt_after_pager),        ZZZ_TAIL },
    {"prompt-metamail",         ZZZ_DT_BOL(&prompt_metamail),           ZZZ_TAIL }, 
    {"promptafter",	        ZZZ_DT_MLT(PROMPTAFTER),                ZZZ_TAIL },
    {"question",		ZZZ_DT_SYN("ask"),                      ZZZ_TAIL },
    {"quoteforward",	        ZZZ_DT_BOL(&quote_forward),             ZZZ_TAIL },
    {"readdatapercentinc",	ZZZ_DT_NUM(&readdatapercentinc),        ZZZ_TAIL },
    {"readmsg",                 ZZZ_DT_ESTR(&readmsg_e),                ZZZ_TAIL },
    {"readmsginc",		ZZZ_DT_NUM(&readmsginc),                ZZZ_TAIL },
    {"receivedmail",	        ZZZ_DT_ESTR(&recvd_mail_e),             ZZZ_TAIL },
    {"remotesignature",	        ZZZ_DT_ESTR(&remote_signature_e),       ZZZ_TAIL },
    {"replycopy",	        ZZZ_DT_BOL(&reply_copy),                ZZZ_TAIL },
    {"require-mime-version-for-body-encoding",
                                ZZZ_DT_BOL(&req_mime_bodyencoding),     ZZZ_TAIL },
    {"require-mime-version-for-hdr-encoding",
                                ZZZ_DT_BOL(&req_mime_hdrencoding),      ZZZ_TAIL },
    {"resolve",		        ZZZ_DT_BOL(&resolve_mode),              ZZZ_TAIL }, 
    {"savebyalias",	        ZZZ_DT_BOL(&save_by_alias),             ZZZ_TAIL },
    {"savebyname",		ZZZ_DT_SYN("savename"),                 ZZZ_TAIL },
    {"savemail",		ZZZ_DT_SYN("sentmail"),                 ZZZ_TAIL },
    {"savename",		ZZZ_DT_BOL(&save_by_name),              ZZZ_TAIL },
    {"saveto",		        ZZZ_DT_SYN("sentmail"),                 ZZZ_TAIL },
    {"send-mime-plain-text",    ZZZ_DT_BOL(&send_mime_plain), 
     sizeof send_mime_plain,                                            NULL_TAILCOND },
    {"sentmail",		ZZZ_DT_ESTR(&sent_mail_e),              ZZZ_TAIL },
    {"set-window-title",        ZZZ_DT_BOL(&set_window_title),
     sizeof set_window_title,                                           NULL_TAILCOND },   
    {"shell",		        ZZZ_DT_ESTR(&shell_e),                  ZZZ_TAIL },
    {"show-header-errors",      ZZZ_DT_ENUM(&show_header_errors_e),     ZZZ_TAIL },
    {"show-mail-quota",         ZZZ_DT_ENUM(&show_mail_quota_e),        ZZZ_TAIL },
    {"showmlists",	        ZZZ_DT_BOL(&show_mlists),               ZZZ_TAIL },
    {"showpgppreamble",	        ZZZ_DT_BOL(&pgp_noarmor), 0,            TAILCOND_INT(&use_PGP) },
    {"showreply",	        ZZZ_DT_BOL(&show_reply),                ZZZ_TAIL },
    {"showto",		        ZZZ_DT_BOL(&showto),           		ZZZ_TAIL },
    {"sigdashes",		ZZZ_DT_BOL(&sig_dashes), 		ZZZ_TAIL },
    {"signature",		ZZZ_DT_MLT(SIGS), 			ZZZ_TAIL },
    {"sleepmsg",		ZZZ_DT_NUM(&sleepmsg), 			ZZZ_TAIL },
    {"softkeys",	        ZZZ_DT_OBS0, 				ZZZ_TAIL }, 
    {"sort",		        ZZZ_DT_SYN("sortby"), 			ZZZ_TAIL },
    {"sort-thread-max-time",    ZZZ_DT_NUM(&sort_thread_max_time), 	ZZZ_TAIL },
    {"sortby",		        ZZZ_DT_SORT(&sortby), 			ZZZ_TAIL },
    {"special-use-domains-blacklist", ZZZ_DT_PATH(&special_bl_domains), ZZZ_TAIL },
#ifdef REMOTE_MBX
    {"special-use-domains-lookup",ZZZ_DT_FLAGS(&special_domains_lookup),ZZZ_TAIL },
    {"static-hosts-max-names",  ZZZ_DT_NUM(&static_hosts_max_names),    ZZZ_TAIL },
#endif
    {"store",		        ZZZ_DT_SYN("alwaysstore"), 		ZZZ_TAIL },
    {"text-charset",	        ZZZ_DT_STR(raw_text_charset), 
     sizeof raw_text_charset,                                           NULL_TAILCOND },
    {"textencoding",            ZZZ_DT_OBS0, 				ZZZ_TAIL }, 
    {"thread-sortby",		ZZZ_DT_SORT(&thread_sortby), 		ZZZ_TAIL },
    {"timeout",		        ZZZ_DT_LONG(&elm_timeout), 		ZZZ_TAIL },
    {"titles",		        ZZZ_DT_BOL(&title_messages), 		ZZZ_TAIL },
    {"tmpdir",	                ZZZ_DT_ESTR(&temp_dir_e),  		ZZZ_TAIL },
    {"tochars",		        ZZZ_DT_STR_(FL_NOSPC,to_chars), 
     sizeof to_chars,                                                   NULL_TAILCOND },
    {"unidata",                 ZZZ_DT_STR_(FL_ASCIIFIRST,raw_unidata_path),
     sizeof raw_unidata_path,                                           NULL_TAILCOND },
    {"unstable-reverse-thread", ZZZ_DT_BOL(&unstable_reverse_thread), 	ZZZ_TAIL },
#ifdef USE_DLOPEN
    {"use-base-library",        ZZZ_DT_SHARED(&use_shared_base), 	ZZZ_TAIL },
#endif
    {"use-char-set-header-field-hack", ZZZ_DT_BOL(&use_char_set_field_hack), ZZZ_TAIL },
#ifdef USE_DLOPEN
    {"use-config-library",      ZZZ_DT_SHARED(&use_shared_config),  	ZZZ_TAIL },
    {"use-connect-library",     ZZZ_DT_SHARED(&use_shared_connect), 	ZZZ_TAIL },
#endif
    {"use-content-type-charset-for-8bit-subject-hack", ZZZ_DT_BOL(&use_ct_cs_for_subj_hack), ZZZ_TAIL },
    {"use-last-read-file",       ZZZ_DT_DELAY,                          ZZZ_TAIL }, 
#ifdef USE_DLOPEN
    {"use-library",             ZZZ_DT_SHARED(&use_shared_all), 	ZZZ_TAIL }, 
    {"use-mailer-library",      ZZZ_DT_DELAYSHARED, 			ZZZ_TAIL },
#endif    
    {"use-tls",                 ZZZ_DT_FLAGS(&use_tls),                 ZZZ_TAIL },
    {"usepgppass",              ZZZ_DT_BOL(&pgp_keeppass), 0,          TAILCOND_INT(&use_PGP) },
    {"user-conf-rewrite",       ZZZ_DT_DELAY,                           ZZZ_TAIL },
    {"user-map-dir",            ZZZ_DT_DELAY_(FL_SYS),                  ZZZ_TAIL },
    {"userlevel",		ZZZ_DT_ENUM(&user_level), 		ZZZ_TAIL },
    {"username",		ZZZ_DT_SYN("fullname"), 		ZZZ_TAIL },
    {"usetite",		        ZZZ_DT_BOL_(FL_AND,&use_tite), 		ZZZ_TAIL },
    {"utf7-encode-optional",    ZZZ_DT_BOL(&utf7_encode_optional), 	ZZZ_TAIL },
    {"valid-domains",           ZZZ_DT_DELAY, 				ZZZ_TAIL },
    {"valid-msg-id-domains",    ZZZ_DT_DELAY, 				ZZZ_TAIL },
    {"verify-alias-domain",     ZZZ_DT_BOL(&verify_alias_domain), 	ZZZ_TAIL },
    {"verify-domain",           ZZZ_DT_ENUM(&verify_domain), 		ZZZ_TAIL },
    {"verify-local-address",    ZZZ_DT_BOL(&verify_local_address), 	ZZZ_TAIL },
    {"verify-local-domain",     ZZZ_DT_ENUM(&verify_local_domain),      ZZZ_TAIL },
    {"visualeditor",	        ZZZ_DT_STR(v_editor), sizeof v_editor,  NULL_TAILCOND },
    {"weed",		        ZZZ_DT_BOL(&elm_filter),                ZZZ_TAIL },
    {"weedout",		        ZZZ_DT_PATH(&weedlist),                 ZZZ_TAIL },
    {"weedout-without-title",   ZZZ_DT_PATH(&weedlist_no_title),        ZZZ_TAIL },
};

const size_t NUMBER_OF_SAVEABLE_OPTIONS=(sizeof(save_info_data)/sizeof(ZZZ_SAVE_TYPE));
save_info_recs *save_info = (save_info_recs *) save_info_data;
#else
extern save_info_recs *save_info;
extern const size_t NUMBER_OF_SAVEABLE_OPTIONS;
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
