/* $Id: mpar_imp.h,v 2.6 2020/12/02 07:16:29 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

typedef void mpar_alloc P_((struct mime_parser_data *D));
typedef void mpar_free  P_((struct mime_parser_data *D));
typedef int  mpar_parse P_((struct mime_parser_data *D,
			    struct mimeinfo *s,
			    charset_t defcharset,
			    FILE *fp,
			    struct header_errors **header_error,
			    int header_status,
			    struct header_rec * hdr));

typedef int mpar_subparts P_((struct mime_parser_data *D));
typedef struct mimeinfo *mpar_index P_((struct mime_parser_data *P,
					int idx));

typedef void mpar_copy P_((struct mime_parser_data *T,
			   struct mime_parser_data *S));

struct mime_parser {
    mpar_alloc         * alloc_data;
    mpar_free          * free_data;
    mpar_parse         * parse_data;

    mpar_subparts      * count_subparts;
    mpar_index         * index_subpart;
    mpar_copy          * copy_data;
};

struct mime_parser_data {
    unsigned short magic;  /* MPAR_magic */
    struct mime_parser    * parser_code;

    struct mailcap_entry  **mailcap_entries;               /* VECTOR */
    int                     mailcap_entry_count;

    union mime_parser_info {
	void                   *any;
	struct mpar_multipart  *multipart;
	struct mpar_rfc822     *rfc822;
    } p;
};


/* mpar_rfc822.c -------------------------------------------------------- */

extern void register_rfc822_parser P_((void));

/* mpar_multipart.c ----------------------------------------------------- */

extern void register_multipart_parser P_((void));

/* mpar_leaf.c ---------------------------------------------------------- */
extern void register_leaf_parser P_((void));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
