/* $Id*/

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#define MAILCAP_PARAM_magic     0xF401

struct mailcap_vector {
    unsigned short magic;                /* MAILCAP_PARAM_magic */                                

    struct agv1 {
	enum arg_type { mv_literal,
			mv_filename, mv_type, mv_parameter,
			mv_environ     /* Environment variable inside of " */
	} type;

	struct arg {
	    int  arg_len;
	    int  alloced;
	    char * arg;
	} arg;

	char quote_char;  /* quote character for printing mailcap entry */
	
    } * subvector;
    int subcount;
};

#define MAILCAP_magic           0xF400
struct mailcap_entry {
    unsigned short magic; /* MAILCAP_magic */

    struct mailcap_vector    * view_command;
    int                        view_command_len;

    struct mailcap_vector    * test_command;
    int                        test_command_len;

    
    /* TODO commands:
       compose
       composetyped
       edit
       print
    */

    unsigned int              needsterminal : 1;
    unsigned int              copiousoutput : 1;
    unsigned int              blacklisted   : 1;

    char *               view_command_ok;  /* not blacklisted */

    char *               extension;

};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
