/* $Id: hdr_imp.h,v 2.7 2020/11/15 16:02:34 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

typedef struct string * hdr_decode_from_header P_((header_list_ptr hdr,
						   int demime,
						   charset_t defcharset));

typedef int hdr_add_to_mailing_hdr P_((struct mailing_headers * headers,
				       header_ptr X,
				       const char *value,
				       int demime,
				       charset_t defcharset,
				       int replace));

struct header_info {
    char * header;
    
    hdr_decode_from_header    * hdr_decode_from_it;
    hdr_add_to_mailing_hdr    * hdr_add_to_it;
};


#define MAIL_HDR_magic          0xFC01
#define EXP_ADDR_magic          0xFC02

extern int add_from_hdr P_((struct mailing_headers * headers,
			    header_ptr X,
			    const char *value,
			    int demime,
			    charset_t defcharset,
			    int replace));
extern int add_date_hdr  P_((struct mailing_headers * headers,
				header_ptr X,
				const char *value,
				int demime,
				charset_t defcharset,
				int replace));
extern int add_to_hdr P_((struct mailing_headers * headers,
			  header_ptr X,
			  const char *value,
			  int demime,
			  charset_t defcharset,
			  int replace));
extern int add_cc_hdr P_((struct mailing_headers * headers,
			  header_ptr X,
			  const char *value,
			  int demime,
			  charset_t defcharset,
			  int replace));
extern int add_bcc_hdr P_((struct mailing_headers * headers,
			   header_ptr X,
			   const char *value,
			   int demime,
			   charset_t defcharset,
			   int replace));
extern int add_replyto_hdr P_((struct mailing_headers * headers,
			       header_ptr X,
			       const char *value,
			       int demime,
			       charset_t defcharset,
			       int replace));
extern int add_subject_hdr P_((struct mailing_headers * headers,
			       header_ptr X,
			       const char *value,
			       int demime,
			       charset_t defcharset,
			       int replace));
extern int add_xmailer_hdr P_((struct mailing_headers * headers,
			       header_ptr X,
			       const char *value,
			       int demime,
			       charset_t defcharset,
			       int replace));
extern int add_user_hdr P_((struct mailing_headers * headers,
			    header_ptr X,
			    const char *value,
			    int demime,
			    charset_t defcharset,
			    int replace));
extern int add_env_from_hdr P_((struct mailing_headers * headers,
				header_ptr X,
				const char *value,
				int demime,
				charset_t defcharset,
				int replace));
extern int add_expires_hdr  P_((struct mailing_headers * headers,
				header_ptr X,
				const char *value,
				int demime,
				charset_t defcharset,
				int replace));

extern int add_message_id_hdr P_((struct mailing_headers * headers,
				  header_ptr X,
				  const char *value,
				  int demime,
				  charset_t defcharset,
				  int replace));


extern int add_in_reply_to_hdr P_((struct mailing_headers * headers,
				   header_ptr X,
				   const char *value,
				   int demime,
				   charset_t defcharset,
				   int replace));

extern int add_references_hdr P_((struct mailing_headers * headers,
				  header_ptr X,
				  const char *value,
				  int demime,
				  charset_t defcharset,
				  int replace));


/* ---- */

typedef int env_from_change_hook P_((struct mailer_env_from *X,
				     const char * value));
extern void set_env_from_change_hook P_((env_from_change_hook *hook));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
