/* $Id: hashmark_imp.h,v 2.6 2022/02/12 14:00:06 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

enum hashkeyword_v { hashkeyword_bad = 0,
		     hashkeyword_hashtype,
		     hashkeyword_description,
		     hashkeyword_hostname,
		     hashkeyword_ipaddr,
		     hashkeyword_servicetype,
		     hashkeyword_ver_tls_cert,
		     hashkeyword_req_tls_peername,
		     hashkeyword_userid,
		     hashkeyword_fromaddr,
		     hashkeyword_usermap,
		     hashkeyword_usermapfile,
		     hashkeyword_dir,
		     hashkeyword_default_menu,
		     hashkeyword_hide,
		     hashkeyword_self_cc,
		     hashkeyword_self_bcc,
		     NUM_hashkeyword };



#define HASHMARK_ITEM_magic	0xF51B
						
struct hashmark_item {
    unsigned short magic;   /* HASHMARK_ITEM_magic */
    
    int refcount;
    struct string     * hashmark_name;   /* Duplicate */
    struct string     * description;
    enum hashtype_v   hashtype;

    union hashtypes {
	void                   * dummy;
	struct hashmark_dir    * dir;
	struct hashmark_remote * remote;
    } u;


    unsigned        on_default_menu:1;
    unsigned        hide_hashmark  :1;

};

typedef void hashtype_init_item_f P_((struct hashmark_item *item));
typedef void hashtype_free_item_f P_((struct hashmark_item *item));

/* return 1 if succeed */
typedef int hashtype_parse_kw_value_f P_((const char *filename,int lineno,
					  struct string * rest_S,
					  struct hashmark_item *item,
					  enum hashkeyword_v kw,
					  struct string * value,
					  enum record_mode rc,
					  const struct schedule_timelimit * now));
typedef int hashtype_parse_kw_f P_((const char *filename,int lineno,
				    struct string * rest_S,
				    struct hashmark_item *item,
				    enum hashkeyword_v kw,
				    enum record_mode rc,
				    const struct schedule_timelimit * now));

typedef int hashtype_parse_check_f P_((const char *filename,int lineno,
				       struct hashmark_item *item,
				       enum record_mode rc,
				       const struct schedule_timelimit * now));

/* Returns 1 if succesfull or nothing to do
   Returns 0 on conversion failure
*/
typedef int hashtype_dump_kw_f P_((FILE *F,
				   struct hashmark_item *item,
				   enum hashkeyword_v kw,
				   charset_t fileset,
				   const char * sysnam,
				   enum record_mode rc));

typedef void hashtype_merge_f P_((struct hashmark_item *item,
				  const struct hashmark_item * base,
				  const struct hashmark_item * overwrite));

typedef int  hashtype_browser_flags_f P_((const struct hashmark_item *item));

typedef void hashtype_init_data_f P_((const struct hashmark_item *item,
				      union hashmark_data      * hashmark_data));
typedef void hashtype_free_data_f P_((const struct hashmark_item *item,
				      union hashmark_data      * hashmark_data));

typedef int  hashtype_browser_changedir_f P_((struct hashmark_item       * item,
					      struct folder_browser      * dir,
					      union hashmark_data        * hashmark_data,
					      const struct string        * path_tail,
					      struct string             ** dispname));


/* returns 1 on succeed */
typedef int hashtype_passhm_verify_ra_con_f P_((const struct hashmark_item * 
						item,
						struct browser_passhm *passhm,
						struct remote_account *C));

/*  Return 1 if succeed, 
    caller does remote_account_init_tls()
*/
typedef int hashtype_passhm_open_ra_f P_((const struct hashmark_item * item,
					  struct browser_passhm      * passhm,
					  struct remote_account      * ra,
					  const PORTS                  default_portlist[],
					  int                          give_service_entry_flag,
					  PORTS                        force_port));

/*  Return 1 if succeed, 
    caller does remote_account_init_tls()
*/
typedef int hashtype_passhm_open_ra2_f P_((const struct hashmark_item * item,
					   struct browser_passhm      * passhm,
					   struct remote_account      * ra,
					   int                          give_service_entry_flag,
					   
					   /* For enumerate_service_type */
					   struct enum_service_type   * est
					   ));


/* Return 1 if succeed */
typedef int hashtype_selectbr_item_f P_((struct hashmark_item  * item,
					 struct folder_browser * dir,
					 union hashmark_data   * hashmark_data,
					 const struct string   * path_tail,
					 struct string        ** dispname,
					 int                   * newpos));
				    
typedef struct folder_info * hashtype_folder_from_browser_f
    P_((struct hashmark_item  * item,
	struct folder_browser * dir,
	union hashmark_data   * hashmark_data,
	int                     treat_as_spooled));

/* -1 == use fallback
    0 == lookup failed
    1 == ok

    caller must free *se, *username, *hostname
*/

typedef int hashtype_remote_lookup_f P_((const struct hashmark_item * item,
					 struct service_entry      ** se,
					 int                          lookup_flags,
					 char                      ** username,
					 char                      ** hostname,
					 struct address            ** addr,
					 int                        * useraddr_flags,
					 struct cancel_data         ** cancel_p
					 /* May be NULL,
					    Used if dns lookup was
					    cancelable */

					 ));

/* Return 1 if succeed */
typedef int hashtype_selection_is_folder_f P_((struct hashmark_item  * item,
					       struct folder_browser * dir,
				       union hashmark_data   * hashmark_data,
					       struct folder_info    * folder));

typedef enum haskmark_valid_v hashtype_valid_on_user_f
    P_((const struct hashmark_item  * item));


/* Return 1 if succeed, changes browser type */
typedef int hashtype_prepare_write_item_f P_((struct hashmark_item  * item,
					      struct folder_browser * dir,
				      union hashmark_data   * hashmark_data,
					      WRITE_STATE             ptr));


/* Return directory prefix and l_item,
   changes browser type
*/
typedef struct string * hashtype_cat_hashmark_item_f
    P_((struct hashmark_item  * h_item,
	struct folder_browser * dir,
	union hashmark_data   * hashmark_data,
	const struct string   * l_item));

#define HASHTYPE_ACTIONS_magic  0xF51C

extern struct hashtype_actions {
    unsigned short magic;  /* HASHMARK_ITEM_magic */

    hashtype_init_item_f            * init_it;
    hashtype_free_item_f            * free_it;
    hashtype_parse_kw_value_f       * parse_kw_value;
    hashtype_parse_kw_f             * parse_kw;
    hashtype_parse_check_f          * parse_check;
    hashtype_dump_kw_f              * dump_kw;
    hashtype_merge_f                * merge;
    hashtype_browser_flags_f        * browser_flags;
    hashtype_init_data_f            * init_data;
    hashtype_free_data_f            * free_data;
    hashtype_browser_changedir_f    * browser_changedir;
    hashtype_passhm_verify_ra_con_f * passhm_verify_ra_con;
    hashtype_passhm_open_ra_f       * passhm_open_ra;
    hashtype_selectbr_item_f        * browser_select_item;
    hashtype_folder_from_browser_f  * folder_from_browser;
    hashtype_remote_lookup_f        * remote_lookup;
    hashtype_selection_is_folder_f  * selection_is_folder;
    hashtype_valid_on_user_f        * valid_on_user;
    hashtype_prepare_write_item_f   * prepare_write;
    hashtype_cat_hashmark_item_f    * cat_hashmark;
    hashtype_passhm_open_ra2_f      * passhm_open_ra2;
    
} hashtype_folder_dir_action, hashtype_local_dir_action;

#if defined(I_NETINET_IN) && defined(I_ARPA_INET)
extern struct hashtype_actions hashtype_remote_mbx_action;
#endif

extern void inc_hashmark_item_refcount P_((struct hashmark_item *item));
extern void free_hashmark_item P_((struct hashmark_item **item));

extern const char * hashmark_Keyword P_((enum hashkeyword_v kw));
extern const char * hashmark_Hashtype P_((enum hashtype_v t));
extern int hashmark_is_printableln P_((const char *filename,int lineno,
				       const struct string * rest_S));

extern int dump_string_quote_helper P_((FILE *f,charset_t fileset,
					const char * sysnam,
					enum hashkeyword_v kw,
					const struct string *value,
					int x));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

