/* $Id: fbrowser.h,v 2.4 2014/07/14 15:07:25 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/




/* Private API between src/fbrowser.c and lib/mbox/localmbx.c */

#define FBENTRY_magic		0xF50D

struct fbentry {
    unsigned short   magic;          /* FBENTRY_magic */   

    char            *name;           /*  entry name   */
    struct string   *display_name;

    mode_t          mode;            /* st_mode       */
    uid_t           uid;             /* st_uid        */
    off_t           size;            /* st_size       */
    time_t          mtime;           /* st_mtime      */
};


extern const struct fbentry * fbrowser_give_entry P_((struct folder_browser *dir,
						      int idx));

extern int fbrowser_supported_on_dir P_((struct folder_browser *dir));

extern int fbrowser_selection_have_access P_((struct folder_browser *dir,
					      int acc_mode,
					      int print_error));

extern int fbrowser_selection_is_mbox P_((struct folder_browser *dir,
					  int print_error));

extern void fbrowser_set_dotmode  P_((struct folder_browser *dir,
				      int dotmode));


extern int fbrowser_make_directory P_((struct folder_browser *dir,
				       const struct string *name,
				       int *pos));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

