/* $Id: defs_major.h,v 2.13 2021/07/13 07:58:36 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Copied from defs.h. It have following copyright:
 *
 *  The Elm Mail System
 *
 *                      Copyright (c) 1988-1992 USENET Community Trust
 *                      Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <signal.h>

#include <sys/stat.h>

#include <sys/types.h>	/* for fundamental types */
#include "../config.h"  
#include "sysdefs.h"	/* system/configurable defines */

# define VERSION	"ME+ 2.5"		/* Version number... */

#if __GNUC__ 
/* GCC __attribute__((used)) for variables appeared GCC 4.2 
 *
 * http://gcc.gnu.org/onlinedocs/gcc-4.2.4/gcc/Variable-Attributes.html#Variable-Attributes
 */
#if (__GNUC__ > 4) || (__GNUC__ == 4) && (__GNUC_MINOR__ >= 2)
#define FORIDENT __attribute__((used,unused)) 
#else
#define FORIDENT __attribute__((unused)) 
#endif
#define UNUSED_VAROK __attribute__((unused))
#define UNUSED_FUNCOK __attribute__((unused))
#else
#define FORIDENT
#define UNUSED_VAROK
#define UNUSED_FUNCOK
#endif


#if defined(__STDC__) || defined(_AIX)
# define ANSI_C 1
#endif

#if ANSI_C 
#define P_(x) x
#else

#ifndef volatile
#define volatile
#endif

#ifndef const
#define const
#endif

#define P_(x) ()
#endif

/* FIXME:   Change  MALLOCVOID to ANSI_C */
#ifdef MALLOCVOID
typedef	void *	malloc_t;
#else
typedef	char *	malloc_t;
#endif

#ifdef ANSI_C
# include <stdlib.h>
#else
extern	malloc_t	calloc();
extern	int		free();
extern	malloc_t	malloc();
extern	malloc_t	realloc();
extern	void		exit();
extern char		*getenv();
extern long             atol();
extern int              putenv();
extern int              atoi();
extern long             strtol();
extern void             qsort();
extern int              atexit();
extern int              putenv();
#endif

#ifdef STRINGS
#  include <strings.h>
#else
#  if defined(_CONVEX_SOURCE) && defined(index)
#    undef _CONVEX_SOURCE
#    include <string.h>     /* Now there is no proto for index. */
#    define _CONVEX_SOURCE
#  else
#    include <string.h>
#  endif
#endif

#if defined(HASWAITPID) || defined(BSD_TYPE) 
#include <sys/wait.h>
#endif

/* FIXME:   Change  I_UNISTD to ANSI_C */
#ifdef I_UNISTD
#include <unistd.h>
#endif

#ifndef	ANSI_C
unsigned sleep();
char *index(), *rindex(); /* names will be traslated by define in config.h */
char *strcpy(), *strcat(), *strncpy(); /* more in string.h in ANSI */
long lseek();
int fseek();
char *getlogin();
unsigned alarm();
#ifndef I_UNISTD
unsigned short getgid(), getuid(); 
#endif
char *cuserid();

#ifdef GETUSERSHELL
char *getusershell();
#endif

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
