/* $Id: aliaslib.h,v 2.13 2024/06/10 18:05:34 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#if ANSI_C
struct aliases_map;
struct address_alias;
#endif

/* ------------------------------------------------------------------------- */

/* init.c */

extern struct aliases_map      * system_aliases_map;
extern charset_t                 system_aliases_cs;
extern struct editor_propline  * system_aliases_pl;

extern struct aliases_map      * user_aliases_map;
extern charset_t                 user_aliases_cs;
extern struct editor_propline  * user_aliases_pl;
extern struct file_changes       user_aliases_change;

extern int                       user_aliases_needwrite;

extern ENUMERATE editor_al_propline;   /* 0 = auto
					  1 = emacs
					  2 = ignore
				       */

extern void init_aliaslib P_((int read_flags /* READ_FLAG_IGNORE_MISSING */));

/* lib/misc/oldaliases.c */

extern struct aliases_map * load_old_aliases_map P_((const char *filename));

extern void delete_old_alias_files P_((char *)); 

/* aliases operations ------------------------------------------------------ */


extern struct aliases_map * load_aliases_map P_((const char *filename, 
						 int *errors,
						 charset_t *fileset,
						 struct editor_propline 
						 **propline,
						 int *suggest_rewrite,
						 struct file_changes *file_information));

extern int merge_aliases_map P_((const char              * filename,
				 FILE                    * f,
				 struct aliases_map      * map,
				 int                     * errors,
				 charset_t               * fileset,
				 struct editor_propline ** propline,
				 int                     * suggest_rewrite,
				 int                     * need_update  /* sets 1 if map was updated */,
				 struct file_changes     * file_information
				 ));

extern void free_aliases_map P_((struct aliases_map **map));

extern int aliases_map_item_count P_((struct aliases_map *map));

extern int dump_aliases_map P_((FILE *f, struct aliases_map *map,
				FILE *commentfile,
				const char *actor,
				char *version_buff,
				charset_t fileset,
				const struct editor_propline *propline,
				struct file_changes *file_information,
				int *errno_res));

/* Creates empty map */
extern struct aliases_map * new_aliases_map P_((void));


/* Address alaises --------------------------------------------------------- */

extern void free_address_alias P_((struct address_alias **alias));

extern struct address_alias * dup_address_alias P_((const struct address_alias *alias));

extern const struct address_alias * 
  aliases_map_get_alias P_((const struct aliases_map *map,
			    int idx, const struct string **key));

extern const struct address_alias * 
  aliases_map_lookup_alias P_((struct aliases_map *map,
			       const struct string *key,
			       int *idx));

/* Replaces existing aliases */
extern void aliases_map_add_alias P_((struct aliases_map *map,
				     const struct string *key,
				     const struct address_alias *alias));

extern int aliases_map_deleted_alias P_((struct aliases_map *map,
					 int idx));

extern int aliases_map_remove_alias P_((struct aliases_map *map,
					const struct string *key));


extern void aliases_map_remove_index P_((struct aliases_map *map,
					 int idx));

/* Alias vector operations ------------------------------------------------ */

extern struct alias_vector * new_alias_vector P_((void));
extern void alias_vector_add_alias P_((struct alias_vector *vector,
				       const struct string *alias));
extern int alias_vector_item_count P_((const struct alias_vector *vector));
extern const struct string * alias_vector_get_alias P_((const struct alias_vector *vector,
							int idx));
extern void free_alias_vector P_((struct alias_vector **vector));


/* address alias operations ------------------------------------------------ */

extern struct address_alias * new_person_address_alias P_((const struct string *firstn,
							   const struct string *lastn,
							   const struct string *comment,
							   const struct address *address));
extern struct address_alias * new_list_address_alias P_((const struct string * comment,
							 const struct addr_list *list));
extern struct address_alias * new_group_address_alias P_((const struct string *phrase,
							  const struct string *comment,
							  const struct alias_vector * aliases));

extern struct address_alias * new_address_alias P_((const struct string *firstn,
						    const struct string *lastn,
						    const struct string *comment,
						    const struct string *phrase,
						    const struct addr_list *list,
						    const struct alias_vector * aliases));


/* Returns 1 if person alias */
extern int address_alias_get_person P_((const struct address_alias *alias,
					const struct string **firstn,
					const struct string **lastn,
					const struct address **address));

extern const struct string * address_alias_get_comment P_((
       const struct address_alias *alias));

extern const struct addr_list * address_alias_get_list P_((
        const struct address_alias *alias));

/* Returns 1 if group alias */
extern int address_alias_get_group P_((const struct address_alias *alias,
				       const struct string **phrase,
				       const struct alias_vector **vector));


/* Address alias editing oprations *-------------------------------------------- */

/* Removes old person alias */
extern void set_person_address_alias P_(( struct address_alias *alias,
					  const struct string *firstn,
					  const struct string *lastn,
					  const struct address *address));
/* Removes old list */
extern void set_list_address_alias P_((struct address_alias *alias,
				       const struct addr_list *list));


extern void set_group_address_alias P_((struct address_alias *alias,
					const struct string *phrase,
					const struct alias_vector * aliases));

extern void set_alias_comment  P_((struct address_alias *alias,
				   const struct string *comment));

/* Alias expansion -------------------------------------------------------- */

enum alias_address_expand_result  {
    alias_expand_fail = 0,
    alias_expand_ok,
    alias_expand_local_fill  /* Local address filled, not expanded */,
    alias_expand_local_dummy /* Local address filled, not verified */
};

union alias_stack_item {
    struct aliases_map   * alias_map;
    struct mailer_info   * localmailer;      
    void                 * dummy_arg;
};

typedef int alias_stack_lookup_f P_((union alias_stack_item     value,
				     const struct string         *alias,
				     const struct address_alias **result_alias,
				     /* Caller must free result_list */
				     struct addr_list          **result_list,
				     enum alias_address_expand_result * expand_result));


extern int alias_simple_lookup P_((union alias_stack_item     value,
				   const struct string       *alias,
				   const struct address_alias **result_alias,
				   /* Caller must free result_list */
				   struct addr_list          **result_list,
				   enum alias_address_expand_result * expand_result));




extern struct alias_stack *     new_alias_stack P_((void));

extern void   add_lookup_to_alias_stack P_((struct alias_stack      *stack,
					    alias_stack_lookup_f    *lookup,
					    union alias_stack_item   value));


extern void   free_alias_stack P_((struct alias_stack **ptr));




extern struct addr_list * aliases_expand_alias P_((struct alias_stack      *stack,
						   const struct string     *alias,
						   enum alias_address_expand_result * expand_result));


extern const struct address_alias * aliases_get_alias P_((struct alias_stack    *stack,
							  const struct string   *alias));

extern struct addr_list * aliases_expand_alias_proto P_((struct alias_stack   * stack,
							 const struct address_alias *alias));



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
