case $CONFIG in
'')
    if test ! -f config.sh; then
        ln ../config.sh . || \
        ln ../../config.sh . || \
        ln ../../../config.sh . || \
        (echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac

    vpathdef="#VPATH = "
    XXsrcroot="."
    regarg=
    ;;
*)
    vpathdef="VPATH = $source_dir/$subdir"
    XXsrcroot="$source_dir"
    regarg="-A \"$source_dir/\""
    ;;
esac

vardir=`dirname $stage_dir`  

case "$i_locale" in
define)
	localetarget='$(ETC)/elm.mimecharsets $(ETC)/elm.terminalinfo'
	;;
*)
	localetarget=
	;;
esac

echo "Extracting Makefile-1 (with variable substitutions)"
cat >Makefile-1 <<!GROK!THIS!
#!$make
#
# $Id: Makefile-1.SH,v 2.19 2023/12/13 16:55:31 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#  	   	   (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
#      or  Kari Hurtta <elm@elmme-mailer.org>
#
#
REG	= bin/elmregister $regarg
LIB		=	\$(ELM_ROOT)//$lib
ETC		=	\$(ELM_ROOT)//$etc
BINTARG		=	\$(ELM_ROOT)//$bin
BIN		=	bin
STAGE		=	\$(ELM_ROOT)//$stage_dir
LOCALETARG	=	$localetarget
CHMOD		=	$chmod
STAGEP          = 	\$(ELM_ROOT)//$vardir
$vpathdef
SRCROOT		=	$XXsrcroot
!GROK!THIS!

cat >>Makefile-1 <<'!NO!SUBS!'

DOC		= $(SRCROOT)/doc
CONFTOOL        = $(SRCROOT)/ConfTool
CHARSET		= $(SRCROOT)/charset

all:
lint:
clean:

uninstall_s: 
	$(REG) rm -f $(LOCALETARG) $(LIB)/elm.map.bin/unidata.bin

install_s: Makefile-1 $(LIB) $(ETC) $(STAGE) cleanup-config  \
  $(ETC)/elm.rc $(LOCALETARG) \
  $(LIB)/elm.map.bin/unidata.bin $(LIB)/elm.map.bin/bindata.bin \
  $(ETC)/elm.mimetypes $(ETC)/elm.mailinglists $(ETC)/elm.aliases \
  $(ETC)/elm.mailservices $(ETC)/elm.hashmarks \
  $(ETC)/elm.tagfilter.entities libreg 

Makefile-1: Makefile-1.SH config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

cleanup-config: $(LIB)/elmconfwriter doc-info
		$(REG) -s doc {$(LIB)/elmconfwriter} -c {$(ETC)/elm.rc.old-values}

$(ETC)/elm.rc:	$(LIB)/elmrc-write $(DOC)/elmrc-info 
		$(REG) -s doc {$(LIB)/elmrc-write} -G -I -C {$(DOC)/elmrc-info} \
 -c {$(ETC)/elm.rc.old-values}
		$(REG) $(CHMOD) u=rw,go=r {$@}

$(LIB)/elm.map.bin/unidata.bin: $(LIB) $(LIB)/elm.map.bin \
 $(CHARSET)/UNIDATA/UnicodeData-Latest.txt $(LIB)/elmunidata 
		$(REG) -s unidata {$(LIB)/elmunidata} -G -I -s {$(CHARSET)/UNIDATA/UnicodeData-Latest.txt} 
		$(REG) -s unidata true {$(CHARSET)/UNIDATA/ReadMe.txt}

$(LIB)/elm.map.bin/bindata.bin: $(LIB) $(LIB)/elm.map.bin $(LIB)/elmbindata  \
 $(ETC)/elm.mimecharsets
		$(REG) -s mappings {$(LIB)/elmbindata} -G -I \
  -S {$(CHARSET)/MAPPINGS/ISO8859} -S {$(CHARSET)/MAPPINGS} \
  -S {$(CHARSET)/MAPPINGS/MICSFT} 

$(ETC)/elm.mimecharsets: $(BIN)/elm.mimecharsets $(LIB)/elmcharset \
 $(CONFTOOL)/killsets $(LIB)/elm.map.txt $(ETC)/elm.mimecharsets.NEW \
 $(DOC)/elmmimecharsets-info $(ETC)/elm.iso2022sets
		$(REG) -s mappings {$(LIB)/elmcharset} -G \
 -C {$(DOC)/elmmimecharsets-info} -I {$(CONFTOOL)/killsets} -c \
  -S {$(CHARSET)/MAPPINGS/ISO8859} -S {$(CHARSET)/MAPPINGS} \
  -S {$(CHARSET)/MAPPINGS/MICSFT} {$(BIN)/elm.mimecharsets} 
		$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.mimecharsets.NEW: $(BIN)/elm.mimecharsets \
 $(LIB)/elmcharset $(CONFTOOL)/killsets $(LIB)/elm.map.txt \
 $(DOC)/elmmimecharsets-info $(ETC)/elm.iso2022sets
		$(REG) -s mappings {$(LIB)/elmcharset} -G \
 -C {$(DOC)/elmmimecharsets-info} -I {$(CONFTOOL)/killsets} -w {$@} \
  -S {$(CHARSET)/MAPPINGS/ISO8859} -S {$(CHARSET)/MAPPINGS} \
  -S {$(CHARSET)/MAPPINGS/MICSFT} {$(BIN)/elm.mimecharsets} 

$(ETC)/elm.mimetypes: $(BIN)/elm.mimetypes $(LIB)/elmmimetypes \
 $(ETC)/elm.mimetypes.NEW $(DOC)/elmmimetypes-info \
 $(CONFTOOL)/killmimetypes
	$(REG) -s mappings {$(LIB)/elmmimetypes} -G \
 -C {$(DOC)/elmmimetypes-info} -I {$(CONFTOOL)/killmimetypes} -c \
 {$(BIN)/elm.mimetypes} 
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.mimetypes.NEW: $(BIN)/elm.mimetypes $(LIB)/elmmimetypes \
 $(DOC)/elmmimetypes-info $(CONFTOOL)/killmimetypes
	$(REG) -s mappings {$(LIB)/elmmimetypes} -G \
 -C {$(DOC)/elmmimetypes-info} -I {$(CONFTOOL)/killmimetypes} \
 -w {$@} \
 {$(BIN)/elm.mimetypes}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.mailinglists: $(BIN)/elm.mailinglists \
 $(LIB)/elmmailinglists $(ETC)/elm.mailinglists.NEW \
 $(DOC)/elmmailinglists-info
	$(REG) -s mailinglists {$(LIB)/elmmailinglists} -G \
 -C {$(DOC)/elmmailinglists-info} -c {$(BIN)/elm.mailinglists} 
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.mailinglists.NEW: $(BIN)/elm.mailinglists $(LIB)/elmmailinglists \
 $(DOC)/elmmailinglists-info 
	$(REG) -s mailinglists {$(LIB)/elmmailinglists} -G \
 -C {$(DOC)/elmmailinglists-info} -w {$@} {$(BIN)/elm.mailinglists} 
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.mailservices: $(BIN)/elm.mailservices $(LIB)/elmmailservices \
 $(ETC)/elm.mailservices.NEW $(DOC)/elmmailservices-info
	$(REG) -s mailservices {$(LIB)/elmmailservices} -G \
 -C {$(DOC)/elmmailservices-info} -c {$(BIN)/elm.mailservices}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.mailservices.NEW: $(BIN)/elm.mailservices $(LIB)/elmmailservices \
 $(DOC)/elmmailservices-info
	$(REG) -s mailservices {$(LIB)/elmmailservices} -G \
 -C {$(DOC)/elmmailservices-info} -w {$@} {$(BIN)/elm.mailservices}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.aliases: $(BIN)/elm.aliases \
 $(LIB)/elmaliases-write $(ETC)/elm.aliases.NEW convert-old-aliases \
 $(DOC)/elmaliases-info
	$(REG) -s aliases {$(LIB)/elmaliases-write} -G \
 -C {$(DOC)/elmaliases-info} -c \
 {$(BIN)/elm.aliases} 
	$(REG) $(CHMOD) u=rw,go=r {$@}

convert-old-aliases: $(BINTARG)/newalias
	$(REG) {$(BINTARG)/newalias} -g -q

$(ETC)/elm.aliases.NEW: $(BIN)/elm.aliases $(LIB)/elmaliases-write \
 $(DOC)/elmaliases-info
	$(REG) -s aliases {$(LIB)/elmaliases-write} -G \
 -C {$(DOC)/elmaliases-info} -w {$@} \
 {$(BIN)/elm.aliases} 
	$(REG) $(CHMOD) u=rw,go=r {$@}


$(ETC)/elm.terminalinfo: $(BIN)/elm.terminalinfo $(LIB)/elmterminal \
 $(ETC)/elm.mimecharsets $(ETC)/elm.terminalinfo.NEW \
 $(DOC)/elmterminalinfo-info
	$(REG) -s terminal {$(LIB)/elmterminal} -G \
 -C {$(DOC)/elmterminalinfo-info} -c \
 {$(BIN)/elm.terminalinfo}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.terminalinfo.NEW: $(BIN)/elm.terminalinfo \
 $(LIB)/elmterminal $(ETC)/elm.mimecharsets \
 $(DOC)/elmterminalinfo-info
	$(REG) -s terminal {$(LIB)/elmterminal} -G \
 -C {$(DOC)/elmterminalinfo-info} -w {$@} {$(BIN)/elm.terminalinfo}

$(ETC)/elm.iso2022sets: $(BIN)/elm.iso2022sets $(LIB)/elmiso2022sets \
 $(DOC)/elmiso2022sets-info \
 $(ETC)/elm.iso2022sets.NEW
	$(REG) -s mappings {$(LIB)/elmiso2022sets} -G \
 -C {$(DOC)/elmiso2022sets-info} -c \
 -S {$(CHARSET)/MAPPINGS/JIS} {$(BIN)/elm.iso2022sets}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.iso2022sets.NEW: $(BIN)/elm.iso2022sets $(LIB)/elmiso2022sets \
 $(DOC)/elmiso2022sets-info
	$(REG) -s mappings {$(LIB)/elmiso2022sets} -G \
 -C {$(DOC)/elmiso2022sets-info} -w {$@} \
 -S {$(CHARSET)/MAPPINGS/JIS} {$(BIN)/elm.iso2022sets}

$(ETC)/elm.hashmarks: $(BIN)/elm.hashmarks $(LIB)/elmhashmarks \
  $(LIB)/elm.user.map $(DOC)/elmhashmarks-info $(ETC)/elm.hashmarks.NEW
	$(REG) -s hashmarks {$(LIB)/elmhashmarks} -G \
  -C {$(DOC)/elmhashmarks-info} -c \
  -S {$(DOC)/elm.user.map} {$(BIN)/elm.hashmarks}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.hashmarks.NEW: $(BIN)/elm.hashmarks $(LIB)/elmhashmarks \
    $(LIB)/elm.user.map $(DOC)/elmhashmarks-info 
	$(REG) -s hashmarks {$(LIB)/elmhashmarks} -G \
  -C {$(DOC)/elmhashmarks-info} -w {$@} \
  -S {$(DOC)/elm.user.map} {$(BIN)/elm.hashmarks}

$(ETC)/elm.tagfilter.entities: $(BIN)/elm.tagfilter.entities $(LIB)/elmtagfilterents \
  $(DOC)/elmtagfilent-info $(ETC)/elm.tagfilter.entities.NEW
	$(REG) -s mappings {$(LIB)/elmtagfilterents} -G \
 -C {$(DOC)/elmtagfilent-info} -c {$(BIN)/elm.tagfilter.entities}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(ETC)/elm.tagfilter.entities.NEW: $(BIN)/elm.tagfilter.entities $(LIB)/elmtagfilterents \
  $(DOC)/elmtagfilent-info
	$(REG) -s mappings {$(LIB)/elmtagfilterents} -G \
 -C {$(DOC)/elmtagfilent-info} -w {$@} {$(BIN)/elm.tagfilter.entities}
	$(REG) $(CHMOD) u=rw,go=r {$@}

$(LIB):
		$(REG) mkdir $(LIB)

$(LIB)/elm.map.bin: 
		$(REG) mkdir $(LIB)/elm.map.bin

$(LIB)/elm.map.txt:
		$(REG) mkdir $(LIB)/elm.map.txt

$(LIB)/elm.user.map:
		$(REG) mkdir $(LIB)/elm.user.map

$(STAGE):	$(STAGEP)
		$(REG) mkdir $(STAGE)

$(STAGEP):
		$(REG) mkdir $(STAGEP)

doc-info:
		cd doc; $(MAKE) $(MJ) $(MFLAGS) info-list

!NO!SUBS!


case "$d_dlopen_libs" in
define)  
	 aa=
	 if $test "$shared_register" != none ; then
	    aa="$shared_register"
	 fi
cat >>Makefile-1 <<!SUBS!

# Register new libraries and unregister removed libraries
# Also libraries which are not loadable are unregistered
libreg: \$(LIB)/elmlibregister \$(LIB)/elmrc-write doc-info
	\$(REG) {\$(LIB)/elmlibregister} -G -I -c {\$(ETC)/elm.rc.old-values}
!SUBS!
	for domake in $aa ; do
	    cat >>Makefile-1 <<!SUBS!
	\$(REG) -M "$domake" {\$(LIB)/elmlibregister} -G -I -c {\$(ETC)/elm.rc.old-values} $domake
!SUBS!
	done

	cat >>Makefile-1 <<'!NO!SUBS!'	
	$(REG) -M all -s doc {$(LIB)/elmrc-write} -G -I \
 -c {$(ETC)/elm.rc.old-values} -E {$(ETC)/elm.rc.old-values}
!NO!SUBS!
	 ;;
*)	 

cat >>Makefile-1 <<'!NO!SUBS!'

libreg:
!NO!SUBS!
	;;
esac
